/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.reader;

import java.awt.geom.Area;
import org.esa.smos.dataio.smos.GridPointInfo;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.ee2netcdf.reader.AbstractProductTypeSupport;
import org.esa.smos.ee2netcdf.reader.ArrayCache;
import org.esa.smos.ee2netcdf.reader.VariableValueProvider;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.util.StringUtils;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

class L2ProductSupport
extends AbstractProductTypeSupport {
    private final double chi_2_scale;

    L2ProductSupport(NetcdfFile netcdfFile) {
        super(netcdfFile);
        String chi2ScaleString;
        Attribute chi2ScaleAttribute = netcdfFile.findGlobalAttribute("Variable_Header:Specific_Product_Header:Chi_2_Scale");
        this.chi_2_scale = chi2ScaleAttribute != null ? (StringUtils.isNotNullAndNotEmpty((String)(chi2ScaleString = chi2ScaleAttribute.getStringValue())) ? Double.valueOf(chi2ScaleString) : 1.0) : 1.0;
    }

    @Override
    public String getLatitudeBandName() {
        return "Latitude";
    }

    @Override
    public String getLongitudeBandName() {
        return "Longitude";
    }

    @Override
    public boolean canOpenFile() {
        return this.containsVariable("Latitude") && this.containsVariable("Longitude") && this.containsVariable("Grid_Point_ID");
    }

    @Override
    public void setScalingAndOffset(Band band, BandDescriptor bandDescriptor) {
        String memberName = bandDescriptor.getMemberName();
        if ("Chi_2".equals(memberName)) {
            band.setScalingFactor(bandDescriptor.getScalingFactor() * this.chi_2_scale);
            band.setScalingOffset(bandDescriptor.getScalingOffset());
        } else {
            super.setScalingAndOffset(band, bandDescriptor);
        }
    }

    @Override
    public AbstractValueProvider createValueProvider(ArrayCache arrayCache, String variableName, BandDescriptor descriptor, Area area, GridPointInfo gridPointInfo) {
        return new VariableValueProvider(arrayCache, variableName, area, gridPointInfo);
    }
}

