/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.reader;

import java.awt.geom.Area;
import java.io.IOException;
import org.esa.smos.dataio.smos.GridPointInfo;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.ee2netcdf.reader.ArrayCache;
import ucar.ma2.Array;
import ucar.ma2.Index;

class BrowseValueProvider
extends AbstractValueProvider {
    private final Area area;
    private final GridPointInfo gridPointInfo;
    private final int polarization;
    private final ArrayCache arrayCache;
    private final String variableName;

    BrowseValueProvider(ArrayCache arrayCache, String variableName, int polarization, Area area, GridPointInfo gridPointInfo) {
        this.area = area;
        this.gridPointInfo = gridPointInfo;
        this.polarization = polarization;
        this.arrayCache = arrayCache;
        this.variableName = variableName;
    }

    public Area getArea() {
        return this.area;
    }

    public int getGridPointIndex(int seqnum) {
        return this.gridPointInfo.getGridPointIndex(seqnum);
    }

    public byte getByte(int gridPointIndex) throws IOException {
        Array array = this.arrayCache.get(this.variableName);
        Index index = array.getIndex();
        index.set(gridPointIndex, this.polarization);
        return array.getByte(index);
    }

    public short getShort(int gridPointIndex) throws IOException {
        Array array = this.arrayCache.get(this.variableName);
        Index index = array.getIndex();
        index.set(gridPointIndex, this.polarization);
        return array.getShort(index);
    }

    public int getInt(int gridPointIndex) throws IOException {
        Array array = this.arrayCache.get(this.variableName);
        Index index = array.getIndex();
        index.set(gridPointIndex, this.polarization);
        return array.getInt(index);
    }

    public float getFloat(int gridPointIndex) throws IOException {
        Array array = this.arrayCache.get(this.variableName);
        Index index = array.getIndex();
        index.set(gridPointIndex, this.polarization);
        return array.getFloat(index);
    }
}

