/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.reader;

import java.awt.geom.Area;
import java.io.IOException;
import org.esa.smos.dataio.smos.GridPointInfo;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.ee2netcdf.reader.AbstractProductTypeSupport;
import org.esa.smos.ee2netcdf.reader.ArrayCache;
import org.esa.smos.ee2netcdf.reader.BrowseValueProvider;
import org.esa.smos.ee2netcdf.reader.VariableValueProvider;
import org.esa.snap.core.datamodel.Band;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

class BrowseProductSupport
extends AbstractProductTypeSupport {
    private final double radAccuracyScale;
    private final double footprintScale;

    BrowseProductSupport(NetcdfFile netcdfFile) {
        super(netcdfFile);
        Attribute radAccuracyAttribute = netcdfFile.findGlobalAttribute("Variable_Header:Specific_Product_Header:Radiometric_Accuracy_Scale");
        this.radAccuracyScale = radAccuracyAttribute != null ? Double.valueOf(radAccuracyAttribute.getStringValue()) : 1.0;
        Attribute footprintScaleAttribute = netcdfFile.findGlobalAttribute("Variable_Header:Specific_Product_Header:Pixel_Footprint_Scale");
        this.footprintScale = footprintScaleAttribute != null ? Double.valueOf(footprintScaleAttribute.getStringValue()) : 1.0;
    }

    @Override
    public String getLatitudeBandName() {
        return "Grid_Point_Latitude";
    }

    @Override
    public String getLongitudeBandName() {
        return "Grid_Point_Longitude";
    }

    @Override
    public boolean canOpenFile() {
        return this.containsVariable("Grid_Point_Latitude") && this.containsVariable("Grid_Point_Longitude") && this.containsVariable("Grid_Point_ID");
    }

    @Override
    public void setScalingAndOffset(Band band, BandDescriptor bandDescriptor) {
        String memberName = bandDescriptor.getMemberName();
        if (memberName.startsWith("Footprint_Axis")) {
            band.setScalingFactor(bandDescriptor.getScalingFactor() * this.footprintScale);
            band.setScalingOffset(bandDescriptor.getScalingOffset());
        } else if (memberName.startsWith("Pixel_Radiometric_Accuracy")) {
            band.setScalingFactor(bandDescriptor.getScalingFactor() * this.radAccuracyScale);
            band.setScalingOffset(bandDescriptor.getScalingOffset());
        } else {
            super.setScalingAndOffset(band, bandDescriptor);
        }
    }

    @Override
    public AbstractValueProvider createValueProvider(ArrayCache arrayCache, String variableName, BandDescriptor descriptor, Area area, GridPointInfo gridPointInfo) {
        int polarization = descriptor.getPolarization();
        if (polarization < 0) {
            return new VariableValueProvider(arrayCache, variableName, area, gridPointInfo);
        }
        return new BrowseValueProvider(arrayCache, variableName, polarization, area, gridPointInfo);
    }

    @Override
    public boolean canSupplyGridPointBtData() {
        return true;
    }

    @Override
    public FlagDescriptor[] getBtFlagDescriptors() {
        try {
            this.ensureDataStructuresInitialized();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.flagDescriptors;
    }
}

