/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.reader;

import java.awt.geom.Area;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.esa.smos.dataio.smos.GridPointBtDataset;
import org.esa.smos.dataio.smos.GridPointInfo;
import org.esa.smos.dataio.smos.PolarisationModel;
import org.esa.smos.dataio.smos.SnapshotInfo;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.ee2netcdf.ExporterUtils;
import org.esa.smos.ee2netcdf.reader.ArrayCache;
import org.esa.smos.ee2netcdf.reader.IdentityScaler;
import org.esa.smos.ee2netcdf.reader.LinearScaler;
import org.esa.smos.ee2netcdf.reader.NetcdfProductReader;
import org.esa.smos.ee2netcdf.reader.ProductTypeSupport;
import org.esa.smos.ee2netcdf.reader.Scaler;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

abstract class AbstractProductTypeSupport
implements ProductTypeSupport {
    protected final NetcdfFile netcdfFile;
    protected ArrayCache arrayCache;
    protected GridPointInfo gridPointInfo;
    protected HashMap<String, Integer> memberNamesMap;
    protected FlagDescriptor[] flagDescriptors;
    private HashMap<String, Scaler> scalerMap;
    protected String[] snapshotDataNames;
    private Class[] tableClasses;

    AbstractProductTypeSupport(NetcdfFile netcdfFile) {
        this.netcdfFile = netcdfFile;
    }

    @Override
    public void initialize(Family<BandDescriptor> bandDescriptors) {
    }

    @Override
    public void setScalingAndOffset(Band band, BandDescriptor bandDescriptor) {
        band.setScalingOffset(bandDescriptor.getScalingOffset());
        band.setScalingFactor(bandDescriptor.getScalingFactor());
    }

    @Override
    public boolean canSupplyGridPointBtData() {
        return false;
    }

    @Override
    public boolean canSupplyFullPolData() {
        return false;
    }

    @Override
    public GridPointBtDataset getBtData(int gridPointIndex) throws IOException {
        Array btDataCountArray;
        Integer incidence_angle;
        Integer bt_value_imag;
        Integer bt_value_real;
        Integer flagsBandIndex;
        this.ensureDataStructuresInitialized();
        GridPointBtDataset gridPointBtDataset = new GridPointBtDataset(this.memberNamesMap, this.tableClasses);
        Integer pixel_radiometric_accuracy = this.memberNamesMap.get("Radiometric_Accuracy_of_Pixel");
        if (pixel_radiometric_accuracy != null) {
            gridPointBtDataset.setRadiometricAccuracyBandIndex(pixel_radiometric_accuracy.intValue());
        }
        if ((flagsBandIndex = this.memberNamesMap.get("Flags")) != null) {
            gridPointBtDataset.setFlagBandIndex(flagsBandIndex.intValue());
            gridPointBtDataset.setPolarisationFlagBandIndex(flagsBandIndex.intValue());
        }
        if ((bt_value_real = this.memberNamesMap.get("BT_Value_Real")) != null) {
            gridPointBtDataset.setBTValueRealBandIndex(bt_value_real.intValue());
        }
        if ((bt_value_imag = this.memberNamesMap.get("BT_Value_Imag")) != null) {
            gridPointBtDataset.setBTValueImaginaryBandIndex(bt_value_imag.intValue());
        }
        if ((incidence_angle = this.memberNamesMap.get("Incidence_Angle")) != null) {
            gridPointBtDataset.setIncidenceAngleBandIndex(incidence_angle.intValue());
        }
        if ((btDataCountArray = this.arrayCache.get("BT_Data_Counter")) != null) {
            int numMeasurements = btDataCountArray.getInt(gridPointIndex);
            Number[][] tableData = new Number[numMeasurements][this.memberNamesMap.size()];
            if (gridPointIndex >= 0) {
                Set<Map.Entry<String, Integer>> entries = this.memberNamesMap.entrySet();
                for (Map.Entry<String, Integer> entry : entries) {
                    Integer variablesIndex = entry.getValue();
                    Array array = this.arrayCache.get(entry.getKey());
                    Scaler scaler = this.scalerMap.get(entry.getKey());
                    Index index = array.getIndex();
                    for (int i = 0; i < numMeasurements; ++i) {
                        index.set(gridPointIndex, i);
                        Number[] tableVector = tableData[i];
                        double rawValue = array.getDouble(index);
                        tableVector[variablesIndex.intValue()] = scaler.isValid(rawValue) ? Double.valueOf(scaler.scale(rawValue)) : Double.valueOf(Double.NaN);
                    }
                }
            }
            gridPointBtDataset.setData(tableData);
        }
        return gridPointBtDataset;
    }

    @Override
    public String[] getRawDataTableNames() {
        try {
            this.ensureDataStructuresInitialized();
        }
        catch (IOException e) {
            return new String[0];
        }
        String[] names = new String[this.memberNamesMap.size()];
        Set<Map.Entry<String, Integer>> entries = this.memberNamesMap.entrySet();
        for (Map.Entry<String, Integer> entry : entries) {
            names[entry.getValue().intValue()] = entry.getKey();
        }
        return names;
    }

    @Override
    public FlagDescriptor[] getBtFlagDescriptors() {
        return new FlagDescriptor[0];
    }

    @Override
    public PolarisationModel getPolarisationModel() {
        return null;
    }

    @Override
    public boolean canSupplySnapshotData() {
        return false;
    }

    @Override
    public boolean hasSnapshotInfo() {
        return false;
    }

    @Override
    public SnapshotInfo getSnapshotInfo() throws IOException {
        return null;
    }

    @Override
    public Object[][] getSnapshotData(int snapshotIndex) {
        return new Object[0][];
    }

    @Override
    public void createAdditionalBands(Product product, Area area, Family<BandDescriptor> bandDescriptors, String formatName, HashMap<String, AbstractValueProvider> valueProvierMap) {
    }

    @Override
    public void setArrayCache(ArrayCache arrayCache) {
        this.arrayCache = arrayCache;
    }

    @Override
    public void setGridPointInfo(GridPointInfo gridPointInfo) {
        this.gridPointInfo = gridPointInfo;
    }

    protected boolean containsVariable(String variableName) {
        Variable variable = this.netcdfFile.findVariable(variableName);
        return variable != null;
    }

    protected void ensureDataStructuresInitialized() throws IOException {
        if (this.memberNamesMap != null && this.tableClasses != null && this.scalerMap != null && this.snapshotDataNames != null) {
            return;
        }
        this.memberNamesMap = new HashMap();
        this.scalerMap = new HashMap();
        ArrayList<Class> tableClassesList = new ArrayList<Class>();
        ArrayList<String> snapshotBandNamesList = new ArrayList<String>();
        String schemaDescription = NetcdfProductReader.getSchemaDescription(this.netcdfFile);
        Dddb dddb = Dddb.getInstance();
        Family bandDescriptors = dddb.getBandDescriptors(schemaDescription);
        if (bandDescriptors == null) {
            throw new IOException("Unsupported file schema: '" + schemaDescription + "`");
        }
        int index = 0;
        for (BandDescriptor descriptor : bandDescriptors.asList()) {
            Variable variable;
            String eeVariableName = dddb.getEEVariableName(descriptor.getMemberName(), schemaDescription);
            String ncVariableName = ExporterUtils.ensureNetCDFName(eeVariableName);
            if (!descriptor.isGridPointData() && (variable = this.netcdfFile.findVariable(null, ncVariableName)) != null) {
                snapshotBandNamesList.add(descriptor.getMemberName());
            }
            if (!descriptor.isVisible() || (variable = this.netcdfFile.findVariable(null, ncVariableName)) == null || this.memberNamesMap.containsKey(eeVariableName)) continue;
            double scalingFactor = descriptor.getScalingFactor();
            double scalingOffset = descriptor.getScalingOffset();
            double fillValue = descriptor.getFillValue();
            if (scalingFactor != 1.0 || scalingOffset != 0.0) {
                this.scalerMap.put(eeVariableName, new LinearScaler(scalingFactor, scalingOffset, fillValue));
            } else {
                this.scalerMap.put(eeVariableName, new IdentityScaler(fillValue));
            }
            tableClassesList.add(variable.getDataType().getPrimitiveClassType());
            this.memberNamesMap.put(eeVariableName, index);
            ++index;
        }
        this.snapshotDataNames = snapshotBandNamesList.toArray(new String[snapshotBandNamesList.size()]);
        this.tableClasses = tableClassesList.toArray(new Class[tableClassesList.size()]);
        for (BandDescriptor descriptor : bandDescriptors.asList()) {
            Family bandFlagDescriptors = descriptor.getFlagDescriptors();
            if (bandFlagDescriptors == null) continue;
            List flagDescriptorList = bandFlagDescriptors.asList();
            this.flagDescriptors = flagDescriptorList.toArray(new FlagDescriptor[flagDescriptorList.size()]);
            break;
        }
    }
}

