/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.geometry;

import com.bc.ceres.binio.CompoundData;
import java.io.IOException;
import org.esa.smos.ee2netcdf.geometry.GeometryFilter;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

class PolygonGeometryFilter
implements GeometryFilter {
    private final Polygon polygon;
    private final GeometryFactory geometryFactory;

    PolygonGeometryFilter(Geometry geometry) {
        this.polygon = (Polygon)geometry;
        this.geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
    }

    @Override
    public boolean accept(CompoundData compoundData) throws IOException {
        float lat = compoundData.getFloat(1);
        float lon = compoundData.getFloat(2);
        Coordinate coord = new Coordinate((double)lon, (double)lat);
        Point point = this.geometryFactory.createPoint(coord);
        return this.polygon.contains((Geometry)point);
    }
}

