/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.esa.smos.dataio.smos.SmosProductReaderPlugIn;
import org.esa.smos.ee2netcdf.ExportParameter;
import org.esa.smos.ee2netcdf.ExporterUtils;
import org.esa.smos.ee2netcdf.FormatExporter;
import org.esa.smos.ee2netcdf.FormatExporterFactory;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NWritableFactory;

class NetcdfExporter {
    private final ExportParameter parameter;

    NetcdfExporter(ExportParameter parameter) {
        this.parameter = parameter;
    }

    void initialize() {
        ExporterUtils.assertTargetDirectoryExists(this.parameter.getTargetDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportProduct(Product product, Logger logger) {
        File fileLocation = product.getFileLocation();
        NFileWriteable nFileWriteable = null;
        try {
            int numGridCellsCovered;
            logger.info("Converting product: " + fileLocation.getPath() + " ...");
            FormatExporter exporter = FormatExporterFactory.create(fileLocation.getName());
            exporter.initialize(product, this.parameter);
            File targetFile = NetcdfExporter.getTargetFile(fileLocation, this.parameter.getTargetDirectory());
            if (targetFile.isFile()) {
                if (this.parameter.isOverwriteTarget()) {
                    if (!targetFile.delete()) {
                        throw new IOException("Unable to delete already existing product: " + targetFile.getAbsolutePath());
                    }
                } else {
                    logger.warning("output file '" + targetFile.getPath() + "' exists. Target file will not be overwritten.");
                    return;
                }
            }
            if ((numGridCellsCovered = exporter.prepareGeographicSubset(this.parameter)) == 0) {
                logger.info("No geometric intersection between subset and input file. Skipping export operation");
                return;
            }
            nFileWriteable = NWritableFactory.create((String)targetFile.getPath(), (String)"netcdf4");
            exporter.addDimensions(nFileWriteable);
            exporter.addVariables(nFileWriteable, this.parameter);
            exporter.addGlobalAttributes(nFileWriteable, product.getMetadataRoot(), this.parameter);
            nFileWriteable.create();
            exporter.writeData(nFileWriteable);
            logger.info("Success. Wrote target product: " + targetFile.getPath());
        }
        catch (Exception e) {
            logger.severe("Failed to convert file: " + fileLocation.getAbsolutePath());
            logger.severe(e.getMessage());
        }
        finally {
            if (nFileWriteable != null) {
                try {
                    nFileWriteable.close();
                }
                catch (IOException e) {
                    logger.severe("Failed to close file: " + fileLocation.getAbsolutePath());
                    logger.severe(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportFile(File file, Logger logger) {
        Product product = null;
        try {
            SmosProductReaderPlugIn readerPlugIn = new SmosProductReaderPlugIn();
            DecodeQualification decodeQualification = readerPlugIn.getDecodeQualification((Object)file);
            if (decodeQualification == DecodeQualification.INTENDED) {
                product = readerPlugIn.createReaderInstance().readProductNodes((Object)file, null);
                String productType = product.getProductType();
                if (productType.matches("MIR_BW[LS][DF]1C|MIR_SC[LS][DF]1C|MIR_OSUDP2|MIR_SMUDP2")) {
                    this.exportProduct(product, logger);
                } else {
                    logger.info("Unable to convert file: " + file.getAbsolutePath());
                    logger.info("Unsupported product of type: " + productType);
                }
            } else {
                logger.warning("Unable to open file: " + file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            logger.severe("Failed to convert file: " + file.getAbsolutePath());
            logger.severe(e.getMessage());
        }
        finally {
            if (product != null) {
                product.dispose();
            }
        }
    }

    private static File getTargetFile(File dblFile, File targetDirectory) {
        return FileUtils.exchangeExtension((File)new File(targetDirectory, dblFile.getName()), (String)".nc");
    }
}

