/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.ValidationException;
import java.io.File;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.esa.smos.ee2netcdf.ExportParameter;
import org.esa.smos.ee2netcdf.ExporterUtils;
import org.esa.smos.ee2netcdf.NetcdfExporter;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Engine;

public class NetcdfExportTool {
    private static final String TOOL_NAME = "smos-ee-to-nc";
    private static final String TOOL_VERSION = "5.8.0";
    private static final int ERROR = 1;
    private static final int USAGE_ERROR = 2;
    private static final int EXECUTION_ERROR = 3;
    private static final Map<String, String> PARAMETER_NAMES = new HashMap<String, String>();
    private static final Level[] LOG_LEVELS;
    private static final String LOG_LEVEL_OPTION_NAME = "log-level";
    private static final String ERROR_OPTION_NAME = "error";
    private static final String LOG_LEVEL_DESCRIPTION;
    private final Options options = new Options();
    private Logger logger;
    private Level logLevel = Level.INFO;
    private boolean produceErrorMessages;

    public static void main(String[] args) {
        new NetcdfExportTool().run(args);
    }

    public NetcdfExportTool() {
        this.defineOptions();
    }

    private void run(String[] arguments) {
        try {
            this.execute(arguments);
        }
        catch (ToolException e) {
            this.exit(e, e.getExitCode());
        }
        catch (Throwable e) {
            this.exit(e, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String[] arguments) throws ToolException {
        CommandLine commandLine;
        try {
            commandLine = this.parseCommandLine(arguments);
            if (commandLine.hasOption("help")) {
                this.printHelp();
                return;
            }
            if (commandLine.hasOption("version")) {
                this.printVersion();
                return;
            }
            if (commandLine.getArgs().length == 0 && !commandLine.hasOption("source-product-paths")) {
                this.printHelp();
                return;
            }
            if (commandLine.hasOption(ERROR_OPTION_NAME)) {
                this.produceErrorMessages = true;
            }
            if (commandLine.hasOption(LOG_LEVEL_OPTION_NAME)) {
                String optionValue = commandLine.getOptionValue(LOG_LEVEL_OPTION_NAME);
                this.logLevel = Level.parse(optionValue);
            }
        }
        catch (IllegalArgumentException | ParseException e) {
            throw new ToolException(e, 2);
        }
        finally {
            this.configureLogger();
        }
        Engine engine = Engine.start();
        try {
            ExportParameter exportParameter = new ExportParameter();
            this.setExportParameters(commandLine, exportParameter);
            NetcdfExporter exporter = new NetcdfExporter(exportParameter);
            try {
                exporter.initialize();
            }
            catch (Exception e) {
                File targetDirectory = exportParameter.getTargetDirectory();
                throw new ToolException(MessageFormat.format("The target directory ''{0}'' could not be created.", targetDirectory), e, 3);
            }
            for (String path : commandLine.getArgs()) {
                File file = new File(path);
                try {
                    exporter.exportFile(file, this.getLogger());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ToolException(MessageFormat.format("An error has occurred while trying to convert file ''{0}''.", path), e, 3);
                }
            }
            if (commandLine.hasOption("source-product-paths")) {
                String sourceProductPathsCSV = commandLine.getOptionValue("source-product-paths");
                String[] sourceProductPaths = StringUtils.split((String)sourceProductPathsCSV, (char[])new char[]{','}, (boolean)true);
                TreeSet<File> inputFileSet = ExporterUtils.createInputFileSet(sourceProductPaths);
                for (File inputFile : inputFileSet) {
                    if (inputFile.isDirectory()) continue;
                    try {
                        exporter.exportFile(inputFile, this.getLogger());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logger.severe(MessageFormat.format("An error has occurred while trying to convert file ''{0}''.", inputFile));
                    }
                }
            }
        }
        finally {
            engine.stop();
        }
    }

    private void setExportParameters(CommandLine commandLine, ExportParameter exportParameter) throws ToolException {
        ParameterDescriptorFactory descriptorFactory = new ParameterDescriptorFactory();
        PropertyContainer container = PropertyContainer.createObjectBacked((Object)exportParameter, (PropertyDescriptorFactory)descriptorFactory);
        container.setDefaultValues();
        container.setValue("roiType", (Object)1);
        for (String parameterName : PARAMETER_NAMES.keySet()) {
            String optionName = NetcdfExportTool.getOptionName(parameterName);
            if (!commandLine.hasOption(optionName)) continue;
            String optionValue = commandLine.getOptionValue(optionName);
            Property parameter = container.getProperty(parameterName);
            if (optionValue == null && parameter.getType().isAssignableFrom(Boolean.TYPE)) {
                container.setValue(parameterName, (Object)true);
                continue;
            }
            try {
                parameter.setValueFromText(optionValue);
            }
            catch (ValidationException e) {
                throw new ToolException(MessageFormat.format("Missing or invalid value for option ''{0}''.", optionName), e, 2);
            }
        }
    }

    private void exit(Throwable t, int exitCode) {
        if (this.produceErrorMessages) {
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
        }
        if (this.getLogger().isLoggable(Level.SEVERE)) {
            this.getLogger().log(Level.SEVERE, t.getMessage());
            if (this.getLogger().isLoggable(Level.FINE)) {
                for (StackTraceElement e : t.getStackTrace()) {
                    this.getLogger().log(Level.FINE, e.toString());
                }
            }
        }
        System.exit(exitCode);
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = SystemUtils.LOG;
        }
        return this.logger;
    }

    private void configureLogger() {
        Logger logger = this.getLogger();
        logger.setLevel(this.logLevel);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(this.logLevel);
        logger.addHandler(consoleHandler);
    }

    private void printVersion() {
        System.out.println("smos-ee-to-nc version 5.8.0");
    }

    private void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setNewLine("\n");
        helpFormatter.setWidth(80);
        helpFormatter.printHelp(this.getSyntax(), "\nOptions:", this.options, "", false);
    }

    private String getSyntax() {
        return "smos-ee-to-nc [options] file ...";
    }

    private CommandLine parseCommandLine(String[] arguments) throws ParseException {
        return new PosixParser().parse(this.options, arguments);
    }

    private void defineOptions() {
        Field[] fields;
        this.options.addOption("e", "errors", false, "Produce execution error messages.");
        this.options.addOption("h", "help", false, "Display help information.");
        this.options.addOption("v", "version", false, "Display version information.");
        this.options.addOption(NetcdfExportTool.createOption("l", LOG_LEVEL_OPTION_NAME, Level.class, LOG_LEVEL_DESCRIPTION));
        OptionBuilder.withLongOpt((String)"source-product-paths");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)String.class.getSimpleName().toLowerCase());
        OptionBuilder.withDescription((String)"Comma-separated list of file paths specifying the source products.\nEach path may contain the wildcards '**' (matches recursively any directory),\n'*' (matches any character sequence in path names) and\n'?' (matches any single character).");
        this.options.addOption(OptionBuilder.create());
        Set<String> parameterNames = PARAMETER_NAMES.keySet();
        for (Field field : fields = ExportParameter.class.getDeclaredFields()) {
            String alias;
            Parameter parameter = field.getAnnotation(Parameter.class);
            if (parameter == null || !parameterNames.contains(alias = parameter.alias())) continue;
            String optionName = NetcdfExportTool.getOptionName(alias);
            OptionBuilder.withLongOpt((String)optionName);
            Class<Boolean> type = NetcdfExportTool.getType(field);
            OptionBuilder.withType(type);
            String argName = type.getSimpleName().toLowerCase();
            boolean noArg = type.isAssignableFrom(Boolean.TYPE);
            if (noArg) {
                OptionBuilder.hasArg((boolean)false);
            } else {
                OptionBuilder.hasArg((boolean)true);
                OptionBuilder.withArgName((String)argName);
            }
            String description = parameter.description();
            StringBuilder descriptionBuilder = new StringBuilder(description);
            if (!description.isEmpty() && !description.endsWith(".")) {
                descriptionBuilder.append(".");
            }
            if (!noArg) {
                Object[] valueSet = parameter.valueSet();
                if (valueSet.length != 0) {
                    descriptionBuilder.append(" The argument <").append(argName).append("> must be in ").append(Arrays.toString(valueSet).replace("[", "{").replace("]", "}")).append(".");
                } else {
                    String interval = parameter.interval();
                    if (!interval.isEmpty()) {
                        descriptionBuilder.append(" The argument <").append(argName).append("> must be in the interval ").append(interval).append(".");
                    }
                }
                String defaultValue = parameter.defaultValue();
                if (!defaultValue.isEmpty()) {
                    descriptionBuilder.append(" The default value is '").append(defaultValue).append("'.");
                }
            }
            OptionBuilder.withDescription((String)descriptionBuilder.toString());
            Option option = OptionBuilder.create();
            boolean required = parameter.notNull() || parameter.notEmpty();
            option.setRequired(required);
            this.options.addOption(option);
        }
    }

    private static Option createOption(String opt, String optionName, Class<?> argType, String description) {
        Option option = new Option(opt, optionName, true, description);
        option.setType(argType);
        option.setArgName(argType.getSimpleName().toLowerCase());
        return option;
    }

    private static String getOptionName(String alias) {
        return PARAMETER_NAMES.get(alias);
    }

    private static Class<?> getType(Field field) {
        Class<?> fieldType = field.getType();
        if (fieldType.isPrimitive() || fieldType.equals(File.class)) {
            return fieldType;
        }
        return String.class;
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
        PARAMETER_NAMES.put("contact", "contact");
        PARAMETER_NAMES.put("institution", "institution");
        PARAMETER_NAMES.put("overwriteTarget", "overwrite-target");
        PARAMETER_NAMES.put("geometry", "region");
        PARAMETER_NAMES.put("targetDirectory", "target-directory");
        PARAMETER_NAMES.put("variables", "variables");
        PARAMETER_NAMES.put("compressionLevel", "compression-level");
        LOG_LEVELS = new Level[]{Level.ALL, Level.INFO, Level.CONFIG, Level.WARNING, Level.SEVERE, Level.OFF};
        LOG_LEVEL_DESCRIPTION = "Set the logging level to <level> where <level> must be in " + Arrays.toString(LOG_LEVELS).replace("[", "{").replaceAll("]", "}") + ". The default logging level is '" + Level.INFO.toString() + "'.";
    }

    private static final class ToolException
    extends Exception {
        private final int exitCode;

        private ToolException(Throwable cause, int exitCode) {
            super(cause);
            this.exitCode = exitCode;
        }

        private ToolException(String message, Throwable cause, int exitCode) {
            super(message, cause);
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

