/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.esa.smos.ee2netcdf.AttributeEntry;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.StringUtils;
import ucar.nc2.Attribute;

public class MetadataUtils {
    private static final String GLOBAL_ATTRIBUTES = "Global_Attributes";
    private static final char SEPARATOR = ':';
    private static final HashMap<String, String> NAME_REPLACEMENTS = new HashMap();

    static void extractAttributes(MetadataElement root, List<AttributeEntry> properties, String prefix) {
        MetadataAttribute[] attributes;
        for (MetadataAttribute attribute : attributes = root.getAttributes()) {
            MetadataUtils.addAttributeTo(properties, prefix, attribute);
        }
        MetadataElement[] elements = root.getElements();
        HashMap<String, List<MetadataElement>> uniqueNamedElements = MetadataUtils.getListWithUniqueNamedElements(elements);
        Set<String> nameSet = uniqueNamedElements.keySet();
        for (String elementName : nameSet) {
            List<MetadataElement> elementsWithSameName = uniqueNamedElements.get(elementName);
            if (elementsWithSameName.size() == 1) {
                MetadataElement metadataElement = elementsWithSameName.get(0);
                String nextRecursionPrefix = prefix + metadataElement.getName() + ":";
                MetadataUtils.extractAttributes(metadataElement, properties, nextRecursionPrefix);
                continue;
            }
            int index = 0;
            for (MetadataElement metadataElement : elementsWithSameName) {
                String nextRecursionPrefix = prefix + metadataElement.getName() + "_" + Integer.toString(index) + ":";
                MetadataUtils.extractAttributes(metadataElement, properties, nextRecursionPrefix);
                ++index;
            }
        }
    }

    private static void addAttributeTo(List<AttributeEntry> properties, String prefix, MetadataAttribute attribute) {
        properties.add(new AttributeEntry(prefix + attribute.getName(), attribute.getData().getElemString()));
    }

    private static HashMap<String, List<MetadataElement>> getListWithUniqueNamedElements(MetadataElement[] elements) {
        HashMap<String, List<MetadataElement>> uniqueNamedElements = new HashMap<String, List<MetadataElement>>(elements.length);
        for (MetadataElement element : elements) {
            String elementName = element.getName();
            List<MetadataElement> elementList = uniqueNamedElements.get(elementName);
            if (elementList == null) {
                ArrayList<MetadataElement> uniqueNamedElementsList = new ArrayList<MetadataElement>();
                uniqueNamedElementsList.add(element);
                uniqueNamedElements.put(elementName, uniqueNamedElementsList);
                continue;
            }
            elementList.add(element);
        }
        return uniqueNamedElements;
    }

    public static List<AttributeEntry> convertNetcdfAttributes(List<Attribute> ncAttributes, boolean expandNames) {
        ArrayList<AttributeEntry> attributeList = new ArrayList<AttributeEntry>(ncAttributes.size());
        for (Attribute attribute : ncAttributes) {
            String replacedName;
            String name = attribute.getFullName();
            if (expandNames && StringUtils.isNotNullAndNotEmpty((String)(replacedName = MetadataUtils.getReplacement(name)))) {
                name = replacedName;
            }
            String value = attribute.getStringValue();
            AttributeEntry attributeEntry = new AttributeEntry(name, value);
            attributeList.add(attributeEntry);
        }
        return attributeList;
    }

    public static void parseMetadata(List<AttributeEntry> metaDataElements, MetadataElement metadataRoot) {
        for (AttributeEntry attribute : metaDataElements) {
            String name = attribute.getName();
            String value = attribute.getValue();
            String[] tokens = StringUtils.split((String)name, (char[])new char[]{':'}, (boolean)true);
            if (tokens.length == 1) {
                MetadataElement globalAttributesElement = MetadataUtils.ensureElement(metadataRoot, GLOBAL_ATTRIBUTES);
                MetadataAttribute metadataAttribute = new MetadataAttribute(name, ProductData.createInstance((String)value), false);
                globalAttributesElement.addAttribute(metadataAttribute);
                continue;
            }
            MetadataElement element = metadataRoot;
            int elementCount = tokens.length - 1;
            for (int i = 0; i < elementCount; ++i) {
                element = MetadataUtils.ensureElement(element, tokens[i]);
            }
            MetadataAttribute metadataAttribute = new MetadataAttribute(tokens[elementCount], ProductData.createInstance((String)value), false);
            element.addAttribute(metadataAttribute);
        }
    }

    private static MetadataElement ensureElement(MetadataElement metadataElement, String token) {
        MetadataElement element = metadataElement.getElement(token);
        if (element == null) {
            element = new MetadataElement(token);
            metadataElement.addElement(element);
        }
        return element;
    }

    static void shrinkNames(List<AttributeEntry> metaDataElements) {
        MetadataUtils.shrinkOrExpandNames(metaDataElements);
    }

    static void expandNames(List<AttributeEntry> metaDataElements) {
        MetadataUtils.shrinkOrExpandNames(metaDataElements);
    }

    private static void shrinkOrExpandNames(List<AttributeEntry> metaDataElements) {
        ArrayList<AttributeEntry> resultList = new ArrayList<AttributeEntry>(metaDataElements.size());
        for (AttributeEntry entry : metaDataElements) {
            String name = entry.getName();
            String replacedName = MetadataUtils.getReplacement(name);
            if (StringUtils.isNotNullAndNotEmpty((String)replacedName)) {
                resultList.add(new AttributeEntry(replacedName, entry.getValue()));
                continue;
            }
            resultList.add(entry);
        }
        metaDataElements.clear();
        metaDataElements.addAll(resultList);
    }

    public static String getReplacement(String name) {
        String[] tokens = StringUtils.split((String)name, (char[])new char[]{':'}, (boolean)true);
        StringBuilder result = new StringBuilder();
        boolean replaced = false;
        for (String token : tokens) {
            String replaceToken = NAME_REPLACEMENTS.get(token);
            if (StringUtils.isNotNullAndNotEmpty((String)replaceToken)) {
                result.append(replaceToken);
                result.append(':');
                replaced = true;
                continue;
            }
            result.append(token);
            result.append(':');
        }
        if (replaced) {
            String resultString = result.toString();
            return resultString.substring(0, resultString.length() - 1);
        }
        return null;
    }

    public static boolean hasShrinkedAttributes(List<Attribute> metaDataElements) {
        for (Attribute attribute : metaDataElements) {
            String name = attribute.getShortName();
            if (!name.startsWith("FH") && !name.startsWith("VH")) continue;
            return true;
        }
        return false;
    }

    static {
        NAME_REPLACEMENTS.put("Fixed_Header", "FH");
        NAME_REPLACEMENTS.put("FH", "Fixed_Header");
        NAME_REPLACEMENTS.put("Variable_Header", "VH");
        NAME_REPLACEMENTS.put("VH", "Variable_Header");
        NAME_REPLACEMENTS.put("Main_Product_Header", "MPH");
        NAME_REPLACEMENTS.put("MPH", "Main_Product_Header");
        NAME_REPLACEMENTS.put("Orbit_Information", "OI");
        NAME_REPLACEMENTS.put("OI", "Orbit_Information");
        NAME_REPLACEMENTS.put("Specific_Product_Header", "SPH");
        NAME_REPLACEMENTS.put("SPH", "Specific_Product_Header");
        NAME_REPLACEMENTS.put("L2_Product_Desciption", "L2PD");
        NAME_REPLACEMENTS.put("L2PD", "L2_Product_Desciption");
        NAME_REPLACEMENTS.put("List_of_models", "LOM");
        NAME_REPLACEMENTS.put("LOM", "List_of_models");
        NAME_REPLACEMENTS.put("L2_Product_Location", "L2PL");
        NAME_REPLACEMENTS.put("L2PL", "L2_Product_Location");
        NAME_REPLACEMENTS.put("List_of_Data_Sets", "LODS");
        NAME_REPLACEMENTS.put("LODS", "List_of_Data_Sets");
        NAME_REPLACEMENTS.put("Main_Info", "MI");
        NAME_REPLACEMENTS.put("MI", "Main_Info");
        NAME_REPLACEMENTS.put("Time_Info", "TI");
        NAME_REPLACEMENTS.put("TI", "Time_Info");
        NAME_REPLACEMENTS.put("Quality_Information", "QI");
        NAME_REPLACEMENTS.put("QI", "Quality_Information");
        NAME_REPLACEMENTS.put("List_of_Retrieval_Schemes", "LORS");
        NAME_REPLACEMENTS.put("LORS", "List_of_Retrieval_Schemes");
        NAME_REPLACEMENTS.put("List_of_Quality_Classes", "LOQC");
        NAME_REPLACEMENTS.put("LOQC", "List_of_Quality_Classes");
        NAME_REPLACEMENTS.put("Near_Coast_Quality", "NCQ");
        NAME_REPLACEMENTS.put("NCQ", "Near_Coast_Quality");
        NAME_REPLACEMENTS.put("Sea_Ice_Quality", "SIQ");
        NAME_REPLACEMENTS.put("SIQ", "Sea_Ice_Quality");
        NAME_REPLACEMENTS.put("Sea_Quality", "SQ");
        NAME_REPLACEMENTS.put("SQ", "Sea_Quality");
    }
}

