/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf;

import com.bc.ceres.binio.CompoundData;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.esa.smos.DateTimeUtils;
import org.esa.smos.SmosUtils;
import org.esa.smos.ee2netcdf.AbstractFormatExporter;
import org.esa.smos.ee2netcdf.AttributeEntry;
import org.esa.smos.ee2netcdf.ExportParameter;
import org.esa.smos.ee2netcdf.ExporterUtils;
import org.esa.smos.ee2netcdf.MetadataUtils;
import org.esa.smos.ee2netcdf.variable.VariableDescriptor;
import org.esa.smos.ee2netcdf.variable.VariableWriter;
import org.esa.smos.ee2netcdf.variable.VariableWriterFactory;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;

class L2FormatExporter
extends AbstractFormatExporter {
    L2FormatExporter() {
    }

    @Override
    public void initialize(Product product, ExportParameter exportParameter) throws IOException {
        super.initialize(product, exportParameter);
        this.applyChiSquareScalingIfNecessary(product);
    }

    @Override
    public void addDimensions(NFileWriteable nFileWriteable) throws IOException {
        nFileWriteable.addDimension("n_grid_points", this.gridPointCount);
    }

    @Override
    public void writeData(NFileWriteable nFileWriteable) throws IOException {
        VariableWriter[] variableWriters = this.createVariableWriters(nFileWriteable);
        if (this.gpIndexList == null) {
            for (int i = 0; i < this.gridPointCount; ++i) {
                this.writeCompound(i, i, variableWriters);
            }
        } else {
            int writeIndex = 0;
            Iterator iterator = this.gpIndexList.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                this.writeCompound(index, writeIndex, variableWriters);
                ++writeIndex;
            }
        }
        for (VariableWriter writer : variableWriters) {
            writer.close();
        }
    }

    @Override
    public void addGlobalAttributes(NFileWriteable nFileWriteable, MetadataElement metadataRoot, ExportParameter exportParameter) throws IOException {
        String contact;
        String institution = exportParameter.getInstitution();
        if (StringUtils.isNotBlank((CharSequence)institution)) {
            nFileWriteable.addGlobalAttribute("institution", institution);
        }
        if (StringUtils.isNotBlank((CharSequence)(contact = exportParameter.getContact()))) {
            nFileWriteable.addGlobalAttribute("contact", contact);
        }
        nFileWriteable.addGlobalAttribute("creation_date", DateTimeUtils.toFixedHeaderFormat((Date)new Date()));
        nFileWriteable.addGlobalAttribute("total_number_of_grid_points", Integer.toString(this.gridPointCount));
        List<AttributeEntry> attributeList = L2FormatExporter.extractMetadata(metadataRoot);
        MetadataUtils.shrinkNames(attributeList);
        for (AttributeEntry entry : attributeList) {
            nFileWriteable.addGlobalAttribute(entry.getName(), entry.getValue());
        }
    }

    private void applyChiSquareScalingIfNecessary(Product product) {
        String productType = product.getProductType();
        if (SmosUtils.isSmUserFormat((String)productType)) {
            MetadataElement specificProductHeader = ExporterUtils.getSpecificProductHeader(product);
            if (specificProductHeader == null) {
                return;
            }
            MetadataAttribute chi2ScaleAttribute = specificProductHeader.getAttribute("Chi_2_Scale");
            if (chi2ScaleAttribute == null) {
                return;
            }
            double scaleFactor = chi2ScaleAttribute.getData().getElemDouble();
            if (scaleFactor != 1.0) {
                ExporterUtils.correctScaleFactor(this.variableDescriptors, "Chi_2", scaleFactor);
            }
        }
    }

    private void writeCompound(int readIndex, int writeIndex, VariableWriter[] variableWriters) throws IOException {
        CompoundData gridPointData = this.explorerFile.getGridPointData(readIndex);
        for (VariableWriter writer : variableWriters) {
            writer.write(gridPointData, null, writeIndex);
        }
    }

    private VariableWriter[] createVariableWriters(NFileWriteable nFileWriteable) {
        Set variableNameKeys = this.variableDescriptors.keySet();
        VariableWriter[] variableWriters = new VariableWriter[variableNameKeys.size()];
        int index = 0;
        for (String ncVariableName : variableNameKeys) {
            NVariable nVariable = nFileWriteable.findVariable(ncVariableName);
            VariableDescriptor variableDescriptor = (VariableDescriptor)this.variableDescriptors.get(ncVariableName);
            variableWriters[index] = VariableWriterFactory.create(nVariable, variableDescriptor, this.gridPointCount, -1);
            ++index;
        }
        return variableWriters;
    }
}

