/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceData;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.esa.smos.dataio.smos.L1cScienceSmosFile;
import org.esa.smos.ee2netcdf.AbstractFormatExporter;
import org.esa.smos.ee2netcdf.ExportParameter;
import org.esa.smos.ee2netcdf.ExporterUtils;
import org.esa.smos.ee2netcdf.geometry.GeometryFilter;
import org.esa.smos.ee2netcdf.geometry.GeometryFilterFactory;
import org.esa.smos.ee2netcdf.variable.VariableDescriptor;
import org.esa.smos.ee2netcdf.variable.VariableWriter;
import org.esa.smos.ee2netcdf.variable.VariableWriterFactory;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;

class L1CFormatExporter
extends AbstractFormatExporter {
    private int numSnapshotsToExport;
    private int numSnapshotsInInput;
    private HashMap<String, Integer> dimensionMap;
    private ArrayList<Integer> snapshotIdList;
    private L1cScienceSmosFile scienceSmosFile;

    L1CFormatExporter() {
    }

    @Override
    public void initialize(Product product, ExportParameter exportParameter) throws IOException {
        super.initialize(product, exportParameter);
        this.scienceSmosFile = (L1cScienceSmosFile)this.explorerFile;
        this.numSnapshotsToExport = this.numSnapshotsInInput = this.scienceSmosFile.getSnapshotCount();
        this.snapshotIdList = new ArrayList();
        this.applyScalingFromHeaderFile(product);
    }

    private void applyScalingFromHeaderFile(Product product) {
        double scaleFactor;
        MetadataAttribute pixelFootprintAttribute;
        double scaleFactor2;
        MetadataElement specificProductHeader = ExporterUtils.getSpecificProductHeader(product);
        if (specificProductHeader == null) {
            return;
        }
        MetadataAttribute radiometricAccuracyAttribute = specificProductHeader.getAttribute("Radiometric_Accuracy_Scale");
        if (radiometricAccuracyAttribute != null && (scaleFactor2 = radiometricAccuracyAttribute.getData().getElemDouble()) != 1.0) {
            ExporterUtils.correctScaleFactor(this.variableDescriptors, "Radiometric_Accuracy", scaleFactor2);
            ExporterUtils.correctScaleFactor(this.variableDescriptors, "Radiometric_Accuracy_of_Pixel", scaleFactor2);
        }
        if ((pixelFootprintAttribute = specificProductHeader.getAttribute("Pixel_Footprint_Scale")) != null && (scaleFactor = pixelFootprintAttribute.getData().getElemDouble()) != 1.0) {
            ExporterUtils.correctScaleFactor(this.variableDescriptors, "Footprint_Axis1", scaleFactor);
            ExporterUtils.correctScaleFactor(this.variableDescriptors, "Footprint_Axis2", scaleFactor);
        }
    }

    @Override
    public int prepareGeographicSubset(ExportParameter exportParameter) throws IOException {
        if (exportParameter.getGeometry() != null) {
            GeometryFilter geometryFilter = GeometryFilterFactory.create(exportParameter.getGeometry());
            this.gpIndexList = new ArrayList(this.gridPointCount);
            for (int i = 0; i < this.gridPointCount; ++i) {
                CompoundData gridPointData = this.explorerFile.getGridPointData(i);
                if (!geometryFilter.accept(gridPointData)) continue;
                this.gpIndexList.add(i);
                SequenceData btDataList = this.scienceSmosFile.getBtDataList(i);
                int elementCount = btDataList.getElementCount();
                for (int j = 0; j < elementCount; ++j) {
                    CompoundData btData = btDataList.getCompound(j);
                    int snapshotId = btData.getInt("Snapshot_ID_of_Pixel");
                    if (this.snapshotIdList.contains(snapshotId)) continue;
                    this.snapshotIdList.add(snapshotId);
                }
            }
            this.gridPointCount = this.gpIndexList.size();
            this.numSnapshotsToExport = this.snapshotIdList.size();
            return this.gridPointCount;
        }
        return -1;
    }

    @Override
    public void addDimensions(NFileWriteable nFileWriteable) throws IOException {
        nFileWriteable.addDimension("n_grid_points", this.gridPointCount);
        nFileWriteable.addDimension("n_bt_data", 300);
        nFileWriteable.addDimension("n_radiometric_accuracy", 2);
        nFileWriteable.addDimension("n_snapshots", this.numSnapshotsToExport);
        this.dimensionMap = new HashMap();
        this.dimensionMap.put("n_grid_points", this.gridPointCount);
        this.dimensionMap.put("n_bt_data", 300);
        this.dimensionMap.put("n_radiometric_accuracy", 2);
        this.dimensionMap.put("n_snapshots", this.numSnapshotsToExport);
    }

    @Override
    public void writeData(NFileWriteable nFileWriteable) throws IOException {
        L1cScienceSmosFile l1cScienceSmosFile = (L1cScienceSmosFile)this.explorerFile;
        this.writeGridPointVariables(nFileWriteable);
        this.writeSnapshotVariables(nFileWriteable, l1cScienceSmosFile);
    }

    private void writeSnapshotVariables(NFileWriteable nFileWriteable, L1cScienceSmosFile l1cScienceSmosFile) throws IOException {
        VariableWriter[] snapshotVariableWriters = this.createVariableWriters(nFileWriteable, false);
        if (this.snapshotIdList.isEmpty()) {
            this.writeAllSnapshots(l1cScienceSmosFile, snapshotVariableWriters);
        } else {
            this.writeSnapshotSubset(l1cScienceSmosFile, snapshotVariableWriters);
        }
    }

    private void writeAllSnapshots(L1cScienceSmosFile l1cScienceSmosFile, VariableWriter[] snapshotVariableWriters) throws IOException {
        for (int i = 0; i < this.numSnapshotsInInput; ++i) {
            CompoundData snapshotData = l1cScienceSmosFile.getSnapshotData(i);
            SequenceData radiometricAccuracy = snapshotData.getSequence("Radiometric_Accuracy");
            for (VariableWriter writer : snapshotVariableWriters) {
                writer.write(snapshotData, radiometricAccuracy, i);
            }
        }
        for (VariableWriter writer : snapshotVariableWriters) {
            writer.close();
        }
    }

    private void writeSnapshotSubset(L1cScienceSmosFile l1cScienceSmosFile, VariableWriter[] snapshotVariableWriters) throws IOException {
        int writeIndex = 0;
        for (int i = 0; i < this.numSnapshotsInInput; ++i) {
            CompoundData snapshotData = l1cScienceSmosFile.getSnapshotData(i);
            int snapshotId = snapshotData.getInt("Snapshot_ID");
            if (!this.snapshotIdList.contains(snapshotId)) continue;
            SequenceData radiometricAccuracy = snapshotData.getSequence("Radiometric_Accuracy");
            for (VariableWriter writer : snapshotVariableWriters) {
                writer.write(snapshotData, radiometricAccuracy, writeIndex);
            }
            ++writeIndex;
        }
        for (VariableWriter writer : snapshotVariableWriters) {
            writer.close();
        }
    }

    private void writeGridPointVariables(NFileWriteable nFileWriteable) throws IOException {
        VariableWriter[] gridPointVariableWriters = this.createVariableWriters(nFileWriteable, true);
        if (this.gpIndexList == null) {
            for (int i = 0; i < this.gridPointCount; ++i) {
                this.writeGridPointData(i, i, gridPointVariableWriters);
            }
        } else {
            int writeIndex = 0;
            Iterator iterator = this.gpIndexList.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                this.writeGridPointData(index, writeIndex, gridPointVariableWriters);
                ++writeIndex;
            }
        }
        for (VariableWriter writer : gridPointVariableWriters) {
            writer.close();
        }
    }

    private void writeGridPointData(int readIndex, int writeIndex, VariableWriter[] gridPointVariableWriters) throws IOException {
        CompoundData gridPointData = this.scienceSmosFile.getGridPointData(readIndex);
        SequenceData btDataList = this.scienceSmosFile.getBtDataList(readIndex);
        for (VariableWriter writer : gridPointVariableWriters) {
            writer.write(gridPointData, btDataList, writeIndex);
        }
    }

    private VariableWriter[] createVariableWriters(NFileWriteable nFileWriteable, boolean gridPointData) {
        Set variableNameKeys = this.variableDescriptors.keySet();
        ArrayList<VariableWriter> variableWriterList = new ArrayList<VariableWriter>(variableNameKeys.size());
        for (String ncVariableName : variableNameKeys) {
            NVariable nVariable = nFileWriteable.findVariable(ncVariableName);
            VariableDescriptor variableDescriptor = (VariableDescriptor)this.variableDescriptors.get(ncVariableName);
            if (gridPointData != variableDescriptor.isGridPointData()) continue;
            Dimension dimension = L1CFormatExporter.extractDimensions(variableDescriptor.getDimensionNames(), this.dimensionMap);
            variableWriterList.add(VariableWriterFactory.create(nVariable, variableDescriptor, dimension.width, dimension.height));
        }
        return variableWriterList.toArray(new VariableWriter[variableWriterList.size()]);
    }

    static Dimension extractDimensions(String dimensionNames, HashMap<String, Integer> dimensionMap) {
        String[] dimNamesArray = StringUtils.split((String)dimensionNames, (char[])new char[]{' '}, (boolean)true);
        Dimension dimension = new Dimension();
        dimension.width = dimensionMap.get(dimNamesArray[0]);
        dimension.height = dimNamesArray.length > 1 ? dimensionMap.get(dimNamesArray[1]) : -1;
        return dimension;
    }
}

