/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf;

import java.io.IOException;
import org.esa.smos.SmosUtils;
import org.esa.smos.ee2netcdf.BrowseFormatExporter;
import org.esa.smos.ee2netcdf.FormatExporter;
import org.esa.smos.ee2netcdf.L1CFormatExporter;
import org.esa.smos.ee2netcdf.L2FormatExporter;

class FormatExporterFactory {
    FormatExporterFactory() {
    }

    public static FormatExporter create(String fileName) throws IOException {
        if (SmosUtils.isBrowseFormat((String)fileName)) {
            return new BrowseFormatExporter();
        }
        if (SmosUtils.isL1cType((String)fileName)) {
            return new L1CFormatExporter();
        }
        if (SmosUtils.isOsUserFormat((String)fileName) || SmosUtils.isSmUserFormat((String)fileName)) {
            return new L2FormatExporter();
        }
        throw new IOException("Unsupported export for file:" + fileName);
    }
}

