/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeSet;
import org.esa.smos.ee2netcdf.variable.VariableDescriptor;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.WildcardMatcher;

public class ExporterUtils {
    static void assertTargetDirectoryExists(File targetDirectory) {
        if (!targetDirectory.isDirectory() && !targetDirectory.mkdirs()) {
            throw new OperatorException("Unable to create target directory: " + targetDirectory.getAbsolutePath());
        }
    }

    static TreeSet<File> createInputFileSet(String[] sourceProductPaths) {
        TreeSet<File> globbedFileSet = new TreeSet<File>();
        try {
            for (String path : sourceProductPaths) {
                path = path.trim();
                WildcardMatcher.glob((String)path, globbedFileSet);
            }
        }
        catch (IOException e) {
            throw new OperatorException(e.getMessage());
        }
        return ExporterUtils.ensureNoDuplicateDblFiles(globbedFileSet);
    }

    static TreeSet<File> ensureNoDuplicateDblFiles(TreeSet<File> globbedFileSet) {
        TreeSet<File> sourceFileSet = new TreeSet<File>();
        for (File inputFile : globbedFileSet) {
            String extension = FileUtils.getExtension((File)inputFile);
            if (".DBL".equalsIgnoreCase(extension) || ".HDR".equalsIgnoreCase(extension)) {
                File exchangedFile = FileUtils.exchangeExtension((File)inputFile, (String)".HDR");
                boolean alreadyPresent = false;
                for (File sourceFile : sourceFileSet) {
                    if (sourceFile.compareTo(exchangedFile) != 0) continue;
                    alreadyPresent = true;
                    break;
                }
                if (alreadyPresent) continue;
                sourceFileSet.add(exchangedFile);
                continue;
            }
            sourceFileSet.add(inputFile);
        }
        return sourceFileSet;
    }

    static MetadataElement getSpecificProductHeader(Product product) {
        MetadataElement metadataRoot = product.getMetadataRoot();
        MetadataElement variableHeader = metadataRoot.getElement("Variable_Header");
        if (variableHeader == null) {
            return null;
        }
        MetadataElement specificProductHeader = variableHeader.getElement("Specific_Product_Header");
        if (specificProductHeader == null) {
            return null;
        }
        return specificProductHeader;
    }

    static void correctScaleFactor(Map<String, VariableDescriptor> variableDescriptors, String variableName, double scaleCorrection) {
        VariableDescriptor variableDescriptor = variableDescriptors.get(variableName);
        if (variableDescriptor != null) {
            double originalScaleFactor = variableDescriptor.getScaleFactor();
            variableDescriptor.setScaleFactor(originalScaleFactor * scaleCorrection);
        }
    }

    public static String ensureNetCDFName(String variableName) {
        return variableName.replace(".", "_");
    }
}

