/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceData;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.esa.smos.SmosUtils;
import org.esa.smos.dataio.smos.L1cBrowseSmosFile;
import org.esa.smos.ee2netcdf.AbstractFormatExporter;
import org.esa.smos.ee2netcdf.ExportParameter;
import org.esa.smos.ee2netcdf.variable.VariableDescriptor;
import org.esa.smos.ee2netcdf.variable.VariableWriter;
import org.esa.smos.ee2netcdf.variable.VariableWriterFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;

class BrowseFormatExporter
extends AbstractFormatExporter {
    private int nBtData;

    BrowseFormatExporter() {
    }

    @Override
    public void initialize(Product product, ExportParameter exportParameter) throws IOException {
        super.initialize(product, exportParameter);
        String productName = product.getName();
        this.nBtData = BrowseFormatExporter.getBtDataDimension(productName);
    }

    @Override
    public void addDimensions(NFileWriteable nFileWriteable) throws IOException {
        nFileWriteable.addDimension("n_grid_points", this.gridPointCount);
        nFileWriteable.addDimension("n_bt_data", this.nBtData);
    }

    @Override
    public void writeData(NFileWriteable nFileWriteable) throws IOException {
        VariableWriter[] variableWriters = this.createVariableWriters(nFileWriteable);
        L1cBrowseSmosFile browseFile = (L1cBrowseSmosFile)this.explorerFile;
        if (this.gpIndexList == null) {
            for (int i = 0; i < this.gridPointCount; ++i) {
                this.writeGridPointAt(i, i, variableWriters, browseFile);
            }
        } else {
            int writeIndex = 0;
            Iterator iterator = this.gpIndexList.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                this.writeGridPointAt(index, writeIndex, variableWriters, browseFile);
                ++writeIndex;
            }
        }
        for (VariableWriter writer : variableWriters) {
            writer.close();
        }
    }

    private void writeGridPointAt(int readIndex, int writeIndex, VariableWriter[] variableWriters, L1cBrowseSmosFile browseFile) throws IOException {
        SequenceData btDataList = browseFile.getBtDataList(readIndex);
        CompoundData gridPointData = this.explorerFile.getGridPointData(readIndex);
        for (VariableWriter writer : variableWriters) {
            writer.write(gridPointData, btDataList, writeIndex);
        }
    }

    static int getBtDataDimension(String productName) {
        String productType = SmosUtils.getProductType((String)productName);
        if ("MIR_BWLF1C".equalsIgnoreCase(productType) || "MIR_BWNF1C".equalsIgnoreCase(productType) || "MIR_BWSF1C".equalsIgnoreCase(productType)) {
            return 4;
        }
        if ("MIR_BWLD1C".equalsIgnoreCase(productType) || "MIR_BWND1C".equalsIgnoreCase(productType) || "MIR_BWSD1C".equalsIgnoreCase(productType)) {
            return 2;
        }
        throw new IllegalArgumentException("unsupported product: " + productName);
    }

    private VariableWriter[] createVariableWriters(NFileWriteable nFileWriteable) {
        Set variableNameKeys = this.variableDescriptors.keySet();
        VariableWriter[] variableWriters = new VariableWriter[variableNameKeys.size()];
        int index = 0;
        for (String ncVariableName : variableNameKeys) {
            NVariable nVariable = nFileWriteable.findVariable(ncVariableName);
            VariableDescriptor variableDescriptor = (VariableDescriptor)this.variableDescriptors.get(ncVariableName);
            variableWriters[index] = VariableWriterFactory.create(nVariable, variableDescriptor, this.gridPointCount, this.nBtData);
            ++index;
        }
        return variableWriters;
    }
}

