/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf;

import com.bc.ceres.binio.CompoundData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.esa.smos.DateTimeUtils;
import org.esa.smos.dataio.smos.SmosFile;
import org.esa.smos.dataio.smos.SmosProductReader;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.MemberDescriptor;
import org.esa.smos.ee2netcdf.AttributeEntry;
import org.esa.smos.ee2netcdf.ExportParameter;
import org.esa.smos.ee2netcdf.ExporterUtils;
import org.esa.smos.ee2netcdf.FormatExporter;
import org.esa.smos.ee2netcdf.MetadataUtils;
import org.esa.smos.ee2netcdf.geometry.GeometryFilter;
import org.esa.smos.ee2netcdf.geometry.GeometryFilterFactory;
import org.esa.smos.ee2netcdf.variable.VariableDescriptor;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import ucar.ma2.Array;
import ucar.ma2.DataType;

abstract class AbstractFormatExporter
implements FormatExporter {
    protected int gridPointCount;
    protected SmosFile explorerFile;
    protected Map<String, VariableDescriptor> variableDescriptors;
    protected ArrayList<Integer> gpIndexList;
    private Family<MemberDescriptor> memberDescriptors;

    AbstractFormatExporter() {
    }

    static List<AttributeEntry> extractMetadata(MetadataElement root) {
        ArrayList<AttributeEntry> properties = new ArrayList<AttributeEntry>();
        MetadataUtils.extractAttributes(root, properties, "");
        return properties;
    }

    static boolean mustExport(String bandName, String[] outputBandNames) {
        if (outputBandNames.length == 0) {
            return true;
        }
        for (String outputBandName : outputBandNames) {
            if (!outputBandName.equalsIgnoreCase(bandName)) continue;
            return true;
        }
        return false;
    }

    private static SmosFile getSmosFile(Product product) {
        SmosProductReader smosReader = (SmosProductReader)product.getProductReader();
        return (SmosFile)smosReader.getProductFile();
    }

    static void setDataType(VariableDescriptor variableDescriptor, String dataTypeName) {
        if (StringUtils.isBlank((CharSequence)dataTypeName)) {
            throw new IllegalStateException("datatype not set for '" + variableDescriptor.getName() + "'");
        }
        if ("uint".equalsIgnoreCase(dataTypeName)) {
            variableDescriptor.setDataType(DataType.INT);
            variableDescriptor.setUnsigned(true);
        } else if ("int".equalsIgnoreCase(dataTypeName)) {
            variableDescriptor.setDataType(DataType.INT);
        } else if ("float".equalsIgnoreCase(dataTypeName)) {
            variableDescriptor.setDataType(DataType.FLOAT);
        } else if ("ubyte".equalsIgnoreCase(dataTypeName)) {
            variableDescriptor.setDataType(DataType.BYTE);
            variableDescriptor.setUnsigned(true);
        } else if ("ushort".equalsIgnoreCase(dataTypeName)) {
            variableDescriptor.setDataType(DataType.SHORT);
            variableDescriptor.setUnsigned(true);
        } else if ("short".equalsIgnoreCase(dataTypeName)) {
            variableDescriptor.setDataType(DataType.SHORT);
        } else if ("ulong".equalsIgnoreCase(dataTypeName)) {
            variableDescriptor.setDataType(DataType.LONG);
            variableDescriptor.setUnsigned(true);
        } else if ("double".equalsIgnoreCase(dataTypeName)) {
            variableDescriptor.setDataType(DataType.DOUBLE);
        } else {
            throw new IllegalArgumentException("unsupported datatype: '" + dataTypeName + "'");
        }
    }

    static int getNumDimensions(String dimensionNames) {
        if (StringUtils.isBlank((CharSequence)dimensionNames)) {
            throw new IllegalArgumentException("empty dimension names");
        }
        String[] splittednames = StringUtils.split((String)dimensionNames, (char)' ');
        return splittednames.length;
    }

    @Override
    public void initialize(Product product, ExportParameter exportParameter) throws IOException {
        this.explorerFile = AbstractFormatExporter.getSmosFile(product);
        this.gridPointCount = this.explorerFile.getGridPointCount();
        this.memberDescriptors = Dddb.getInstance().getMemberDescriptors(this.explorerFile.getHeaderFile());
        this.createVariableDescriptors(exportParameter);
    }

    @Override
    public int prepareGeographicSubset(ExportParameter exportParameter) throws IOException {
        if (exportParameter.getGeometry() != null) {
            GeometryFilter geometryFilter = GeometryFilterFactory.create(exportParameter.getGeometry());
            this.gpIndexList = new ArrayList(this.gridPointCount);
            for (int i = 0; i < this.gridPointCount; ++i) {
                CompoundData gridPointData = this.explorerFile.getGridPointData(i);
                if (!geometryFilter.accept(gridPointData)) continue;
                this.gpIndexList.add(i);
            }
            this.gridPointCount = this.gpIndexList.size();
            return this.gridPointCount;
        }
        return -1;
    }

    @Override
    public void addGlobalAttributes(NFileWriteable nFileWriteable, MetadataElement metadataRoot, ExportParameter exportParameter) throws IOException {
        String contact;
        String institution = exportParameter.getInstitution();
        if (StringUtils.isNotBlank((CharSequence)institution)) {
            nFileWriteable.addGlobalAttribute("institution", institution);
        }
        if (StringUtils.isNotBlank((CharSequence)(contact = exportParameter.getContact()))) {
            nFileWriteable.addGlobalAttribute("contact", contact);
        }
        nFileWriteable.addGlobalAttribute("creation_date", DateTimeUtils.toFixedHeaderFormat((Date)new Date()));
        nFileWriteable.addGlobalAttribute("total_number_of_grid_points", Integer.toString(this.gridPointCount));
        List<AttributeEntry> attributeList = AbstractFormatExporter.extractMetadata(metadataRoot);
        for (AttributeEntry entry : attributeList) {
            nFileWriteable.addGlobalAttribute(entry.getName(), entry.getValue());
        }
    }

    @Override
    public void addVariables(NFileWriteable nFileWriteable, ExportParameter exportParameter) throws IOException {
        Set<String> variableNameKeys = this.variableDescriptors.keySet();
        String[] outputBandNames = exportParameter.getVariableNames();
        for (String ncVariableName : variableNameKeys) {
            String flagMeanings;
            short[] flagValues;
            short[] flagMasks;
            if (!AbstractFormatExporter.mustExport(ncVariableName, outputBandNames)) continue;
            VariableDescriptor variableDescriptor = this.variableDescriptors.get(ncVariableName);
            DataType dataType = variableDescriptor.getDataType();
            boolean unsigned = variableDescriptor.isUnsigned();
            NVariable nVariable = nFileWriteable.addVariable(ncVariableName, dataType, unsigned, null, variableDescriptor.getDimensionNames(), exportParameter.getCompressionLevel());
            String unitValue = variableDescriptor.getUnit();
            if (StringUtils.isNotBlank((CharSequence)unitValue)) {
                nVariable.addAttribute("units", unitValue);
            }
            if (variableDescriptor.isFillValuePresent()) {
                float fillValue = variableDescriptor.getFillValue();
                if (dataType == DataType.UBYTE || dataType == DataType.BYTE) {
                    nVariable.addAttribute("_FillValue", (Number)((byte)fillValue), unsigned);
                } else if (dataType == DataType.USHORT || dataType == DataType.SHORT) {
                    nVariable.addAttribute("_FillValue", (Number)((short)fillValue), unsigned);
                } else if (dataType == DataType.UINT || dataType == DataType.INT) {
                    nVariable.addAttribute("_FillValue", (Number)((int)fillValue), unsigned);
                } else if (dataType == DataType.ULONG || dataType == DataType.LONG) {
                    nVariable.addAttribute("_FillValue", (Number)((long)fillValue), unsigned);
                } else if (dataType == DataType.FLOAT) {
                    nVariable.addAttribute("_FillValue", (Number)Float.valueOf(fillValue));
                } else if (dataType == DataType.DOUBLE) {
                    nVariable.addAttribute("_FillValue", (Number)fillValue);
                } else {
                    throw new IllegalStateException("Unsupported data type: " + dataType.toString());
                }
            }
            if (variableDescriptor.isValidMinPresent()) {
                nVariable.addAttribute("valid_min", (Number)Float.valueOf(variableDescriptor.getValidMin()));
            }
            if (variableDescriptor.isValidMaxPresent()) {
                nVariable.addAttribute("valid_max", (Number)Float.valueOf(variableDescriptor.getValidMax()));
            }
            if ((flagMasks = variableDescriptor.getFlagMasks()) != null) {
                nVariable.addAttribute("flag_masks", Array.factory((DataType)DataType.SHORT, (int[])new int[]{flagMasks.length}, (Object)flagMasks));
            }
            if ((flagValues = variableDescriptor.getFlagValues()) != null) {
                nVariable.addAttribute("flag_values", Array.factory((DataType)DataType.SHORT, (int[])new int[]{flagValues.length}, (Object)flagValues));
            }
            if (StringUtils.isNotBlank((CharSequence)(flagMeanings = variableDescriptor.getFlagMeanings()))) {
                nVariable.addAttribute("flag_meanings", flagMeanings);
            }
            if (variableDescriptor.isScaleFactorPresent() || variableDescriptor.isScaleOffsetPresent()) {
                nVariable.addAttribute("scale_factor", (Number)variableDescriptor.getScaleFactor());
                nVariable.addAttribute("scale_offset", (Number)variableDescriptor.getScaleOffset());
            }
            if (!unsigned) continue;
            nVariable.addAttribute("_Unsigned", "true");
        }
    }

    @Override
    public abstract void addDimensions(NFileWriteable var1) throws IOException;

    void createVariableDescriptors(ExportParameter exportParameter) {
        this.variableDescriptors = new HashMap<String, VariableDescriptor>();
        String[] outputBandNames = exportParameter.getVariableNames();
        List memberDescriptorList = this.memberDescriptors.asList();
        for (MemberDescriptor memberDescriptor : memberDescriptorList) {
            short[] flagMasks;
            float scalingOffset;
            String memberDescriptorName = memberDescriptor.getName();
            if (!AbstractFormatExporter.mustExport(memberDescriptorName, outputBandNames)) continue;
            String dimensionNames = memberDescriptor.getDimensionNames();
            int numDimensions = AbstractFormatExporter.getNumDimensions(dimensionNames);
            String variableName = ExporterUtils.ensureNetCDFName(memberDescriptorName);
            VariableDescriptor variableDescriptor = new VariableDescriptor(variableName, memberDescriptor.isGridPointData(), DataType.OBJECT, dimensionNames, numDimensions == 2, memberDescriptor.getMemberIndex());
            AbstractFormatExporter.setDataType(variableDescriptor, memberDescriptor.getDataTypeName());
            variableDescriptor.setUnit(memberDescriptor.getUnit());
            variableDescriptor.setFillValue(memberDescriptor.getFillValue());
            float scalingFactor = memberDescriptor.getScalingFactor();
            if ((double)scalingFactor != 1.0) {
                variableDescriptor.setScaleFactor(scalingFactor);
            }
            if ((double)(scalingOffset = memberDescriptor.getScalingOffset()) != 0.0) {
                variableDescriptor.setScaleOffset(memberDescriptor.getScalingOffset());
            }
            if ((flagMasks = memberDescriptor.getFlagMasks()) != null) {
                variableDescriptor.setFlagMasks(memberDescriptor.getFlagMasks());
                variableDescriptor.setFlagValues(memberDescriptor.getFlagValues());
                variableDescriptor.setFlagMeanings(memberDescriptor.getFlagMeanings());
            }
            this.variableDescriptors.put(variableName, variableDescriptor);
        }
    }
}

