/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.smos.bufr.writer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Formatter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.iosp.smos.bufr.Message;
import ucar.nc2.iosp.smos.bufr.MessageScanner;
import ucar.nc2.util.Indent;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class Bufr2Xml {
    private XMLStreamWriter staxWriter;
    private Indent indent;
    private boolean skipMissing;

    public Bufr2Xml(Message message, NetcdfDataset ncfile, OutputStream os, boolean skipMissing) throws IOException {
        this.skipMissing = skipMissing;
        this.indent = new Indent(2);
        this.indent.setIndentLevel(0);
        try {
            XMLOutputFactory fac = XMLOutputFactory.newInstance();
            this.staxWriter = fac.createXMLStreamWriter(os, "UTF-8");
            this.staxWriter.writeStartDocument("UTF-8", "1.0");
            this.writeMessage(message, ncfile);
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeEndDocument();
            this.staxWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
    }

    void writeMessage(Message message, NetcdfDataset ncfile) {
        try {
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(this.indent.toString());
            this.staxWriter.writeStartElement("bufrMessage");
            this.staxWriter.writeAttribute("nobs", Integer.toString(message.getNumberDatasets()));
            this.indent.incr();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(this.indent.toString());
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(this.indent.toString());
            this.staxWriter.writeStartElement("edition");
            this.staxWriter.writeCharacters(Integer.toString(message.is.getBufrEdition()));
            this.staxWriter.writeEndElement();
            String header = message.getHeader().trim();
            if (header.length() > 0) {
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeCharacters(this.indent.toString());
                this.staxWriter.writeStartElement("header");
                this.staxWriter.writeCharacters(header);
                this.staxWriter.writeEndElement();
            }
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(this.indent.toString());
            this.staxWriter.writeStartElement("tableVersion");
            this.staxWriter.writeCharacters(message.getTableName());
            this.staxWriter.writeEndElement();
            this.staxWriter.writeStartElement("center");
            this.staxWriter.writeCharacters(message.getCenterName());
            this.staxWriter.writeEndElement();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(this.indent.toString());
            this.staxWriter.writeStartElement("category");
            this.staxWriter.writeCharacters(message.getCategoryFullName());
            this.staxWriter.writeEndElement();
            SequenceDS obs = (SequenceDS)ncfile.findVariable("obs");
            StructureDataIterator sdataIter = obs.getStructureIterator(-1);
            this.writeSequence((StructureDS)obs, sdataIter);
            this.indent.decr();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(this.indent.toString());
            this.staxWriter.writeEndElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSequence(StructureDS s, StructureDataIterator sdataIter) throws IOException, XMLStreamException {
        int count = 0;
        try {
            while (sdataIter.hasNext()) {
                StructureData sdata = sdataIter.next();
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeCharacters(this.indent.toString());
                this.staxWriter.writeStartElement("struct");
                this.staxWriter.writeAttribute("name", this.quoteXmlAttribute(s.getShortName()));
                this.staxWriter.writeAttribute("count", Integer.toString(count++));
                for (StructureMembers.Member m : sdata.getMembers()) {
                    ArrayStructure data;
                    StructureDS sds;
                    Variable v = s.findVariable(m.getName());
                    this.indent.incr();
                    if (m.getDataType().isString() || m.getDataType().isNumeric()) {
                        this.writeVariable((VariableDS)v, sdata.getArray(m));
                    } else if (m.getDataType() == DataType.STRUCTURE) {
                        sds = (StructureDS)v;
                        data = (ArrayStructure)sdata.getArray(m);
                        this.writeSequence(sds, data.getStructureDataIterator());
                    } else if (m.getDataType() == DataType.SEQUENCE) {
                        sds = (SequenceDS)v;
                        data = (ArraySequence)sdata.getArray(m);
                        this.writeSequence(sds, data.getStructureDataIterator());
                    }
                    this.indent.decr();
                }
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeCharacters(this.indent.toString());
                this.staxWriter.writeEndElement();
            }
        }
        finally {
            sdataIter.close();
        }
    }

    void writeVariable(VariableDS v, Array mdata) throws XMLStreamException {
        Attribute att;
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeCharacters(this.indent.toString());
        this.staxWriter.writeStartElement("data");
        String name = v.getShortName();
        this.staxWriter.writeAttribute("name", this.quoteXmlAttribute(name));
        String units = v.getUnitsString();
        if (units != null && !units.equals(name) && !units.startsWith("Code")) {
            this.staxWriter.writeAttribute("units", this.quoteXmlAttribute(v.getUnitsString()));
        }
        String desc = (att = v.findAttribute("BUFR:TableB_descriptor")) == null ? "N/A" : att.getStringValue();
        this.staxWriter.writeAttribute("bufr", this.quoteXmlAttribute(desc));
        if (v.getDataType() == DataType.CHAR) {
            ArrayChar ac = (ArrayChar)mdata;
            this.staxWriter.writeCharacters(ac.getString());
        } else {
            int count = 0;
            mdata.resetLocalIterator();
            while (mdata.hasNext()) {
                if (count > 0) {
                    this.staxWriter.writeCharacters(" ");
                }
                ++count;
                if (v.getDataType().isNumeric()) {
                    double val = mdata.nextDouble();
                    if (v.isMissing(val)) {
                        this.staxWriter.writeCharacters("missing");
                        continue;
                    }
                    if (v.getDataType() == DataType.FLOAT || v.getDataType() == DataType.DOUBLE) {
                        this.writeFloat((Variable)v, val);
                        continue;
                    }
                    this.staxWriter.writeCharacters(mdata.toString());
                    continue;
                }
                String s = StringUtil2.filter7bits((String)mdata.next().toString());
                this.staxWriter.writeCharacters(this.quoteXmlContent(s));
            }
        }
        this.staxWriter.writeEndElement();
    }

    private String quoteXmlContent(String content) {
        char[] xmlInC = new char[]{'&', '<', '>'};
        String[] xmlOutC = new String[]{"&", "<", ">"};
        return StringUtil2.replace((String)content, (char[])xmlInC, (String[])xmlOutC);
    }

    private String quoteXmlAttribute(String name) {
        char[] xmlIn = new char[]{'&', '\"', '\'', '<', '>', '\r', '\n'};
        String[] xmlOut = new String[]{"&", "\"", "'", "<", ">", " ", " "};
        return StringUtil2.replace((String)name, (char[])xmlIn, (String[])xmlOut);
    }

    private void writeFloat(Variable v, double val) throws XMLStreamException {
        int sigDigits;
        Attribute bitWidthAtt = v.findAttribute("BUFR:bitWidth");
        if (bitWidthAtt == null) {
            sigDigits = 7;
        } else {
            int bitWidth = bitWidthAtt.getNumericValue().intValue();
            if (bitWidth < 30) {
                double sigDigitsD = Math.log10(2 << bitWidth);
                sigDigits = (int)(sigDigitsD + 1.0);
            } else {
                sigDigits = 7;
            }
        }
        Formatter stringFormatter = new Formatter();
        String format = "%." + sigDigits + "g";
        stringFormatter.format(format, val);
        this.staxWriter.writeCharacters(stringFormatter.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) throws Exception {
        String filename = "C:/data/formats/bufr/uniqueExamples.bufr";
        Message message = null;
        RandomAccessFile raf = null;
        OutputStream out = null;
        int size = 0;
        try {
            int count = 0;
            raf = new RandomAccessFile(filename, "r");
            MessageScanner scan = new MessageScanner(raf);
            while (scan.hasNext()) {
                message = scan.next();
                if (!message.isTablesComplete() || !message.isBitCountOk()) continue;
                byte[] mbytes = scan.getMessageBytesFromLast(message);
                try {
                    out = new FileOutputStream("C:/data/formats/bufr/uniqueE/" + count + ".xml");
                    NetcdfFile ncfile = NetcdfFile.openInMemory((String)"test", (byte[])mbytes, (String)"ucar.nc2.iosp.bufr.BufrIosp");
                    NetcdfDataset ncd = new NetcdfDataset(ncfile);
                    new Bufr2Xml(message, ncd, out, true);
                    out.close();
                    ++count;
                    size = (int)((long)size + message.getMessageSize());
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
            if (out != null) {
                out.close();
            }
        }
        System.out.printf("total size= %f Kb %n", 0.001 * (double)size);
    }
}

