/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.smos.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.smos.bufr.ConstructNC;
import ucar.nc2.iosp.smos.bufr.Message;
import ucar.nc2.iosp.smos.bufr.MessageCompressedDataReader;
import ucar.nc2.iosp.smos.bufr.MessageScanner;
import ucar.nc2.iosp.smos.bufr.MessageUncompressedDataReader;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public final class SmosBufrIosp
extends AbstractIOServiceProvider {
    private final List<Message> messageList = new ArrayList<Message>();
    private Message prototypeMessage;
    private ConstructNC construct;
    private boolean wantTime;
    private int elementCount = -1;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return MessageScanner.isValidFile(raf);
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.raf = raf;
        MessageScanner messageScanner = new MessageScanner(raf);
        while (messageScanner.hasNext()) {
            Message m = messageScanner.next();
            if (m == null || m.containsBufrTable()) continue;
            if (this.prototypeMessage == null) {
                this.prototypeMessage = m;
                this.prototypeMessage.getRootDataDescriptor();
                if (!this.prototypeMessage.isTablesComplete()) {
                    throw new IOException("Incomplete data tables in file = " + ncfile.getLocation());
                }
            } else if (!this.prototypeMessage.equals(m)) continue;
            this.messageList.add(m);
        }
        int observationCount = 0;
        for (Message m : this.messageList) {
            observationCount += m.getNumberDatasets();
        }
        if (this.prototypeMessage == null) {
            throw new IOException("No data messages in file = " + ncfile.getLocation());
        }
        this.construct = new ConstructNC(this.prototypeMessage, observationCount, ncfile);
        ncfile.finish();
    }

    public Object sendIospMessage(Object message) {
        String text;
        if (message instanceof String && (text = (String)message).equals("AddTime")) {
            this.wantTime = true;
            return true;
        }
        return super.sendIospMessage(message);
    }

    public Array readData(Variable v2, Section section) {
        Sequence s = this.construct.recordStructure;
        return new ArraySequence(s.makeStructureMembers(), (StructureDataIterator)new SeqIter(), this.elementCount);
    }

    private void addTime(ArrayStructure as) throws IOException {
        int n = (int)as.getSize();
        Array timeData = Array.factory((DataType)DataType.STRING, (int[])new int[]{n});
        IndexIterator ii = timeData.getIndexIterator();
        if (as instanceof ArrayStructureBB) {
            ArrayStructureBB asbb = (ArrayStructureBB)as;
            StructureMembers.Member m = asbb.findMember("time");
            try (StructureDataIterator iter = as.getStructureDataIterator();){
                int recno = 0;
                while (iter.hasNext()) {
                    CalendarDate cd = this.construct.makeObsTimeValue(iter.next());
                    asbb.addObjectToHeap(recno, m, (Object)cd.toString());
                    ++recno;
                }
            }
        }
        try (StructureDataIterator iter = as.getStructureDataIterator();){
            while (iter.hasNext()) {
                CalendarDate cd = this.construct.makeObsTimeValue(iter.next());
                ii.setObjectNext((Object)cd.toString());
            }
        }
        StructureMembers.Member m = as.findMember("time");
        m.setDataArray(timeData);
    }

    public StructureDataIterator getStructureIterator(Structure s, int bufferSize) {
        return new SeqIter();
    }

    public StructureDataIterator getStructureDataIterator(int messageIndex) throws IOException {
        return this.getStructureDataIterator(this.messageList.get(messageIndex));
    }

    StructureDataIterator getStructureDataIterator(Message message) throws IOException {
        ArrayStructure as;
        if (message.dds.isCompressed()) {
            MessageCompressedDataReader reader = new MessageCompressedDataReader();
            as = reader.readEntireMessage((Structure)this.construct.recordStructure, this.prototypeMessage, message, this.raf, null);
        } else {
            MessageUncompressedDataReader reader = new MessageUncompressedDataReader();
            as = reader.readEntireMessage((Structure)this.construct.recordStructure, this.prototypeMessage, message, this.raf, null);
        }
        if (this.wantTime && this.construct.isTimeOk()) {
            this.addTime(as);
        }
        return as.getStructureDataIterator();
    }

    public int getMessageCount() {
        return this.messageList.size();
    }

    public String getDetailInfo() {
        Formatter formatter = new Formatter();
        formatter.format("%s", super.getDetailInfo());
        try {
            this.prototypeMessage.dump(formatter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return formatter.toString();
    }

    public String getFileTypeId() {
        return "BUFR";
    }

    public String getFileTypeDescription() {
        return "WMO Binary Universal Form";
    }

    private class SeqIter
    implements StructureDataIterator {
        final boolean addTime;
        Iterator<Message> messageIterator;
        StructureDataIterator structureDataIterator;
        int recordNumber = 0;
        int bufferSize = -1;

        private SeqIter() {
            this.addTime = false;
            this.reset();
        }

        public StructureDataIterator reset() {
            this.recordNumber = 0;
            this.messageIterator = SmosBufrIosp.this.messageList.iterator();
            this.structureDataIterator = null;
            return this;
        }

        public boolean hasNext() throws IOException {
            if (this.structureDataIterator == null) {
                this.structureDataIterator = this.readNextMessage();
                if (this.structureDataIterator == null) {
                    SmosBufrIosp.this.elementCount = this.recordNumber;
                    return false;
                }
            }
            if (!this.structureDataIterator.hasNext()) {
                this.structureDataIterator = this.readNextMessage();
                return this.hasNext();
            }
            return true;
        }

        public StructureData next() throws IOException {
            ++this.recordNumber;
            return this.structureDataIterator.next();
        }

        private StructureDataIterator readNextMessage() throws IOException {
            if (!this.messageIterator.hasNext()) {
                return null;
            }
            Message m = this.messageIterator.next();
            return SmosBufrIosp.this.getStructureDataIterator(m);
        }

        public void setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        public int getCurrentRecno() {
            return this.recordNumber - 1;
        }

        public void close() {
            if (this.structureDataIterator != null) {
                this.structureDataIterator.close();
            }
            this.structureDataIterator = null;
        }
    }
}

