/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.smos.bufr;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.smos.bufr.BufrNumbers;
import ucar.nc2.iosp.smos.bufr.DataDescriptor;
import ucar.nc2.iosp.smos.bufr.Message;
import ucar.nc2.iosp.smos.bufr.tables.CodeFlagTables;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;

class ConstructNC {
    private static Logger log = LoggerFactory.getLogger(ConstructNC.class);
    static final String TIME_NAME = "time";
    private static final boolean warnUnits = false;
    private NetcdfFile ncfile;
    Sequence recordStructure;
    private Message proto;
    private int structNum = 1;
    private int seqNum = 1;
    private int tempNo = 1;
    private boolean isTimeOk;
    private String yearName;
    private String monthName;
    private String dayName;
    private String hourName;
    private String minName;
    private String secName;
    private String doyName;
    private CalendarDateUnit dateUnit;

    ConstructNC(Message proto, int nobs, NetcdfFile nc) throws IOException {
        this.proto = proto;
        this.ncfile = nc;
        int cat = proto.ids.getCategory();
        int subcat = proto.ids.getSubCategory();
        this.ncfile.addAttribute(null, new Attribute("history", "Direct read of BUFR data by CDM"));
        if (nc.getLocation() != null) {
            this.ncfile.addAttribute(null, new Attribute("location", nc.getLocation()));
        }
        this.ncfile.addAttribute(null, new Attribute("BUFR:edition", (Number)proto.is.getBufrEdition()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:categoryName", proto.getCategoryName()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:category", (Number)cat));
        this.ncfile.addAttribute(null, new Attribute("BUFR:subCategory", (Number)subcat));
        this.ncfile.addAttribute(null, new Attribute("BUFR:localSubCategory", (Number)proto.ids.getLocalSubCategory()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:centerName", proto.getCenterName()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:center", (Number)proto.ids.getCenterId()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:subCenter", (Number)proto.ids.getSubCenterId()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:table", (Number)proto.ids.getMasterTableId()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:tableVersion", (Number)proto.ids.getMasterTableVersion()));
        this.ncfile.addAttribute(null, new Attribute("BUFR:localTableVersion", (Number)proto.ids.getLocalTableVersion()));
        String header = proto.getHeader();
        if (header != null) {
            this.ncfile.addAttribute(null, new Attribute("WMO Header", header));
        }
        this.ncfile.addAttribute(null, new Attribute("Conventions", "BUFR/CDM"));
        this.makeObsRecord();
        this.ncfile.finish();
    }

    private Structure makeReportIndexStructure() throws IOException {
        Structure reportIndex = new Structure(this.ncfile, null, null, "obsRecordIndex");
        this.ncfile.addVariable(null, (Variable)reportIndex);
        reportIndex.setDimensions("record");
        reportIndex.addAttribute(new Attribute("long_name", "index on report"));
        Variable v = reportIndex.addMemberVariable(new Variable(this.ncfile, null, reportIndex, "name", DataType.STRING, ""));
        v.addAttribute(new Attribute("long_name", "name of station"));
        v.addAttribute(new Attribute("standard_name", "station_name"));
        v = reportIndex.addMemberVariable(new Variable(this.ncfile, null, reportIndex, TIME_NAME, DataType.LONG, ""));
        v.addAttribute(new Attribute("units", "msecs since 1970-01-01 00:00"));
        v.addAttribute(new Attribute("long_name", "observation time"));
        v.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
        return reportIndex;
    }

    private void makeObsRecord() throws IOException {
        this.recordStructure = new Sequence(this.ncfile, null, null, "obs");
        this.ncfile.addVariable(null, (Variable)this.recordStructure);
        DataDescriptor root = this.proto.getRootDataDescriptor();
        if (this.hasTime()) {
            this.isTimeOk = true;
            Variable timev = this.recordStructure.addMemberVariable(new Variable(this.ncfile, null, (Structure)this.recordStructure, TIME_NAME, DataType.STRING, ""));
            timev.addAttribute(new Attribute("units", this.dateUnit.toString()));
            timev.addAttribute(new Attribute("long_name", "time of observation"));
            timev.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
        }
        for (DataDescriptor dkey : root.subKeys) {
            if (!dkey.isOkForVariable()) continue;
            if (dkey.replication == 0) {
                this.addSequence((Structure)this.recordStructure, dkey);
                continue;
            }
            if (dkey.replication > 1) {
                List<DataDescriptor> subKeys = dkey.subKeys;
                if (subKeys.size() == 1) {
                    DataDescriptor sub = dkey.subKeys.get(0);
                    if (sub.dpi != null) {
                        this.addDpiStructure((Structure)this.recordStructure, dkey, sub);
                        continue;
                    }
                    if (sub.replication == 1) {
                        Variable v = this.addVariable((Structure)this.recordStructure, sub, dkey.replication);
                        v.setSPobject((Object)dkey);
                        continue;
                    }
                    this.addStructure((Structure)this.recordStructure, dkey, dkey.replication);
                    continue;
                }
                if (subKeys.size() <= 1) continue;
                this.addStructure((Structure)this.recordStructure, dkey, dkey.replication);
                continue;
            }
            this.addVariable((Structure)this.recordStructure, dkey, dkey.replication);
        }
    }

    private void addStructure(Structure parent, DataDescriptor dataDesc, int count) {
        String uname;
        dataDesc.name = uname = this.findUnique(parent, dataDesc.name, "struct");
        Structure struct = new Structure(this.ncfile, null, parent, uname);
        try {
            struct.setDimensionsAnonymous(new int[]{count});
        }
        catch (InvalidRangeException e) {
            log.error("illegal count= " + count + " for " + dataDesc);
        }
        for (DataDescriptor subKey : dataDesc.getSubKeys()) {
            this.addMember(struct, subKey);
        }
        parent.addMemberVariable((Variable)struct);
        struct.setSPobject((Object)dataDesc);
        dataDesc.refersTo = struct;
    }

    private void addSequence(Structure parent, DataDescriptor dataDesc) {
        String uname;
        dataDesc.name = uname = this.findUnique(parent, dataDesc.name, "seq");
        Sequence seq = new Sequence(this.ncfile, null, parent, uname);
        seq.setDimensions("");
        for (DataDescriptor dkey : dataDesc.getSubKeys()) {
            this.addMember((Structure)seq, dkey);
        }
        parent.addMemberVariable((Variable)seq);
        seq.setSPobject((Object)dataDesc);
        dataDesc.refersTo = seq;
    }

    private void addMember(Structure parent, DataDescriptor dkey) {
        if (dkey.replication == 0) {
            this.addSequence(parent, dkey);
        } else if (dkey.replication > 1) {
            List<DataDescriptor> subKeys = dkey.subKeys;
            if (subKeys.size() == 1) {
                DataDescriptor sub = dkey.subKeys.get(0);
                Variable v = this.addVariable(parent, sub, dkey.replication);
                v.setSPobject((Object)dkey);
            } else {
                this.addStructure(parent, dkey, dkey.replication);
            }
        } else {
            this.addVariable(parent, dkey, dkey.replication);
        }
    }

    private void addDpiStructure(Structure parent, DataDescriptor parentDD, DataDescriptor dpiField) {
        String uname;
        dpiField.name = uname = this.findUnique(parent, dpiField.name, "struct");
        Structure struct = new Structure(this.ncfile, null, parent, uname);
        int n = parentDD.replication;
        try {
            struct.setDimensionsAnonymous(new int[]{n});
        }
        catch (InvalidRangeException e) {
            log.error("illegal count= 1 for " + dpiField);
        }
        Variable v = new Variable(this.ncfile, null, struct, "name");
        v.setDataType(DataType.STRING);
        v.setDimensions("");
        struct.addMemberVariable(v);
        v = new Variable(this.ncfile, null, struct, "data");
        v.setDataType(DataType.FLOAT);
        v.setDimensions("");
        struct.addMemberVariable(v);
        parent.addMemberVariable((Variable)struct);
        struct.setSPobject((Object)dpiField);
        dpiField.refersTo = struct;
    }

    private void addDpiSequence(Structure parent, DataDescriptor dataDesc) {
        Structure struct = new Structure(this.ncfile, null, parent, "statistics");
        try {
            struct.setDimensionsAnonymous(new int[]{dataDesc.replication});
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
        Variable v = new Variable(this.ncfile, null, struct, "name");
        v.setDataType(DataType.STRING);
        v.setDimensions("");
        struct.addMemberVariable(v);
        v = new Variable(this.ncfile, null, struct, "data");
        v.setDataType(DataType.FLOAT);
        v.setDimensions("");
        struct.addMemberVariable(v);
        parent.addMemberVariable((Variable)struct);
    }

    private Variable addVariable(Structure struct, DataDescriptor dataDesc, int count) {
        String uname;
        dataDesc.name = uname = this.findUnique(struct, dataDesc.name, "unknown");
        Variable v = new Variable(this.ncfile, null, struct, uname);
        try {
            if (count > 1) {
                v.setDimensionsAnonymous(new int[]{count});
            } else {
                v.setDimensions("");
            }
        }
        catch (InvalidRangeException e) {
            log.error("illegal count= " + count + " for " + dataDesc);
        }
        if (dataDesc.desc != null) {
            v.addAttribute(new Attribute("long_name", dataDesc.desc));
        }
        if (dataDesc.units != null) {
            if (dataDesc.units.equalsIgnoreCase("Code_Table") || dataDesc.units.equalsIgnoreCase("Code Table")) {
                v.addAttribute(new Attribute("units", "CodeTable " + dataDesc.getFxyName()));
            } else if (dataDesc.units.equalsIgnoreCase("Flag_Table") || dataDesc.units.equalsIgnoreCase("Flag Table")) {
                v.addAttribute(new Attribute("units", "FlagTable " + dataDesc.getFxyName()));
            } else if (!dataDesc.units.startsWith("CCITT") && !dataDesc.units.startsWith("Numeric")) {
                v.addAttribute(new Attribute("units", dataDesc.units));
            }
        }
        if (dataDesc.type == 1) {
            v.setDataType(DataType.CHAR);
            int size = dataDesc.bitWidth / 8;
            try {
                v.setDimensionsAnonymous(new int[]{size});
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        } else if (dataDesc.type == 2 && CodeFlagTables.hasTable(dataDesc.fxy)) {
            int nbits = dataDesc.bitWidth;
            int nbytes = nbits % 8 == 0 ? nbits / 8 : nbits / 8 + 1;
            CodeFlagTables ct = CodeFlagTables.getTable(dataDesc.fxy);
            if (nbytes == 1) {
                v.setDataType(DataType.ENUM1);
            } else if (nbytes == 2) {
                v.setDataType(DataType.ENUM2);
            } else if (nbytes == 4) {
                v.setDataType(DataType.ENUM4);
            }
            v.addAttribute(new Attribute("BUFR:CodeTable", ct.getName() + " (" + dataDesc.getFxyName() + ")"));
            Group g = struct.getParentGroup();
            EnumTypedef enumTypedef = g.findEnumeration(ct.getName());
            if (enumTypedef == null) {
                enumTypedef = new EnumTypedef(ct.getName(), ct.getMap());
                g.addEnumeration(enumTypedef);
            }
            v.setEnumTypedef(enumTypedef);
        } else {
            double scale;
            int nbits = dataDesc.bitWidth;
            if (nbits < 9) {
                v.setDataType(DataType.BYTE);
                if (nbits == 8) {
                    v.addAttribute(new Attribute("_Unsigned", "true"));
                    v.addAttribute(new Attribute("missing_value", (Number)((short)BufrNumbers.missingValue(nbits))));
                } else {
                    v.addAttribute(new Attribute("missing_value", (Number)((byte)BufrNumbers.missingValue(nbits))));
                }
            } else if (nbits < 17) {
                v.setDataType(DataType.SHORT);
                if (nbits == 16) {
                    v.addAttribute(new Attribute("_Unsigned", "true"));
                    v.addAttribute(new Attribute("missing_value", (Number)BufrNumbers.missingValue(nbits)));
                } else {
                    v.addAttribute(new Attribute("missing_value", (Number)((short)BufrNumbers.missingValue(nbits))));
                }
            } else if (nbits < 33) {
                v.setDataType(DataType.INT);
                if (nbits == 32) {
                    v.addAttribute(new Attribute("_Unsigned", "true"));
                    v.addAttribute(new Attribute("missing_value", (Number)((int)BufrNumbers.missingValue(nbits))));
                } else {
                    v.addAttribute(new Attribute("missing_value", (Number)BufrNumbers.missingValue(nbits)));
                }
            } else {
                v.setDataType(DataType.LONG);
                v.addAttribute(new Attribute("missing_value", (Number)BufrNumbers.missingValue(nbits)));
            }
            int scale10 = dataDesc.scale;
            double d = scale = scale10 == 0 ? 1.0 : Math.pow(10.0, -scale10);
            if (scale10 != 0) {
                v.addAttribute(new Attribute("scale_factor", (Number)Float.valueOf((float)scale)));
            }
            if (dataDesc.refVal != 0) {
                v.addAttribute(new Attribute("add_offset", (Number)Float.valueOf((float)scale * (float)dataDesc.refVal)));
            }
        }
        this.annotate(v, dataDesc);
        v.addAttribute(new Attribute("BUFR:TableB_descriptor", dataDesc.getFxyName()));
        v.addAttribute(new Attribute("BUFR:bitWidth", (Number)dataDesc.bitWidth));
        struct.addMemberVariable(v);
        v.setSPobject((Object)dataDesc);
        return v;
    }

    private String findUnique(Structure struct, String want, String def) {
        if (want == null) {
            return def + this.tempNo++;
        }
        String vwant = NetcdfFile.makeValidCdmObjectName((String)want);
        Variable oldV = struct.findVariable(vwant);
        if (oldV == null) {
            return vwant;
        }
        int seq = 2;
        String wantSeq;
        while ((oldV = struct.findVariable(wantSeq = vwant + "-" + seq)) != null) {
            ++seq;
        }
        return wantSeq;
    }

    private void annotate(Variable v, DataDescriptor dkey) {
        String id = dkey.getFxyName();
        if (id.equals("0-5-1") || id.equals("0-5-2")) {
            v.addAttribute(new Attribute("units", "degrees_north"));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        }
        if (id.equals("0-6-1") || id.equals("0-6-2")) {
            v.addAttribute(new Attribute("units", "degrees_east"));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        }
        if (id.equals("0-7-1") || id.equals("0-7-2") || id.equals("0-7-10") || id.equals("0-7-30")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
        }
        if (id.equals("0-7-6") || id.equals("0-7-7")) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
        }
        if (id.equals("0-1-7") || id.equals("0-1-11") || id.equals("0-1-18") || id.equals("0-1-194") && this.proto.ids.getCenterId() == 59) {
            v.addAttribute(new Attribute("standard_name", "station_id"));
        }
        if (id.equals("0-1-2")) {
            v.addAttribute(new Attribute("standard_name", "station_WMO_id"));
        }
    }

    boolean isTimeOk() {
        return this.isTimeOk;
    }

    private boolean hasTime() throws IOException {
        boolean hasTime;
        DataDescriptor root = this.proto.getRootDataDescriptor();
        for (DataDescriptor dkey : root.subKeys) {
            if (!dkey.isOkForVariable()) continue;
            String key = dkey.getFxyName();
            if (key.equals("0-4-1") && this.yearName == null) {
                this.yearName = dkey.name;
            }
            if (key.equals("0-4-2") && this.monthName == null) {
                this.monthName = dkey.name;
            }
            if (key.equals("0-4-3") && this.dayName == null) {
                this.dayName = dkey.name;
            }
            if (key.equals("0-4-43") && this.doyName == null) {
                this.doyName = dkey.name;
            }
            if (key.equals("0-4-4") && this.hourName == null) {
                this.hourName = dkey.name;
            }
            if (key.equals("0-4-5") && this.minName == null) {
                this.minName = dkey.name;
            }
            if (!key.equals("0-4-6") && !key.equals("0-4-7") || this.secName != null) continue;
            this.secName = dkey.name;
        }
        boolean bl = hasTime = this.yearName != null && (this.monthName != null && this.dayName != null || this.doyName != null) && this.hourName != null;
        if (hasTime) {
            String u = this.secName != null ? "secs" : (this.minName != null ? "minutes" : "hours");
            try {
                this.dateUnit = CalendarDateUnit.of(null, (String)"msecs since 1970-01-01T00:00:00");
            }
            catch (Exception e) {
                log.error("BufrIosp failed to create date unit", (Throwable)e);
                hasTime = false;
            }
        }
        return hasTime;
    }

    CalendarDate makeObsTimeValue(StructureData sdata) {
        int sec;
        int year = sdata.convertScalarInt(this.yearName);
        int hour = sdata.convertScalarInt(this.hourName);
        int min = this.minName == null ? 0 : sdata.convertScalarInt(this.minName);
        int n = sec = this.secName == null ? 0 : sdata.convertScalarInt(this.secName);
        if (sec < 0) {
            System.out.println("HEY");
            sdata.convertScalarInt(this.secName);
            sec = 0;
        }
        if (this.dayName != null) {
            int day = sdata.convertScalarInt(this.dayName);
            int month = sdata.convertScalarInt(this.monthName);
            try {
                return CalendarDate.of(null, (int)year, (int)month, (int)day, (int)hour, (int)min, (int)sec);
            }
            catch (RuntimeException t) {
                log.error("Illegal Date fields", (Throwable)t);
                return CalendarDate.present();
            }
        }
        int doy = sdata.convertScalarInt(this.doyName);
        return CalendarDate.withDoy(null, (int)year, (int)doy, (int)hour, (int)min, (int)sec);
    }

    private static String identifyCoords(String val) {
        if (val.equals("0-5-1") || val.equals("0-5-2")) {
            return AxisType.Lat.toString();
        }
        if (val.equals("0-6-1") || val.equals("0-6-2")) {
            return AxisType.Lon.toString();
        }
        if (val.equals("0-7-30") || val.equals("0-7-1") || val.equals("0-7-2") || val.equals("0-7-10")) {
            return AxisType.Height.toString();
        }
        if (val.equals("0-4-1")) {
            return "year";
        }
        if (val.equals("0-4-2")) {
            return "month";
        }
        if (val.equals("0-4-3")) {
            return "day";
        }
        if (val.equals("0-4-4")) {
            return "hour";
        }
        if (val.equals("0-4-5")) {
            return "minute";
        }
        if (val.equals("0-4-6") || val.equals("0-4-7")) {
            return "sec";
        }
        if (val.equals("0-1-1")) {
            return "wmo_block";
        }
        if (val.equals("0-1-2")) {
            return "wmo_id";
        }
        if (val.equals("0-1-7") || val.equals("0-1-194") || val.equals("0-1-11") || val.equals("0-1-18")) {
            return "station_id";
        }
        return null;
    }
}

