/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.provider;

import com.bc.ceres.binio.CompoundData;
import java.awt.geom.Area;
import java.io.IOException;
import java.text.MessageFormat;
import org.esa.smos.dataio.smos.L1cScienceSmosFile;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;

public class SnapshotValueProvider
extends AbstractValueProvider {
    private final L1cScienceSmosFile smosFile;
    private final int memberIndex;
    private final int polarisation;
    private final long snapshotId;

    public SnapshotValueProvider(L1cScienceSmosFile smosFile, int memberIndex, int polarisation, long snapshotId) {
        this.smosFile = smosFile;
        this.memberIndex = memberIndex;
        this.polarisation = polarisation;
        this.snapshotId = snapshotId;
    }

    @Override
    public int getGridPointIndex(int seqnum) {
        return 0;
    }

    @Override
    public byte getByte(int gridPointIndex) throws IOException {
        CompoundData data = this.getCompoundData(gridPointIndex);
        return data.getByte(this.memberIndex);
    }

    @Override
    public short getShort(int gridPointIndex) throws IOException {
        CompoundData data = this.getCompoundData(gridPointIndex);
        return data.getShort(this.memberIndex);
    }

    @Override
    public int getInt(int gridPointIndex) throws IOException {
        CompoundData data = this.getCompoundData(gridPointIndex);
        return data.getInt(this.memberIndex);
    }

    @Override
    public float getFloat(int gridPointIndex) throws IOException {
        CompoundData data = this.getCompoundData(gridPointIndex);
        return data.getFloat(this.memberIndex);
    }

    @Override
    public Area getArea() {
        return this.smosFile.getSnapshotInfo().getArea(this.snapshotId);
    }

    private CompoundData getCompoundData(int gridPointIndex) throws IOException {
        CompoundData data = this.smosFile.getSnapshotBtData(gridPointIndex, this.polarisation, this.snapshotId);
        if (data == null) {
            throw new IOException(MessageFormat.format("No data found for grid point ''{0}''.", gridPointIndex));
        }
        return data;
    }
}

