/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.provider;

import java.awt.geom.Area;
import java.io.IOException;
import java.util.Map;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.dataio.smos.provider.Scaler;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.Scaling;

public abstract class FP
extends AbstractValueProvider {
    private final AbstractValueProvider frxProvider;
    private final AbstractValueProvider fryProvider;
    private final AbstractValueProvider grxProvider;
    private final AbstractValueProvider gryProvider;
    private final AbstractValueProvider btxProvider;
    private final AbstractValueProvider btyProvider;
    private final AbstractValueProvider btxyProvider;
    private final boolean accuracy;
    private final boolean imaginary;

    public FP(Product product, Map<String, AbstractValueProvider> valueProviderMap, boolean accuracy, boolean imaginary) {
        this.accuracy = accuracy;
        this.imaginary = imaginary;
        this.frxProvider = FP.getValueProvider(product.getBand("Faraday_Rotation_Angle_X"), valueProviderMap);
        this.fryProvider = FP.getValueProvider(product.getBand("Faraday_Rotation_Angle_Y"), valueProviderMap);
        this.grxProvider = FP.getValueProvider(product.getBand("Geometric_Rotation_Angle_X"), valueProviderMap);
        this.gryProvider = FP.getValueProvider(product.getBand("Geometric_Rotation_Angle_Y"), valueProviderMap);
        String quantity = accuracy ? "Pixel_Radiometric_Accuracy" : "BT_Value";
        if (imaginary) {
            this.btxProvider = null;
            this.btyProvider = null;
            this.btxyProvider = accuracy ? FP.getValueProvider(product.getBand(quantity + "_XY"), valueProviderMap) : FP.getValueProvider(product.getBand(quantity + "_XY_Imag"), valueProviderMap);
        } else {
            this.btxProvider = FP.getValueProvider(product.getBand(quantity + "_X"), valueProviderMap);
            this.btyProvider = FP.getValueProvider(product.getBand(quantity + "_Y"), valueProviderMap);
            this.btxyProvider = accuracy ? FP.getValueProvider(product.getBand(quantity + "_XY"), valueProviderMap) : FP.getValueProvider(product.getBand(quantity + "_XY_Real"), valueProviderMap);
        }
    }

    private static AbstractValueProvider getValueProvider(Band band, Map<String, AbstractValueProvider> map) {
        if (band.isScalingApplied()) {
            return new Scaler(map.get(band.getName()), (Scaling)band);
        }
        return map.get(band.getName());
    }

    @Override
    public final Area getArea() {
        return this.frxProvider.getArea();
    }

    @Override
    public final float getValue(int seqnum, float noDataValue) {
        float value = super.getValue(seqnum, noDataValue);
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            return noDataValue;
        }
        return value;
    }

    @Override
    public final int getGridPointIndex(int seqnum) {
        return this.frxProvider.getGridPointIndex(seqnum);
    }

    @Override
    public final byte getByte(int gridPointIndex) {
        return 0;
    }

    @Override
    public final short getShort(int gridPointIndex) {
        return 0;
    }

    @Override
    public final int getInt(int gridPointIndex) {
        return 0;
    }

    @Override
    public final float getFloat(int gridPointIndex) throws IOException {
        double btxy;
        double bty;
        double btx;
        double frx = this.frxProvider.getFloat(gridPointIndex);
        double fry = this.fryProvider.getFloat(gridPointIndex);
        double grx = this.grxProvider.getFloat(gridPointIndex);
        double gry = this.gryProvider.getFloat(gridPointIndex);
        double fr = -FP.angularAverage(frx, fry);
        double gr = -FP.angularAverage(grx, gry);
        double alpha = Math.toRadians(fr + gr);
        double a = Math.cos(alpha);
        double b = Math.sin(alpha);
        double aa = a * a;
        double ab = a * b;
        double bb = b * b;
        if (this.imaginary) {
            btx = 0.0;
            bty = 0.0;
            btxy = this.btxyProvider.getFloat(gridPointIndex);
        } else {
            btx = this.btxProvider.getFloat(gridPointIndex);
            bty = this.btyProvider.getFloat(gridPointIndex);
            btxy = this.btxyProvider.getFloat(gridPointIndex);
        }
        float result = this.accuracy ? this.computeRA(btx, bty, btxy, aa, ab, bb) : this.computeBT(btx, bty, btxy, aa, ab, bb);
        return result;
    }

    protected abstract float computeBT(double var1, double var3, double var5, double var7, double var9, double var11);

    protected abstract float computeRA(double var1, double var3, double var5, double var7, double var9, double var11);
}

