/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.provider;

import java.awt.geom.Area;
import java.io.IOException;
import java.util.Map;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.dataio.smos.provider.Scaler;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.Scaling;

public abstract class DP
extends AbstractValueProvider {
    private final AbstractValueProvider frxProvider;
    private final AbstractValueProvider fryProvider;
    private final AbstractValueProvider grxProvider;
    private final AbstractValueProvider gryProvider;
    private final AbstractValueProvider btxProvider;
    private final AbstractValueProvider btyProvider;
    private final boolean accuracy;

    public DP(Product product, Map<String, AbstractValueProvider> valueProviderMap, boolean accuracy) {
        this.accuracy = accuracy;
        this.frxProvider = DP.getValueProvider(product.getBand("Faraday_Rotation_Angle_X"), valueProviderMap);
        this.fryProvider = DP.getValueProvider(product.getBand("Faraday_Rotation_Angle_Y"), valueProviderMap);
        this.grxProvider = DP.getValueProvider(product.getBand("Geometric_Rotation_Angle_X"), valueProviderMap);
        this.gryProvider = DP.getValueProvider(product.getBand("Geometric_Rotation_Angle_Y"), valueProviderMap);
        String quantity = accuracy ? "Pixel_Radiometric_Accuracy" : "BT_Value";
        this.btxProvider = DP.getValueProvider(product.getBand(quantity + "_X"), valueProviderMap);
        this.btyProvider = DP.getValueProvider(product.getBand(quantity + "_Y"), valueProviderMap);
    }

    private static AbstractValueProvider getValueProvider(Band band, Map<String, AbstractValueProvider> map) {
        if (band.isScalingApplied()) {
            return new Scaler(map.get(band.getName()), (Scaling)band);
        }
        return map.get(band.getName());
    }

    @Override
    public final Area getArea() {
        return this.frxProvider.getArea();
    }

    @Override
    public final float getValue(int seqnum, float noDataValue) {
        float value = super.getValue(seqnum, noDataValue);
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            return noDataValue;
        }
        return value;
    }

    @Override
    public final int getGridPointIndex(int seqnum) {
        return this.frxProvider.getGridPointIndex(seqnum);
    }

    @Override
    public final byte getByte(int gridPointIndex) {
        return 0;
    }

    @Override
    public final short getShort(int gridPointIndex) {
        return 0;
    }

    @Override
    public final int getInt(int gridPointIndex) {
        return 0;
    }

    @Override
    public final float getFloat(int gridPointIndex) throws IOException {
        double frx = this.frxProvider.getFloat(gridPointIndex);
        double fry = this.fryProvider.getFloat(gridPointIndex);
        double grx = this.grxProvider.getFloat(gridPointIndex);
        double gry = this.gryProvider.getFloat(gridPointIndex);
        double fr = -DP.angularAverage(frx, fry);
        double gr = -DP.angularAverage(grx, gry);
        double alpha = Math.toRadians(fr + gr);
        double a = Math.cos(alpha);
        double b = Math.sin(alpha);
        double aa = a * a;
        double bb = b * b;
        double btx = this.btxProvider.getFloat(gridPointIndex);
        double bty = this.btyProvider.getFloat(gridPointIndex);
        float result = this.accuracy ? (float)((double)this.computeRA(btx, bty, aa, bb) / Math.abs(aa * aa - bb * bb)) : (float)((double)this.computeBT(btx, bty, aa, bb) / (aa * aa - bb * bb));
        return result;
    }

    protected abstract float computeBT(double var1, double var3, double var5, double var7);

    protected abstract float computeRA(double var1, double var3, double var5, double var7);
}

