/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.provider;

import java.io.IOException;
import org.esa.smos.dataio.smos.provider.ValueProvider;

public abstract class AbstractValueProvider
implements ValueProvider {
    @Override
    public byte getValue(int seqnum, byte noDataValue) {
        int gridPointIndex = this.getGridPointIndex(seqnum);
        if (gridPointIndex == -1) {
            return noDataValue;
        }
        try {
            return this.getByte(gridPointIndex);
        }
        catch (IOException e) {
            return noDataValue;
        }
    }

    @Override
    public short getValue(int seqnum, short noDataValue) {
        int gridPointIndex = this.getGridPointIndex(seqnum);
        if (gridPointIndex == -1) {
            return noDataValue;
        }
        try {
            return this.getShort(gridPointIndex);
        }
        catch (IOException e) {
            return noDataValue;
        }
    }

    @Override
    public int getValue(int seqnum, int noDataValue) {
        int gridPointIndex = this.getGridPointIndex(seqnum);
        if (gridPointIndex == -1) {
            return noDataValue;
        }
        try {
            return this.getInt(gridPointIndex);
        }
        catch (IOException e) {
            return noDataValue;
        }
    }

    @Override
    public float getValue(int seqnum, float noDataValue) {
        int gridPointIndex = this.getGridPointIndex(seqnum);
        if (gridPointIndex == -1) {
            return noDataValue;
        }
        try {
            return this.getFloat(gridPointIndex);
        }
        catch (IOException e) {
            return noDataValue;
        }
    }

    public abstract int getGridPointIndex(int var1);

    public abstract byte getByte(int var1) throws IOException;

    public abstract short getShort(int var1) throws IOException;

    public abstract int getInt(int var1) throws IOException;

    public abstract float getFloat(int var1) throws IOException;

    public static double angularAverage(double angle1, double angle2) {
        if (AbstractValueProvider.inQuadrant1(angle1) && AbstractValueProvider.inQuadrant4(angle2)) {
            angle2 -= 360.0;
        } else if (AbstractValueProvider.inQuadrant1(angle2) && AbstractValueProvider.inQuadrant4(angle1)) {
            angle1 -= 360.0;
        }
        return (angle1 + angle2) / 2.0;
    }

    private static boolean inQuadrant1(double angle) {
        return angle >= 0.0 && angle < 90.0;
    }

    private static boolean inQuadrant4(double angle) {
        return angle > 270.0 && angle <= 360.0;
    }
}

