/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dffg;

class Eeap {
    private final double maxLat;
    private final double cutLat;
    private final double deltaLon;
    private final int zoneCount;

    static Eeap getInstance() {
        return Holder.INSTANCE;
    }

    int getZoneCount() {
        return this.zoneCount;
    }

    int getZoneIndex(double lon, double lat) {
        if (lat <= this.maxLat && lat > this.cutLat) {
            return 0;
        }
        if (lat <= -this.cutLat && lat > -this.maxLat) {
            return 1;
        }
        if (lat <= this.cutLat && lat > -this.cutLat) {
            if (lon < 0.0) {
                lon += 360.0;
            }
            return (int)Math.floor(lon / this.deltaLon) + 2;
        }
        return -1;
    }

    private Eeap() {
        this.maxLat = 89.0;
        this.cutLat = 75.0;
        this.deltaLon = 5.0;
        this.zoneCount = 2 + 2 * (int)(180.0 / this.deltaLon);
    }

    private static class Holder {
        private static final Eeap INSTANCE = new Eeap();

        private Holder() {
        }
    }
}

