/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dffg;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import java.awt.Color;
import java.io.IOException;
import org.esa.smos.EEFilePair;
import org.esa.smos.dataio.smos.CellValueProvider;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dffg.DffgFile;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Product;

public class DffgSnoFile
extends DffgFile {
    private static final String DFFG_SNO_POINT_DATA_TYPE_NAME = "DFFG_Snow_Point_Data_Type";
    private static final String LIST_OF_DFFG_SNO_POINT_DATA_NAME = "List_of_DFFG_Snow_Point_Datas";
    private static final String DFFG_SNO_NAME = "DFFG_Snow";

    public DffgSnoFile(EEFilePair eeFilePair, DataContext context) throws IOException {
        super(eeFilePair, context, DFFG_SNO_NAME, LIST_OF_DFFG_SNO_POINT_DATA_NAME);
    }

    @Override
    CompoundType getCellType() {
        return (CompoundType)this.getDataFormat().getTypeDef(DFFG_SNO_POINT_DATA_TYPE_NAME);
    }

    @Override
    void addBand(Product product, BandDescriptor descriptor, CompoundType compoundType) {
        if (!descriptor.isVisible()) {
            return;
        }
        int memberIndex = compoundType.getMemberIndex(descriptor.getMemberName());
        if (memberIndex >= 0) {
            CompoundMember member = compoundType.getMember(memberIndex);
            int dataType = ProductHelper.getDataType(member.getType());
            Band band = product.addBand(descriptor.getBandName(), dataType);
            band.setScalingOffset(descriptor.getScalingOffset());
            band.setScalingFactor(descriptor.getScalingFactor());
            if (descriptor.hasFillValue()) {
                band.setNoDataValueUsed(true);
                band.setNoDataValue(descriptor.getFillValue());
            }
            if (!descriptor.getValidPixelExpression().isEmpty()) {
                band.setValidPixelExpression(descriptor.getValidPixelExpression());
            }
            if (!descriptor.getUnit().isEmpty()) {
                band.setUnit(descriptor.getUnit());
            }
            if (!descriptor.getDescription().isEmpty()) {
                band.setDescription(descriptor.getDescription());
            }
            if (descriptor.getFlagDescriptors() != null) {
                ProductHelper.addFlagsAndMasks(product, band, descriptor.getFlagCodingName(), descriptor.getFlagDescriptors());
            }
            CellValueProvider valueProvider = this.createCellValueProvider(descriptor);
            band.setSourceImage(this.createSourceImage(band, valueProvider));
            band.setImageInfo(DffgSnoFile.createImageInfo());
        }
    }

    private static ImageInfo createImageInfo() {
        ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[]{new ColorPaletteDef.Point(0.0, new Color(0.0f, 0.0f, 0.0f, 0.0f)), new ColorPaletteDef.Point(0.1, new Color(0.1f, 0.1f, 0.1f)), new ColorPaletteDef.Point(100.0, new Color(1.0f, 1.0f, 1.0f))};
        return new ImageInfo(new ColorPaletteDef(points));
    }
}

