/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dffg;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import java.io.IOException;
import org.esa.smos.EEFilePair;
import org.esa.smos.dataio.smos.CellValueProvider;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dffg.DffgFile;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class DffgLaiFile
extends DffgFile {
    private static final String DFFG_LAI_NAME = "DFFG_LAI";
    private static final String DFFG_LAI_POINT_DATA_TYPE_NAME = "DFFG_LAI_Point_Data_Type";
    private static final String LIST_OF_DFFG_LAI_POINT_DATA_NAME = "List_of_DFFG_LAI_Point_Datas";
    private static final String TAG_SCALING_OFFSET = "Offset";
    private static final String TAG_SCALING_FACTOR = "Scaling_Factor";
    private final double scalingOffset;
    private final double scalingFactor;

    public DffgLaiFile(EEFilePair eeFilePair, DataContext dataContext) throws IOException {
        super(eeFilePair, dataContext, DFFG_LAI_NAME, LIST_OF_DFFG_LAI_POINT_DATA_NAME);
        Document document = this.getDocument();
        Namespace namespace = document.getRootElement().getNamespace();
        Element specificProductHeader = this.getElement(document.getRootElement(), "Specific_Product_Header");
        this.scalingOffset = Double.valueOf(specificProductHeader.getChildText(TAG_SCALING_OFFSET, namespace));
        this.scalingFactor = Double.valueOf(specificProductHeader.getChildText(TAG_SCALING_FACTOR, namespace));
    }

    @Override
    CompoundType getCellType() {
        return (CompoundType)this.getDataFormat().getTypeDef(DFFG_LAI_POINT_DATA_TYPE_NAME);
    }

    @Override
    void addBand(Product product, BandDescriptor descriptor, CompoundType compoundType) {
        if (!descriptor.isVisible()) {
            return;
        }
        int memberIndex = compoundType.getMemberIndex(descriptor.getMemberName());
        if (memberIndex >= 0) {
            CompoundMember member = compoundType.getMember(memberIndex);
            int dataType = ProductHelper.getDataType(member.getType());
            Band band = product.addBand(descriptor.getBandName(), dataType);
            if ("LAI".equals(member.getName())) {
                band.setScalingOffset(this.scalingOffset);
                band.setScalingFactor(this.scalingFactor);
            } else {
                band.setScalingOffset(descriptor.getScalingOffset());
                band.setScalingFactor(descriptor.getScalingFactor());
            }
            if (descriptor.hasFillValue()) {
                band.setNoDataValueUsed(true);
                band.setNoDataValue(descriptor.getFillValue());
            }
            if (!descriptor.getValidPixelExpression().isEmpty()) {
                band.setValidPixelExpression(descriptor.getValidPixelExpression());
            }
            if (!descriptor.getUnit().isEmpty()) {
                band.setUnit(descriptor.getUnit());
            }
            if (!descriptor.getDescription().isEmpty()) {
                band.setDescription(descriptor.getDescription());
            }
            if (descriptor.getFlagDescriptors() != null) {
                ProductHelper.addFlagsAndMasks(product, band, descriptor.getFlagCodingName(), descriptor.getFlagDescriptors());
            }
            CellValueProvider valueProvider = this.createCellValueProvider(descriptor);
            band.setSourceImage(this.createSourceImage(band, valueProvider));
            band.setImageInfo(ProductHelper.createImageInfo(band, descriptor));
        }
    }
}

