/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dffg;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.Dimension;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.esa.smos.EEFilePair;
import org.esa.smos.dataio.smos.CellGridOpImage;
import org.esa.smos.dataio.smos.CellValueProvider;
import org.esa.smos.dataio.smos.ExplorerFile;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dffg.Dffg;
import org.esa.smos.dataio.smos.dffg.Eeap;
import org.esa.smos.dgg.SmosDgg;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.util.io.FileUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

abstract class DffgFile
extends ExplorerFile {
    private static final String TAG_DIGITS_TO_SHIFT = "Digits_To_Shift";
    private static final String DELTA_LAT_NAME = "Delta_Lat";
    private static final String DELTA_LON_NAME = "Long_Step_Size_Ang";
    private static final String CUMULATED_LON_COUNT_NAME = "Cumulated_N_Lon";
    private static final String LON_COUNT_NAME = "N_Lon";
    private static final String MAX_LAT_NAME = "Lat_b";
    private static final String MIN_LAT_NAME = "Lat_a";
    private static final String MAX_LON_NAME = "Lon_b";
    private static final String MIN_LON_NAME = "Lon_a";
    private static final String LIST_OF_ROW_STRUCT_DATA_NAME = "List_of_Row_Struct_Datas";
    private final long zoneIndexMultiplier;
    private final String dataBlockSequence;
    private final String compoundSequence;
    private volatile List<Dffg> gridList = null;

    DffgFile(EEFilePair eeFilePair, DataContext dataContext, String dataBlockSequence, String compoundSequence) throws IOException {
        super(eeFilePair, dataContext);
        this.dataBlockSequence = dataBlockSequence;
        this.compoundSequence = compoundSequence;
        Document document = this.getDocument();
        Namespace namespace = document.getRootElement().getNamespace();
        Element specificProductHeader = this.getElement(document.getRootElement(), "Specific_Product_Header");
        int k = Integer.valueOf(specificProductHeader.getChildText(TAG_DIGITS_TO_SHIFT, namespace));
        this.zoneIndexMultiplier = (long)Math.pow(10.0, k);
    }

    abstract void addBand(Product var1, BandDescriptor var2, CompoundType var3);

    abstract CompoundType getCellType();

    @Override
    public Product createProduct() throws IOException {
        String productName = FileUtils.getFilenameWithoutExtension((File)this.getDataFile());
        String productType = this.getProductType();
        Dimension dimension = ProductHelper.getSceneRasterDimension();
        Product product = new Product(productName, productType, dimension.width, dimension.height);
        product.setFileLocation(this.getDataFile());
        product.setPreferredTileSize(512, 504);
        ProductHelper.addMetadata(product.getMetadataRoot(), this);
        product.setSceneGeoCoding(ProductHelper.createGeoCoding(dimension));
        this.addBands(product);
        return product;
    }

    @Override
    public Area getArea() {
        return new Area(new Rectangle2D.Double(-180.0, -88.59375, 360.0, 177.1875));
    }

    CellValueProvider createCellValueProvider(BandDescriptor descriptor) {
        int memberIndex = this.getCellType().getMemberIndex(descriptor.getMemberName());
        return new CellValueProviderImpl(memberIndex);
    }

    MultiLevelImage createSourceImage(Band band, CellValueProvider valueProvider) {
        return new DefaultMultiLevelImage(this.createMultiLevelSource(band, valueProvider));
    }

    long getCellIndex(double lon, double lat) {
        int gridIndex;
        int zoneIndex = Eeap.getInstance().getZoneIndex(lon, lat);
        if (zoneIndex != -1 && (gridIndex = this.getGridList().get(zoneIndex).getIndex(lon, lat)) != -1) {
            return (long)gridIndex + (long)zoneIndex * this.zoneIndexMultiplier;
        }
        return -1L;
    }

    private MultiLevelSource createMultiLevelSource(final Band band, final CellValueProvider valueProvider) {
        return new AbstractMultiLevelSource(SmosDgg.getInstance().getMultiLevelImage().getModel()){

            protected RenderedImage createImage(int level) {
                return new CellGridOpImage(valueProvider, (RasterDataNode)band, this.getModel(), ResolutionLevel.create((MultiLevelModel)this.getModel(), (int)level));
            }
        };
    }

    private void addBands(Product product) {
        String formatName = this.getDataFormat().getName();
        Family<BandDescriptor> descriptors = Dddb.getInstance().getBandDescriptors(formatName);
        if (descriptors != null) {
            for (BandDescriptor descriptor : descriptors.asList()) {
                this.addBand(product, descriptor, this.getCellType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Dffg> getGridList() {
        List<Dffg> result = this.gridList;
        if (result == null) {
            DffgFile dffgFile = this;
            synchronized (dffgFile) {
                result = this.gridList;
                if (result == null) {
                    try {
                        this.gridList = result = this.createGridList(this.dataBlockSequence, this.compoundSequence);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Cannot create zone list.", e);
                    }
                }
            }
        }
        return result;
    }

    private List<Dffg> createGridList(String dataBlockSequence, String compoundSequence) throws IOException {
        SequenceData zoneSequenceData = this.getDataBlock().getSequence(dataBlockSequence);
        if (zoneSequenceData == null) {
            throw new IllegalStateException(MessageFormat.format("SMOS File ''{0}'': Missing zone data.", this.getDataFile().getPath()));
        }
        ArrayList<Dffg> gridList = new ArrayList<Dffg>(zoneSequenceData.getElementCount());
        for (int i = 0; i < zoneSequenceData.getElementCount(); ++i) {
            CompoundData zoneCompoundData = zoneSequenceData.getCompound(i);
            double minLat = zoneCompoundData.getDouble(MIN_LAT_NAME);
            double maxLat = zoneCompoundData.getDouble(MAX_LAT_NAME);
            double minLon = zoneCompoundData.getDouble(MIN_LON_NAME);
            double maxLon = zoneCompoundData.getDouble(MAX_LON_NAME);
            double deltaLat = zoneCompoundData.getDouble(DELTA_LAT_NAME);
            SequenceData sequenceData = zoneCompoundData.getSequence(compoundSequence);
            Dffg grid = new Dffg(minLat, maxLat, minLon, maxLon, deltaLat, sequenceData);
            SequenceData rowSequenceData = zoneCompoundData.getSequence(LIST_OF_ROW_STRUCT_DATA_NAME);
            for (int p = 0; p < rowSequenceData.getElementCount(); ++p) {
                CompoundData rowCompoundData = rowSequenceData.getCompound(p);
                int lonCount = rowCompoundData.getInt(LON_COUNT_NAME);
                double deltaLon = rowCompoundData.getDouble(DELTA_LON_NAME);
                int cumulatedLonCount = rowCompoundData.getInt(CUMULATED_LON_COUNT_NAME);
                grid.setRow(p, lonCount, deltaLon, cumulatedLonCount);
            }
            gridList.add(grid);
        }
        return Collections.unmodifiableList(gridList);
    }

    private int getGridIndex(long cellIndex, int zoneIndex) {
        return (int)(cellIndex - (long)zoneIndex * this.zoneIndexMultiplier);
    }

    private int getZoneIndex(long cellIndex) {
        return (int)(cellIndex / this.zoneIndexMultiplier);
    }

    final class CellValueProviderImpl
    implements CellValueProvider {
        private final int memberIndex;

        CellValueProviderImpl(int memberIndex) {
            this.memberIndex = memberIndex;
        }

        @Override
        public final Area getArea() {
            return DffgFile.this.getArea();
        }

        @Override
        public final long getCellIndex(double lon, double lat) {
            return DffgFile.this.getCellIndex(lon, lat);
        }

        @Override
        public final byte getValue(long cellIndex, byte noDataValue) {
            int zoneIndex = DffgFile.this.getZoneIndex(cellIndex);
            int gridIndex = DffgFile.this.getGridIndex(cellIndex, zoneIndex);
            try {
                return DffgFile.this.getGridList().get(zoneIndex).getSequenceData().getCompound(gridIndex).getByte(this.memberIndex);
            }
            catch (IOException e) {
                return noDataValue;
            }
        }

        @Override
        public final short getValue(long cellIndex, short noDataValue) {
            int zoneIndex = DffgFile.this.getZoneIndex(cellIndex);
            int gridIndex = DffgFile.this.getGridIndex(cellIndex, zoneIndex);
            try {
                return DffgFile.this.getGridList().get(zoneIndex).getSequenceData().getCompound(gridIndex).getShort(this.memberIndex);
            }
            catch (IOException e) {
                return noDataValue;
            }
        }

        @Override
        public final int getValue(long cellIndex, int noDataValue) {
            int zoneIndex = DffgFile.this.getZoneIndex(cellIndex);
            int gridIndex = DffgFile.this.getGridIndex(cellIndex, zoneIndex);
            try {
                return DffgFile.this.getGridList().get(zoneIndex).getSequenceData().getCompound(gridIndex).getInt(this.memberIndex);
            }
            catch (IOException e) {
                return noDataValue;
            }
        }

        @Override
        public final float getValue(long cellIndex, float noDataValue) {
            int zoneIndex = DffgFile.this.getZoneIndex(cellIndex);
            int gridIndex = DffgFile.this.getGridIndex(cellIndex, zoneIndex);
            try {
                return DffgFile.this.getGridList().get(zoneIndex).getSequenceData().getCompound(gridIndex).getFloat(this.memberIndex);
            }
            catch (IOException e) {
                return noDataValue;
            }
        }

        @Override
        public int getSnapshotId() {
            return -1;
        }

        @Override
        public void setSnapshotId(int snapshotId) {
        }
    }
}

