/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dffg;

import com.bc.ceres.binio.SequenceData;

class Dffg {
    private final double maxLon;
    private final double minLon;
    private final double maxLat;
    private final double minLat;
    private final double latDelta;
    private final int[] columnCounts;
    private final double[] lonDeltas;
    private final int[] cumulatedColumnCounts;
    private final SequenceData sequenceData;

    Dffg(double minLat, double maxLat, double minLon, double maxLon, double latDelta, SequenceData sequenceData) {
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.latDelta = latDelta;
        this.sequenceData = sequenceData;
        int rowCount = (int)Math.round((maxLat - minLat) / latDelta);
        this.columnCounts = new int[rowCount];
        this.lonDeltas = new double[rowCount];
        this.cumulatedColumnCounts = new int[rowCount];
    }

    int getIndex(double lon, double lat) {
        if (lon < 0.0) {
            lon += 360.0;
        }
        if (lon >= this.minLon && lon < this.maxLon && lat > this.minLat && lat <= this.maxLat) {
            int rowIndex = this.getRowIndex(lat);
            int columnIndex = this.getColumnIndex(lon, rowIndex);
            return this.cumulatedColumnCounts[rowIndex] + columnIndex;
        }
        return -1;
    }

    SequenceData getSequenceData() {
        return this.sequenceData;
    }

    void setRow(int rowIndex, int columnCount, double deltaLon, int cumulatedColumnCount) {
        this.columnCounts[rowIndex] = columnCount;
        this.lonDeltas[rowIndex] = deltaLon;
        this.cumulatedColumnCounts[rowIndex] = cumulatedColumnCount;
    }

    private int getRowIndex(double lat) {
        return (int)Math.floor((this.maxLat - lat) / this.latDelta);
    }

    private int getColumnIndex(double lon, int rowIndex) {
        return (int)Math.floor((lon - this.minLon) / this.lonDeltas[rowIndex]);
    }
}

