/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import java.awt.Color;

class TokenParser {
    private static final String WILDCARD = "*";

    TokenParser() {
    }

    static String parseString(String token, String defaultValue) {
        String trimmedToken = token.trim();
        if (TokenParser.isWildcard(trimmedToken)) {
            return defaultValue;
        }
        return trimmedToken;
    }

    static String parseString(String token) {
        return token.trim();
    }

    static int parseInt(String token, int defaultValue) {
        String trimmedToken = token.trim();
        if (TokenParser.isWildcard(trimmedToken)) {
            return defaultValue;
        }
        return Integer.parseInt(trimmedToken);
    }

    private static boolean isWildcard(String trimmedToken) {
        return trimmedToken.equals(WILDCARD);
    }

    public static int parseHex(String token, int defaultValue) {
        String trimmedToken = token.trim();
        if (TokenParser.isWildcard(trimmedToken)) {
            return defaultValue;
        }
        return Integer.parseInt(trimmedToken, 16);
    }

    public static double parseDouble(String token, double defaultValue) {
        String trimmedToken = token.trim();
        if (TokenParser.isWildcard(trimmedToken)) {
            return defaultValue;
        }
        return Double.parseDouble(trimmedToken);
    }

    public static Color parseColor(String token, Color defaultValue) {
        String trimmedToken = token.trim();
        if (TokenParser.isWildcard(trimmedToken)) {
            return defaultValue;
        }
        return new Color(Integer.parseInt(trimmedToken, 16));
    }

    public static boolean parseBoolean(String token, boolean defaultValue) {
        String trimmedToken = token.trim();
        if (TokenParser.isWildcard(trimmedToken)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(trimmedToken);
    }
}

