/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.esa.snap.core.util.StringUtils;

class ResourceHandler {
    static final String SMOS_DDDB_DIR_PROPERTY_NAME = "org.esa.smos.dddbDir";

    ResourceHandler() {
    }

    static String buildPath(String identifier, String root, String appendix) {
        String fc = identifier.substring(12, 16);
        String sd = identifier.substring(16, 22);
        return root + "/" + fc + "/" + sd + "/" + identifier + appendix;
    }

    InputStream getResourceStream(String path) throws FileNotFoundException {
        File resourceFile;
        String dddbDirFromProperty = System.getProperty(SMOS_DDDB_DIR_PROPERTY_NAME);
        if (StringUtils.isNotNullAndNotEmpty((String)dddbDirFromProperty) && (resourceFile = new File(dddbDirFromProperty, path)).isFile()) {
            return new FileInputStream(resourceFile);
        }
        return this.getClass().getResourceAsStream(path);
    }

    URL getResourceUrl(String path) throws MalformedURLException {
        File resourceFile;
        String dddbDirFromProperty = System.getProperty(SMOS_DDDB_DIR_PROPERTY_NAME);
        if (StringUtils.isNotNullAndNotEmpty((String)dddbDirFromProperty) && (resourceFile = new File(dddbDirFromProperty, path)).isFile()) {
            return resourceFile.toURI().toURL();
        }
        return this.getClass().getResource(path);
    }

    Properties getResourceAsProperties(String path) throws IOException {
        Properties properties = new Properties();
        InputStream is = this.getResourceStream(path);
        if (is != null) {
            properties.load(is);
            is.close();
        }
        return properties;
    }
}

