/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.dddb.FlagDescriptorCombined;

public class FlagDescriptorsCombined
implements Family<FlagDescriptor> {
    private final List<FlagDescriptorCombined> descriptorList;
    private final Map<String, FlagDescriptorCombined> descriptorMap;

    FlagDescriptorsCombined(List<String[]> recordList) {
        this.descriptorList = new ArrayList<FlagDescriptorCombined>(recordList.size());
        this.descriptorMap = new HashMap<String, FlagDescriptorCombined>(recordList.size());
        for (String[] tokens : recordList) {
            FlagDescriptorCombined record = new FlagDescriptorCombined(tokens);
            this.descriptorList.add(record);
            this.descriptorMap.put(record.getFlagName(), record);
        }
    }

    @Override
    public final List<FlagDescriptor> asList() {
        return Collections.unmodifiableList(this.descriptorList);
    }

    @Override
    public final FlagDescriptor getMember(String flagName) {
        return this.descriptorMap.get(flagName);
    }
}

