/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.dddb.FlagDescriptorImpl;

class FlagDescriptors
implements Family<FlagDescriptor> {
    private final List<FlagDescriptor> descriptorList;
    private final Map<String, FlagDescriptor> descriptorMap;

    FlagDescriptors(List<String[]> recordList) {
        this.descriptorList = new ArrayList<FlagDescriptor>(recordList.size());
        this.descriptorMap = new HashMap<String, FlagDescriptor>(recordList.size());
        for (String[] tokens : recordList) {
            FlagDescriptorImpl record = new FlagDescriptorImpl(tokens);
            this.descriptorList.add(record);
            this.descriptorMap.put(record.getFlagName(), record);
        }
    }

    @Override
    public final List<FlagDescriptor> asList() {
        return Collections.unmodifiableList(this.descriptorList);
    }

    @Override
    public final FlagDescriptor getMember(String flagName) {
        return this.descriptorMap.get(flagName);
    }
}

