/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import java.awt.Color;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.dddb.TokenParser;

public class FlagDescriptorImpl
implements FlagDescriptor {
    private final boolean visible;
    private final String flagName;
    private final int mask;
    private final Color color;
    private final String combinedDescriptor;
    private final String description;

    public FlagDescriptorImpl(String[] tokens) {
        this.visible = TokenParser.parseBoolean(tokens[0], false);
        this.flagName = TokenParser.parseString(tokens[1]);
        this.mask = TokenParser.parseHex(tokens[2], 0);
        this.color = TokenParser.parseColor(tokens[3], null);
        this.combinedDescriptor = TokenParser.parseString(tokens[4], "");
        this.description = TokenParser.parseString(tokens[5], "");
    }

    @Override
    public final String getFlagName() {
        return this.flagName;
    }

    @Override
    public final int getMask() {
        return this.mask;
    }

    @Override
    public final boolean isVisible() {
        return this.visible;
    }

    @Override
    public final Color getColor() {
        return this.color;
    }

    @Override
    public String getCombinedDescriptor() {
        return this.combinedDescriptor;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public boolean evaluate(int flags) {
        return (this.mask & flags) == this.mask;
    }
}

