/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.binx.BinX;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.BandDescriptors;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.dddb.FlagDescriptors;
import org.esa.smos.dataio.smos.dddb.FlagDescriptorsCombined;
import org.esa.smos.dataio.smos.dddb.MemberDescriptor;
import org.esa.smos.dataio.smos.dddb.MemberDescriptors;
import org.esa.smos.dataio.smos.dddb.ResourceHandler;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.CsvReader;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.util.IteratorIterable;

public class Dddb {
    private static final String TAG_DATABLOCK_SCHEMA = "Datablock_Schema";
    private static final String SCHEMA_NAMING_CONVENTION = "DBL_\\w{2}_\\w{4}_\\w{10}_\\d{4}";
    private final Charset charset = Charset.forName("UTF-8");
    private final char[] separators = new char[]{'|'};
    private final ResourceHandler resourceHandler;
    private final ConcurrentMap<String, DataFormat> dataFormatMap = new ConcurrentHashMap<String, DataFormat>(17);
    private final ConcurrentMap<String, BandDescriptors> bandDescriptorMap = new ConcurrentHashMap<String, BandDescriptors>(17);
    private final ConcurrentMap<String, FlagDescriptors> flagDescriptorMap = new ConcurrentHashMap<String, FlagDescriptors>(17);
    private final ConcurrentMap<String, FlagDescriptorsCombined> flagDescriptorCombinedMap = new ConcurrentHashMap<String, FlagDescriptorsCombined>(8);

    private Dddb() {
        this.resourceHandler = new ResourceHandler();
    }

    public static Dddb getInstance() {
        return Holder.INSTANCE;
    }

    static String findOriginalName(Properties mappingProperties, String searchName) {
        Set<Map.Entry<Object, Object>> entries = mappingProperties.entrySet();
        for (Map.Entry<Object, Object> next : entries) {
            if (!searchName.equalsIgnoreCase((String)next.getValue())) continue;
            return (String)next.getKey();
        }
        return null;
    }

    static Map<String, BandDescriptor> extractUniqueMembers(List<BandDescriptor> bandDescriptorsList) {
        HashMap<String, BandDescriptor> uniqueMemberMap = new HashMap<String, BandDescriptor>();
        for (BandDescriptor bandDescriptor : bandDescriptorsList) {
            String memberName = bandDescriptor.getMemberName();
            if (uniqueMemberMap.containsKey(memberName)) continue;
            uniqueMemberMap.put(memberName, bandDescriptor);
        }
        return uniqueMemberMap;
    }

    DataFormat getDataFormat(String formatName) {
        if (!this.dataFormatMap.containsKey(formatName)) {
            try {
                URL url = this.getSchemaResource(formatName);
                if (url != null) {
                    DataFormat format = this.createBinX(formatName).readDataFormat(url.toURI(), formatName);
                    format.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                    this.dataFormatMap.putIfAbsent(formatName, format);
                    return format;
                }
            }
            catch (Throwable e) {
                throw new IllegalStateException(MessageFormat.format("Schema resource ''{0}'': {1}", formatName, e.getMessage()));
            }
        }
        return (DataFormat)this.dataFormatMap.get(formatName);
    }

    public DataFormat getDataFormat(File hdrFile) throws IOException {
        String formatName = this.extractFormatName(hdrFile);
        return this.getDataFormat(formatName);
    }

    private String extractFormatName(File hdrFile) throws IOException {
        Document document;
        try {
            document = new SAXBuilder().build(hdrFile);
        }
        catch (JDOMException e) {
            throw new IOException(MessageFormat.format("File ''{0}'': Invalid document", hdrFile.getPath()), e);
        }
        Namespace namespace = document.getRootElement().getNamespace();
        if (namespace == null) {
            throw new IOException(MessageFormat.format("File ''{0}'': Missing namespace", hdrFile.getPath()));
        }
        IteratorIterable descendants = document.getDescendants();
        while (descendants.hasNext()) {
            Element e;
            Object o = descendants.next();
            if (!(o instanceof Element) || (e = (Element)o).getChildText(TAG_DATABLOCK_SCHEMA, namespace) == null) continue;
            return e.getChildText(TAG_DATABLOCK_SCHEMA, namespace).substring(0, 27);
        }
        throw new IOException(MessageFormat.format("File ''{0}'': Missing datablock schema.", hdrFile.getPath()));
    }

    public BandDescriptor findBandDescriptorForMember(String formatName, String memberName) {
        Family<BandDescriptor> descriptors = this.getBandDescriptors(formatName);
        if (descriptors != null) {
            for (BandDescriptor descriptor : descriptors.asList()) {
                if (!descriptor.getMemberName().equals(memberName)) continue;
                return descriptor;
            }
        }
        return null;
    }

    public Family<BandDescriptor> getBandDescriptors(String formatName) {
        if (!this.bandDescriptorMap.containsKey(formatName)) {
            InputStream inputStream = null;
            try {
                inputStream = this.getBandDescriptorResource(formatName);
                if (inputStream != null) {
                    BandDescriptors descriptors = this.readBandDescriptors(inputStream);
                    this.bandDescriptorMap.putIfAbsent(formatName, descriptors);
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException(MessageFormat.format("An error occurred while reading band descriptors for format name ''{0}''.", formatName));
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException descriptors) {}
                }
            }
        }
        return (Family)this.bandDescriptorMap.get(formatName);
    }

    public Family<FlagDescriptor> getFlagDescriptors(String identifier) {
        if (!this.flagDescriptorMap.containsKey(identifier)) {
            try (InputStream inputStream = this.getFlagDescriptorResource(identifier);){
                if (inputStream != null) {
                    FlagDescriptors descriptors = this.readFlagDescriptors(inputStream);
                    this.flagDescriptorMap.putIfAbsent(identifier, descriptors);
                }
            }
            catch (Throwable e) {
                throw new IllegalStateException(MessageFormat.format("An error occurred while reading flag descriptors for identifier ''{0}''.", identifier));
            }
        }
        return (Family)this.flagDescriptorMap.get(identifier);
    }

    public Family<FlagDescriptor> getCombinedFlagDescriptors(String identifier) {
        if (!this.flagDescriptorCombinedMap.containsKey(identifier)) {
            try (InputStream inputStream = this.getFlagDescriptorResource(identifier);){
                FlagDescriptorsCombined descriptors = this.readCombinedFlagDescriptors(inputStream);
                this.flagDescriptorCombinedMap.putIfAbsent(identifier, descriptors);
            }
            catch (Throwable e) {
                throw new IllegalStateException(MessageFormat.format("An error occurred while reading flag descriptors for identifier ''{0}''.", identifier));
            }
        }
        return (Family)this.flagDescriptorCombinedMap.get(identifier);
    }

    public Family<MemberDescriptor> getMemberDescriptors(File hdrFile) throws IOException {
        MemberDescriptors memberDescriptors = new MemberDescriptors();
        DataFormat dataFormat = this.getDataFormat(hdrFile);
        CompoundType type = dataFormat.getType();
        Family<BandDescriptor> bandDescriptors = this.getBandDescriptors(dataFormat.getName());
        Map<String, BandDescriptor> uniqueMemberMap = Dddb.extractUniqueMembers(bandDescriptors.asList());
        this.extractMembers(type, memberDescriptors);
        List<MemberDescriptor> memberDescriptorList = memberDescriptors.asList();
        ArrayList<MemberDescriptor> toRemoveList = new ArrayList<MemberDescriptor>();
        for (MemberDescriptor memberDescriptor : memberDescriptorList) {
            if (uniqueMemberMap.containsKey(memberDescriptor.getName())) continue;
            toRemoveList.add(memberDescriptor);
        }
        for (MemberDescriptor toRemove : toRemoveList) {
            memberDescriptors.remove(toRemove.getName());
        }
        String formatName = this.extractFormatName(hdrFile);
        Properties mappingProperties = this.getMappingProperties(formatName);
        for (MemberDescriptor memberDescriptor : memberDescriptorList) {
            String originalName;
            String memberDescriptorName = memberDescriptor.getName();
            memberDescriptor.setBinXName(memberDescriptorName);
            if (mappingProperties != null && (originalName = Dddb.findOriginalName(mappingProperties, memberDescriptorName)) != null) {
                memberDescriptor.setName(originalName);
            }
            BandDescriptor bandDescriptor = uniqueMemberMap.get(memberDescriptorName);
            memberDescriptor.setGridPointData(bandDescriptor.isGridPointData());
            memberDescriptor.setDimensionNames(bandDescriptor.getDimensionNames());
            Family<FlagDescriptor> flagDescriptors = bandDescriptor.getFlagDescriptors();
            if (flagDescriptors != null) {
                List<FlagDescriptor> flagDescriptorsList = flagDescriptors.asList();
                int size = flagDescriptorsList.size();
                short[] flagMasks = new short[size];
                String[] flagMeanings = new String[size];
                int i = 0;
                for (FlagDescriptor flagDescriptor : flagDescriptorsList) {
                    flagMasks[i] = (short)flagDescriptor.getMask();
                    flagMeanings[i] = flagDescriptor.getFlagName();
                    ++i;
                }
                memberDescriptor.setFlagMasks(flagMasks);
                memberDescriptor.setFlagValues(flagMasks);
                memberDescriptor.setFlagMeanings(StringUtils.arrayToString((Object)flagMeanings, (String)" "));
            }
            memberDescriptor.setUnit(bandDescriptor.getUnit());
            memberDescriptor.setFillValue((float)bandDescriptor.getFillValue());
            memberDescriptor.setScalingFactor((float)bandDescriptor.getScalingFactor());
            memberDescriptor.setScalingOffset((float)bandDescriptor.getScalingOffset());
        }
        return memberDescriptors;
    }

    public String getEEVariableName(String variableName, String schema) throws IOException {
        String originalName;
        Properties mappingProperties = this.getMappingProperties(schema);
        if (mappingProperties != null && (originalName = Dddb.findOriginalName(mappingProperties, variableName)) != null) {
            return originalName;
        }
        return variableName;
    }

    private void extractMembers(CompoundType type, MemberDescriptors memberDescriptors) {
        CompoundMember[] members;
        for (CompoundMember member : members = type.getMembers()) {
            Type subType = member.getType();
            String memberName = member.getName();
            if (subType.isSimpleType()) {
                MemberDescriptor memberDescriptor = new MemberDescriptor();
                memberDescriptor.setName(memberName);
                memberDescriptor.setDataTypeName(subType.getName());
                int memberIndex = type.getMemberIndex(memberName);
                memberDescriptor.setMemberIndex(memberIndex);
                memberDescriptors.add(memberDescriptor);
                continue;
            }
            if (subType.isCompoundType()) {
                this.extractMembers((CompoundType)subType, memberDescriptors);
                continue;
            }
            if (!subType.isSequenceType()) continue;
            SequenceType sequenceType = (SequenceType)subType;
            Type elementType = sequenceType.getElementType();
            if (elementType.isSimpleType()) {
                MemberDescriptor memberDescriptor = new MemberDescriptor();
                memberDescriptor.setName(memberName);
                memberDescriptor.setDataTypeName(elementType.getName());
                int memberIndex = type.getMemberIndex(memberName);
                memberDescriptor.setMemberIndex(memberIndex);
                memberDescriptors.add(memberDescriptor);
                continue;
            }
            if (!elementType.isCompoundType()) continue;
            this.extractMembers((CompoundType)elementType, memberDescriptors);
        }
    }

    private URL getSchemaResource(String schemaName) throws MalformedURLException {
        if (schemaName == null || !schemaName.matches(SCHEMA_NAMING_CONVENTION)) {
            return null;
        }
        return this.resourceHandler.getResourceUrl(ResourceHandler.buildPath(schemaName, "schemas", ".binXschema.xml"));
    }

    private BinX createBinX(String name) {
        BinX binX = new BinX();
        binX.setSingleDatasetStructInlined(true);
        binX.setArrayVariableInlined(true);
        try {
            Properties mappingProperties = this.getMappingProperties(name);
            if (mappingProperties != null) {
                binX.setVarNameMappings(mappingProperties);
            }
            if (name.matches("DBL_\\w{2}_\\w{4}_MIR_SC\\w{2}1C_\\d{4}")) {
                binX.setTypeMembersInlined(this.resourceHandler.getResourceAsProperties("structs_MIR_SCXX1C.properties"));
            } else if (name.contains("MIR_OSDAP2")) {
                binX.setTypeMembersInlined(this.resourceHandler.getResourceAsProperties("structs_MIR_OSDAP2.properties"));
            } else if (name.contains("MIR_OSUDP2")) {
                binX.setTypeMembersInlined(this.resourceHandler.getResourceAsProperties("structs_MIR_OSUDP2.properties"));
            } else if (name.contains("MIR_SMDAP2")) {
                binX.setTypeMembersInlined(this.resourceHandler.getResourceAsProperties("structs_MIR_SMDAP2.properties"));
            } else if (name.contains("MIR_SMUDP2")) {
                binX.setTypeMembersInlined(this.resourceHandler.getResourceAsProperties("structs_MIR_SMUDP2.properties"));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return binX;
    }

    private Properties getMappingProperties(String name) throws IOException {
        Properties mappingProperties = null;
        if (name.contains("AUX_ECMWF_")) {
            mappingProperties = this.resourceHandler.getResourceAsProperties("mappings_AUX_ECMWF_.properties");
        } else if (name.matches("DBL_\\w{2}_\\w{4}_MIR_\\w{4}1C_\\d{4}")) {
            mappingProperties = this.resourceHandler.getResourceAsProperties("mappings_MIR_XXXX1C.properties");
        } else if (name.contains("MIR_OSDAP2")) {
            mappingProperties = this.resourceHandler.getResourceAsProperties("mappings_MIR_OSDAP2.properties");
        } else if (name.contains("MIR_OSUDP2")) {
            mappingProperties = this.resourceHandler.getResourceAsProperties("mappings_MIR_OSUDP2.properties");
        } else if (name.contains("MIR_SMDAP2")) {
            mappingProperties = this.resourceHandler.getResourceAsProperties("mappings_MIR_SMDAP2.properties");
        } else if (name.contains("MIR_SMUDP2")) {
            mappingProperties = this.resourceHandler.getResourceAsProperties("mappings_MIR_SMUDP2.properties");
        }
        return mappingProperties;
    }

    private BandDescriptors readBandDescriptors(InputStream inputStream) throws IOException {
        CsvReader reader = new CsvReader((Reader)new InputStreamReader(inputStream, this.charset), this.separators, true, "#");
        List recordList = reader.readStringRecords();
        return new BandDescriptors(recordList, this);
    }

    private FlagDescriptors readFlagDescriptors(InputStream inputStream) throws IOException {
        CsvReader reader = new CsvReader((Reader)new InputStreamReader(inputStream, this.charset), this.separators, true, "#");
        List recordList = reader.readStringRecords();
        return new FlagDescriptors(recordList);
    }

    private FlagDescriptorsCombined readCombinedFlagDescriptors(InputStream inputStream) throws IOException {
        CsvReader reader = new CsvReader((Reader)new InputStreamReader(inputStream, this.charset), this.separators, true, "#");
        List recordList = reader.readStringRecords();
        return new FlagDescriptorsCombined(recordList);
    }

    private InputStream getBandDescriptorResource(String formatName) throws FileNotFoundException {
        if ("BUFR".equals(formatName)) {
            return this.resourceHandler.getResourceStream("bands/BUFR/BUFR.csv");
        }
        if (formatName == null || !formatName.matches(SCHEMA_NAMING_CONVENTION)) {
            return null;
        }
        return this.resourceHandler.getResourceStream(ResourceHandler.buildPath(formatName, "bands", ".csv"));
    }

    private InputStream getFlagDescriptorResource(String identifier) throws FileNotFoundException {
        if ("BUFR_flags".equals(identifier)) {
            return this.resourceHandler.getResourceStream("flags/BUFR/BUFR_flags.csv");
        }
        if (identifier == null || !identifier.matches("DBL_\\w{2}_\\w{4}_\\w{10}_\\d{4}_.*")) {
            return null;
        }
        return this.resourceHandler.getResourceStream(ResourceHandler.buildPath(identifier, "flags", ".csv"));
    }

    private static class Holder {
        private static final Dddb INSTANCE = new Dddb();

        private Holder() {
        }
    }
}

