/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.BandDescriptorImpl;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;

class BandDescriptors
implements Family<BandDescriptor> {
    private final List<BandDescriptor> descriptorList;
    private final Map<String, BandDescriptor> descriptorMap;

    BandDescriptors(List<String[]> recordList, Dddb dddb) {
        this.descriptorList = new ArrayList<BandDescriptor>(recordList.size());
        this.descriptorMap = new HashMap<String, BandDescriptor>(recordList.size());
        for (String[] tokens : recordList) {
            BandDescriptorImpl bandDescriptor = new BandDescriptorImpl(tokens, dddb);
            this.descriptorList.add(bandDescriptor);
            this.descriptorMap.put(bandDescriptor.getBandName(), bandDescriptor);
        }
    }

    @Override
    public final List<BandDescriptor> asList() {
        return Collections.unmodifiableList(this.descriptorList);
    }

    @Override
    public final BandDescriptor getMember(String bandName) {
        return this.descriptorMap.get(bandName);
    }
}

