/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.dddb;

import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.dddb.TokenParser;

class BandDescriptorImpl
implements BandDescriptor {
    private final boolean visible;
    private final String bandName;
    private final String memberName;
    private final int polarization;
    private final int sampleModel;
    private final double scalingOffset;
    private final double scalingFactor;
    private double typicalMin;
    private double typicalMax;
    private final boolean cyclic;
    private final double fillValue;
    private final String validPixelExpression;
    private final String unit;
    private final String description;
    private final String flagCodingName;
    private final Family<FlagDescriptor> flagDescriptors;
    private final boolean gridPointData;
    private final String dimensionNames;
    private String ancilliaryBandName;

    BandDescriptorImpl(String[] tokens, Dddb dddb) {
        this.visible = TokenParser.parseBoolean(tokens[0], true);
        this.bandName = TokenParser.parseString(tokens[1]);
        this.memberName = TokenParser.parseString(tokens[2], this.bandName);
        this.polarization = TokenParser.parseInt(tokens[3], -1);
        this.sampleModel = TokenParser.parseInt(tokens[4], 0);
        this.scalingOffset = TokenParser.parseDouble(tokens[5], 0.0);
        this.scalingFactor = TokenParser.parseDouble(tokens[6], 1.0);
        this.typicalMin = TokenParser.parseDouble(tokens[7], Double.NEGATIVE_INFINITY);
        this.typicalMax = TokenParser.parseDouble(tokens[8], Double.POSITIVE_INFINITY);
        this.cyclic = TokenParser.parseBoolean(tokens[9], false);
        this.fillValue = TokenParser.parseDouble(tokens[10], Double.NaN);
        this.validPixelExpression = TokenParser.parseString(tokens[11], "").replaceAll("x", this.bandName);
        this.unit = TokenParser.parseString(tokens[12], "");
        this.description = TokenParser.parseString(tokens[13], "");
        this.flagCodingName = TokenParser.parseString(tokens[14], "");
        this.flagDescriptors = this.getFlagDescriptors(tokens[15], dddb);
        if (tokens.length > 16) {
            this.ancilliaryBandName = TokenParser.parseString(tokens[16], "");
        }
        if (tokens.length > 18) {
            this.gridPointData = TokenParser.parseBoolean(tokens[17], true);
            this.dimensionNames = TokenParser.parseString(tokens[18], null);
        } else {
            this.gridPointData = true;
            this.dimensionNames = null;
        }
    }

    private Family<FlagDescriptor> getFlagDescriptors(String token, Dddb dddb) {
        if (this.flagCodingName.isEmpty()) {
            return null;
        }
        return dddb.getFlagDescriptors(TokenParser.parseString(token));
    }

    @Override
    public final String getBandName() {
        return this.bandName;
    }

    @Override
    public final String getMemberName() {
        return this.memberName;
    }

    @Override
    public int getPolarization() {
        return this.polarization;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public final int getSampleModel() {
        return this.sampleModel;
    }

    @Override
    public final double getScalingOffset() {
        return this.scalingOffset;
    }

    @Override
    public final double getScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public final boolean hasTypicalMin() {
        return !Double.isInfinite(this.typicalMin);
    }

    @Override
    public final boolean hasTypicalMax() {
        return !Double.isInfinite(this.typicalMax);
    }

    @Override
    public final boolean hasFillValue() {
        return !Double.isNaN(this.fillValue);
    }

    @Override
    public final double getTypicalMin() {
        return this.typicalMin;
    }

    @Override
    public void setTypicalMin(double min) {
        this.typicalMin = min;
    }

    @Override
    public final double getTypicalMax() {
        return this.typicalMax;
    }

    @Override
    public void setTypicalMax(double max) {
        this.typicalMax = max;
    }

    @Override
    public final double getFillValue() {
        return this.fillValue;
    }

    @Override
    public final String getValidPixelExpression() {
        return this.validPixelExpression;
    }

    @Override
    public final String getUnit() {
        return this.unit;
    }

    @Override
    public final boolean isCyclic() {
        return this.cyclic;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final String getFlagCodingName() {
        return this.flagCodingName;
    }

    @Override
    public final Family<FlagDescriptor> getFlagDescriptors() {
        return this.flagDescriptors;
    }

    @Override
    public boolean isGridPointData() {
        return this.gridPointData;
    }

    @Override
    public String getDimensionNames() {
        return this.dimensionNames;
    }

    @Override
    public String getAncilliaryBandName() {
        return this.ancilliaryBandName;
    }
}

