/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.bufr;

class ValueDecoder {
    private final double scaleFactor;
    private final double offset;
    private final Number missingValue;

    ValueDecoder(double scaleFactor, double offset, Number missingValue) {
        this.scaleFactor = scaleFactor;
        this.offset = offset;
        this.missingValue = missingValue;
    }

    double decode(int value) {
        if (this.isValid(value)) {
            return this.scaleFactor * (double)value + this.offset;
        }
        return Double.NaN;
    }

    boolean isValid(int value) {
        return this.missingValue == null || value != this.missingValue.intValue();
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public double getOffset() {
        return this.offset;
    }

    public Number getMissingValue() {
        return this.missingValue;
    }
}

