/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.bufr;

import org.esa.smos.dataio.smos.bufr.ValueAccessor;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;

class ValueAccessors {
    ValueAccessors() {
    }

    static ValueAccessor get(String datasetName) {
        if (datasetName.equalsIgnoreCase("Azimuth_angle") || datasetName.equalsIgnoreCase("Faraday_rotational_angle") || datasetName.equalsIgnoreCase("Geometric_rotational_angle") || datasetName.equalsIgnoreCase("Incidence_angle") || datasetName.equalsIgnoreCase("Direct_sun_brightness_temperature")) {
            return new IntValueAccessor(datasetName);
        }
        if (datasetName.equalsIgnoreCase("Brightness_temperature_real_part") || datasetName.equalsIgnoreCase("Brightness_temperature_imaginary_part")) {
            return new UnsignedShortValueAccessor(datasetName);
        }
        if (datasetName.equalsIgnoreCase("Footprint_axis_1") || datasetName.equalsIgnoreCase("Footprint_axis_2") || datasetName.equalsIgnoreCase("Pixel_radiometric_accuracy") || datasetName.equalsIgnoreCase("Water_fraction") || datasetName.equalsIgnoreCase("SMOS_information_flag") || datasetName.equalsIgnoreCase("Number_of_grid_points") || datasetName.equalsIgnoreCase("Year") || datasetName.equalsIgnoreCase("Snapshot_accuracy") || datasetName.equalsIgnoreCase("Radiometric_accuracy_pure_polarisation") || datasetName.equalsIgnoreCase("Radiometric_accuracy_cross_polarisation")) {
            return new ShortValueAccessor(datasetName);
        }
        if (datasetName.equalsIgnoreCase("Polarisation") || datasetName.equalsIgnoreCase("Month") || datasetName.equalsIgnoreCase("Day") || datasetName.equalsIgnoreCase("Hour") || datasetName.equalsIgnoreCase("Minute") || datasetName.equalsIgnoreCase("Second") || datasetName.equalsIgnoreCase("Total_electron_count_per_square_metre")) {
            return new ByteValueAccessor(datasetName);
        }
        throw new IllegalStateException("unsupported dataset: " + datasetName);
    }

    private static abstract class AbstractValueAccessor
    implements ValueAccessor {
        protected final String datasetName;
        protected int gridPointId;
        protected int rawValue;

        protected AbstractValueAccessor(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public int getGridPointId() {
            return this.gridPointId;
        }

        @Override
        public int getRawValue() {
            return this.rawValue;
        }
    }

    static class ByteValueAccessor
    extends AbstractValueAccessor {
        ByteValueAccessor(String datasetName) {
            super(datasetName);
        }

        @Override
        public void read(StructureData snapshotData) {
            this.rawValue = snapshotData.getScalarByte(this.datasetName);
            this.gridPointId = snapshotData.getScalarInt("Grid_point_identifier");
        }
    }

    static class ShortValueAccessor
    extends AbstractValueAccessor {
        ShortValueAccessor(String datasetName) {
            super(datasetName);
        }

        @Override
        public void read(StructureData snapshotData) {
            this.rawValue = snapshotData.getScalarShort(this.datasetName);
            this.gridPointId = snapshotData.getScalarInt("Grid_point_identifier");
        }
    }

    static class UnsignedShortValueAccessor
    extends AbstractValueAccessor {
        UnsignedShortValueAccessor(String datasetName) {
            super(datasetName);
        }

        @Override
        public void read(StructureData snapshotData) {
            short shortRawValue = snapshotData.getScalarShort(this.datasetName);
            this.rawValue = DataType.unsignedShortToInt((short)shortRawValue);
            this.gridPointId = snapshotData.getScalarInt("Grid_point_identifier");
        }
    }

    static class IntValueAccessor
    extends AbstractValueAccessor {
        IntValueAccessor(String datasetName) {
            super(datasetName);
        }

        @Override
        public void read(StructureData snapshotData) {
            this.rawValue = snapshotData.getScalarInt(this.datasetName);
            this.gridPointId = snapshotData.getScalarInt("Grid_point_identifier");
        }
    }
}

