/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.bufr;

import java.io.File;
import java.util.Locale;
import org.esa.smos.SmosUtils;
import org.esa.smos.dataio.smos.bufr.SmosLightBufrReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;

public class SmosLightBufrReaderPlugIn
implements ProductReaderPlugIn {
    public DecodeQualification getDecodeQualification(Object input) {
        File file;
        if (input instanceof File) {
            file = (File)input;
        } else if (input instanceof String) {
            file = new File((String)input);
        } else {
            return DecodeQualification.UNABLE;
        }
        String fileName = file.getName();
        if (SmosUtils.isLightBufrType((String)fileName)) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return new Class[]{File.class, String.class};
    }

    public ProductReader createReaderInstance() {
        return new SmosLightBufrReader(this);
    }

    public String[] getFormatNames() {
        return new String[]{"SMOS Light-BUFR"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".bin", ".bin.bz2"};
    }

    public String getDescription(Locale locale) {
        return "SMOS Light-BUFR data products";
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

