/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.bufr;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.esa.smos.ObservationPointList;
import org.esa.smos.Point;
import org.esa.smos.PointList;
import org.esa.smos.dataio.smos.CellValueProvider;
import org.esa.smos.dataio.smos.DggUtils;
import org.esa.smos.dataio.smos.Grid;
import org.esa.smos.dataio.smos.GridPointBtDataset;
import org.esa.smos.dataio.smos.PolarisationModel;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.smos.dataio.smos.SmosReader;
import org.esa.smos.dataio.smos.SnapshotInfo;
import org.esa.smos.dataio.smos.bufr.BufrPolarisationModel;
import org.esa.smos.dataio.smos.bufr.BufrSupport;
import org.esa.smos.dataio.smos.bufr.LightBufrMultiLevelSource;
import org.esa.smos.dataio.smos.bufr.Observation;
import org.esa.smos.dataio.smos.bufr.SmosBufrFile;
import org.esa.smos.dataio.smos.bufr.SmosLightBufrReaderPlugIn;
import org.esa.smos.dataio.smos.bufr.SnapshotObservation;
import org.esa.smos.dataio.smos.bufr.ValueDecoder;
import org.esa.smos.dataio.smos.bufr.ValueDecoders;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dgg.SmosDgg;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.support.ReducedGaussianGrid;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.StringUtils;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Sequence;
import ucar.nc2.Variable;

public class SmosLightBufrReader
extends SmosReader {
    private HashMap<Integer, SnapshotObservation> snapshotMap;
    private HashMap<Integer, List<Observation>> gridPointMap;
    private Grid grid;
    private Area area;
    private ValueDecoders valueDecoders;
    private int gridPointMinIndex = -1;
    private int gridPointMaxIndex = -1;
    private LinkedList<Integer> snapshotIdList;
    private SnapshotInfo snapshotInfo;
    private BufrSupport bufrSupport = null;

    SmosLightBufrReader(SmosLightBufrReaderPlugIn smosLightBufrReaderPlugIn) {
        super(smosLightBufrReaderPlugIn);
    }

    @Override
    public GridPointBtDataset getBtData(int gridPointIndex) {
        if (gridPointIndex < 0) {
            return null;
        }
        List<Observation> gridPointData = this.gridPointMap.get(gridPointIndex);
        if (gridPointData == null) {
            return null;
        }
        int numData = this.bufrSupport.getNumDatasets();
        Class[] classes = new Class[numData];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = BufrSupport.isIntegerBandIndex(i) ? Integer.class : Double.class;
        }
        int numMeasurements = gridPointData.size();
        Number[][] data = new Number[numMeasurements][numData];
        for (int i = 0; i < numMeasurements; ++i) {
            Number[] currentMeasures = new Number[numData];
            Observation observation = gridPointData.get(i);
            for (int k = 0; k < numData; ++k) {
                currentMeasures[k] = classes[k] == Integer.class ? (Number)observation.data[k] : (Number)this.valueDecoders.dataDecoders[k].decode(observation.data[k]);
            }
            data[i] = currentMeasures;
        }
        GridPointBtDataset btDataset = new GridPointBtDataset(BufrSupport.getDatasetNameIndexMap(), classes, data);
        btDataset.setFlagBandIndex(10);
        btDataset.setIncidenceAngleBandIndex(3);
        btDataset.setRadiometricAccuracyBandIndex(2);
        btDataset.setBTValueRealBandIndex(0);
        btDataset.setBTValueImaginaryBandIndex(1);
        btDataset.setPolarisationFlagBandIndex(11);
        return btDataset;
    }

    @Override
    public boolean canSupplyGridPointBtData() {
        return true;
    }

    @Override
    public boolean canSupplyFullPolData() {
        return true;
    }

    @Override
    public int getGridPointIndex(int gridPointId) {
        if (gridPointId >= this.gridPointMinIndex && gridPointId <= this.gridPointMaxIndex && this.gridPointMap.containsKey(gridPointId)) {
            return gridPointId;
        }
        return -1;
    }

    @Override
    public int getGridPointId(int levelPixelX, int levelPixelY, int currentLevel) {
        return this.grid.getCellIndex(levelPixelX, levelPixelY, currentLevel);
    }

    @Override
    public String[] getRawDataTableNames() {
        return BufrSupport.RAW_DATA_NAMES;
    }

    @Override
    public FlagDescriptor[] getBtFlagDescriptors() {
        Family<FlagDescriptor> flagDescriptors = Dddb.getInstance().getFlagDescriptors("BUFR_flags");
        List<FlagDescriptor> flagDescriptorsList = flagDescriptors.asList();
        return flagDescriptorsList.toArray(new FlagDescriptor[0]);
    }

    @Override
    public PolarisationModel getPolarisationModel() {
        return new BufrPolarisationModel();
    }

    @Override
    public boolean canSupplySnapshotData() {
        return true;
    }

    @Override
    public boolean hasSnapshotInfo() {
        return true;
    }

    @Override
    public SnapshotInfo getSnapshotInfo() {
        if (this.snapshotInfo == null) {
            this.snapshotInfo = this.createSnapshotInfo();
        }
        return this.snapshotInfo;
    }

    @Override
    public Object[][] getSnapshotData(int snapshotIndex) {
        Integer snapshotId = this.snapshotIdList.get(snapshotIndex);
        SnapshotObservation snapshotObservation = this.snapshotMap.get(snapshotId);
        if (snapshotObservation == null) {
            return new Object[0][];
        }
        Object[][] snapshotData = new Object[BufrSupport.SNAPSHOT_DATA_NAMES.length][2];
        for (int i = 0; i < BufrSupport.SNAPSHOT_DATA_NAMES.length; ++i) {
            snapshotData[i][0] = BufrSupport.SNAPSHOT_DATA_NAMES[i];
            snapshotData[i][1] = i == 7 ? (Number)this.valueDecoders.tecDecoder.decode(snapshotObservation.data[i]) : (Number)(i == 9 ? (Number)this.valueDecoders.snapshotAccuracyDecoder.decode(snapshotObservation.data[i]) : (Number)(i == 10 ? (Number)this.valueDecoders.raPpDecoder.decode(snapshotObservation.data[i]) : (Number)(i == 11 ? (Number)this.valueDecoders.raCpDecoder.decode(snapshotObservation.data[i]) : (Number)snapshotObservation.data[i])));
        }
        return snapshotData;
    }

    private SnapshotInfo createSnapshotInfo() {
        Set<Integer> snapshotIds = this.snapshotMap.keySet();
        this.snapshotIdList = new LinkedList<Integer>(snapshotIds);
        Collections.sort(this.snapshotIdList);
        TreeSet<Long> all = new TreeSet<Long>();
        TreeSet<Long> x = new TreeSet<Long>();
        TreeSet<Long> y = new TreeSet<Long>();
        TreeSet<Long> xy = new TreeSet<Long>();
        TreeMap<Long, Integer> snapshotIndexMap = new TreeMap<Long, Integer>();
        TreeMap<Long, Rectangle2D> snapshotAreaMap = new TreeMap<Long, Rectangle2D>();
        PolarisationModel polarisationModel = this.getPolarisationModel();
        int index = 0;
        for (Integer snapshotId : this.snapshotIdList) {
            long snapshotIdLong = snapshotId.intValue();
            all.add(snapshotIdLong);
            snapshotIndexMap.put(snapshotIdLong, index);
            ++index;
            boolean hasXPolData = false;
            boolean hasYPolData = false;
            boolean hasXYPolData = false;
            SnapshotObservation snapshotObservation = this.snapshotMap.get(snapshotId);
            Rectangle2D snapshotRect = null;
            for (Observation observation : snapshotObservation.observations) {
                Rectangle2D gridRect = this.grid.getGridRect(observation.lon, observation.lat);
                if (snapshotRect == null) {
                    snapshotRect = gridRect;
                } else {
                    snapshotRect.add(gridRect);
                }
                int polarisationMode = observation.data[11];
                if (polarisationModel.is_X_Polarised(polarisationMode)) {
                    hasXPolData = true;
                }
                if (polarisationModel.is_Y_Polarised(polarisationMode)) {
                    hasYPolData = true;
                }
                if (!polarisationModel.is_XY1_Polarised(polarisationMode) && !polarisationModel.is_XY2_Polarised(polarisationMode)) continue;
                hasXYPolData = true;
            }
            if (hasXPolData) {
                x.add(snapshotIdLong);
            }
            if (hasYPolData) {
                y.add(snapshotIdLong);
            }
            if (hasXYPolData) {
                xy.add(snapshotIdLong);
            }
            snapshotAreaMap.put(snapshotIdLong, snapshotRect);
        }
        return new SnapshotInfo(snapshotIndexMap, all, x, y, xy, snapshotAreaMap, null);
    }

    protected Product readProductNodesImpl() throws IOException {
        File inputFile = this.getInputFile();
        this.bufrSupport = new BufrSupport();
        this.bufrSupport.open(inputFile.getPath());
        this.grid = new Grid((PlanetaryGrid)new ReducedGaussianGrid(512));
        Product product = ProductHelper.createProduct(inputFile, "SMOS.MIRAS.NRT_BUFR_Light");
        this.bufrSupport.extractMetaData(product);
        this.valueDecoders = this.bufrSupport.extractValueDecoders();
        this.readObservations();
        this.calculateArea();
        this.addBands(product);
        return product;
    }

    private void calculateArea() throws IOException {
        ArrayList<Point> points = new ArrayList<Point>();
        Set<Map.Entry<Integer, List<Observation>>> entries = this.gridPointMap.entrySet();
        for (Map.Entry<Integer, List<Observation>> next : entries) {
            List<Observation> value = next.getValue();
            Observation observation = value.get(0);
            Point point = new Point((double)observation.lon, (double)observation.lat);
            points.add(point);
        }
        this.area = DggUtils.computeArea((PointList)new ObservationPointList(points.toArray(new Point[points.size()])));
    }

    private void readObservations() throws IOException {
        this.snapshotMap = new HashMap();
        this.gridPointMap = new HashMap();
        this.gridPointMinIndex = Integer.MAX_VALUE;
        this.gridPointMaxIndex = Integer.MIN_VALUE;
        int messageCount = this.bufrSupport.getMessageCount();
        for (int i = 0; i < messageCount; ++i) {
            StructureDataIterator structureIterator = this.bufrSupport.getStructureIterator(i);
            while (structureIterator.hasNext()) {
                float lat;
                float lon;
                StructureData structureData = structureIterator.next();
                Observation observation = new Observation();
                observation.data[4] = structureData.getScalarInt("Azimuth_angle");
                short btReal = structureData.getScalarShort("Brightness_temperature_real_part");
                observation.data[0] = DataType.unsignedShortToInt((short)btReal);
                short btImag = structureData.getScalarShort("Brightness_temperature_imaginary_part");
                observation.data[1] = DataType.unsignedShortToInt((short)btImag);
                observation.data[5] = structureData.getScalarInt("Faraday_rotational_angle");
                observation.data[7] = structureData.getScalarShort("Footprint_axis_1");
                observation.data[8] = structureData.getScalarShort("Footprint_axis_2");
                observation.data[6] = structureData.getScalarInt("Geometric_rotational_angle");
                observation.data[3] = structureData.getScalarInt("Incidence_angle");
                observation.data[2] = structureData.getScalarShort("Pixel_radiometric_accuracy");
                observation.data[10] = structureData.getScalarShort("SMOS_information_flag");
                observation.data[9] = structureData.getScalarShort("Water_fraction");
                observation.data[11] = structureData.getScalarByte("Polarisation");
                int highAccuracyLon = structureData.getScalarInt("Longitude_high_accuracy");
                observation.lon = lon = (float)this.valueDecoders.lonDecoder.decode(highAccuracyLon);
                int highAccuracyLat = structureData.getScalarInt("Latitude_high_accuracy");
                observation.lat = lat = (float)this.valueDecoders.latDecoder.decode(highAccuracyLat);
                observation.cellIndex = this.grid.getCellIndex(lon, lat);
                this.addObservationToGridPoints(observation);
                this.traceGridPointIndexMinMax(this.grid.getCellIndex(lon, lat));
                int snapshot_id = structureData.getScalarInt("Snapshot_identifier");
                SnapshotObservation snapshotObservation = this.snapshotMap.get(snapshot_id);
                if (snapshotObservation == null) {
                    snapshotObservation = new SnapshotObservation(new int[BufrSupport.SNAPSHOT_DATA_NAMES.length]);
                    snapshotObservation.data[0] = structureData.getScalarShort("Number_of_grid_points");
                    snapshotObservation.data[1] = structureData.getScalarShort("Year");
                    snapshotObservation.data[2] = structureData.getScalarByte("Month");
                    snapshotObservation.data[3] = structureData.getScalarByte("Day");
                    snapshotObservation.data[4] = structureData.getScalarByte("Hour");
                    snapshotObservation.data[5] = structureData.getScalarByte("Minute");
                    snapshotObservation.data[6] = structureData.getScalarByte("Second");
                    snapshotObservation.data[7] = structureData.getScalarByte("Total_electron_count_per_square_metre");
                    snapshotObservation.data[8] = structureData.getScalarInt("Direct_sun_brightness_temperature");
                    snapshotObservation.data[9] = structureData.getScalarShort("Snapshot_accuracy");
                    snapshotObservation.data[10] = structureData.getScalarShort("Radiometric_accuracy_pure_polarisation");
                    snapshotObservation.data[11] = structureData.getScalarShort("Radiometric_accuracy_cross_polarisation");
                    Array snapshot_overall_quality = structureData.getArray("Snapshot_overall_quality");
                    snapshotObservation.data[12] = snapshot_overall_quality.getByte(0);
                    snapshotObservation.observations = new ArrayList();
                    this.snapshotMap.put(snapshot_id, snapshotObservation);
                }
                snapshotObservation.observations.add(observation);
            }
        }
    }

    private void traceGridPointIndexMinMax(int grid_point_index) {
        if (grid_point_index < this.gridPointMinIndex) {
            this.gridPointMinIndex = grid_point_index;
        }
        if (grid_point_index > this.gridPointMaxIndex) {
            this.gridPointMaxIndex = grid_point_index;
        }
    }

    private void addObservationToGridPoints(Observation observation) {
        List<Observation> gridPointObservations = this.gridPointMap.get(observation.cellIndex);
        if (gridPointObservations == null) {
            gridPointObservations = new ArrayList<Observation>();
            this.gridPointMap.put(observation.cellIndex, gridPointObservations);
        }
        gridPointObservations.add(observation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        SmosLightBufrReader smosLightBufrReader = this;
        synchronized (smosLightBufrReader) {
            MultiLevelImage image = destBand.getSourceImage();
            Raster data = image.getData(new Rectangle(destOffsetX, destOffsetY, destWidth, destHeight));
            data.getDataElements(destOffsetX, destOffsetY, destWidth, destHeight, destBuffer.getElems());
        }
    }

    public void close() throws IOException {
        super.close();
        this.gridPointMap.clear();
        this.snapshotMap.clear();
        this.snapshotInfo = null;
        if (this.bufrSupport != null) {
            this.bufrSupport.close();
            this.bufrSupport = null;
        }
    }

    private void addBands(Product product) throws IOException {
        SmosBufrFile smosBufrFile = this.bufrSupport.getSmosBufrFile();
        Sequence sequence = smosBufrFile.getObservationStructure();
        Family<BandDescriptor> descriptors = Dddb.getInstance().getBandDescriptors("BUFR");
        for (BandDescriptor descriptor : descriptors.asList()) {
            int dataType;
            Variable variable = sequence.findVariable(descriptor.getMemberName());
            if (variable.getDataType().isEnum()) {
                dataType = 20;
                this.addBand(product, variable, 20, descriptor);
                continue;
            }
            dataType = BufrSupport.getBufrDataType(variable);
            if (dataType == -1) continue;
            this.addBand(product, variable, dataType, descriptor);
        }
    }

    private void addBand(Product product, Variable variable, int dataType, BandDescriptor descriptor) throws IOException {
        CellValueProvider valueProvider;
        String validPixelExpression;
        Number missingValue;
        double scaleFactor;
        SmosBufrFile smosBufrFile;
        ValueDecoder valueDecoder;
        double offset;
        if (!descriptor.isVisible()) {
            return;
        }
        Band band = product.addBand(descriptor.getBandName(), dataType);
        Attribute units = variable.findAttribute("units");
        if (units != null) {
            band.setUnit(units.getStringValue());
        }
        if ((offset = (valueDecoder = (smosBufrFile = this.bufrSupport.getSmosBufrFile()).getValueDecoder(variable.getShortName())).getOffset()) != 0.0) {
            band.setScalingOffset(offset);
        }
        if ((scaleFactor = valueDecoder.getScaleFactor()) != 1.0) {
            band.setScalingFactor(scaleFactor);
        }
        if ((missingValue = valueDecoder.getMissingValue()) != null) {
            band.setNoDataValue(missingValue.doubleValue());
            band.setNoDataValueUsed(true);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)(validPixelExpression = descriptor.getValidPixelExpression()))) {
            band.setValidPixelExpression(validPixelExpression);
        }
        if (!descriptor.getDescription().isEmpty()) {
            band.setDescription(descriptor.getDescription());
        }
        if (descriptor.getFlagDescriptors() != null) {
            ProductHelper.addFlagsAndMasks(product, band, descriptor.getFlagCodingName(), descriptor.getFlagDescriptors());
        }
        Integer index = BufrSupport.getDatasetNameIndexMap().get(descriptor.getMemberName());
        if (descriptor.getFlagDescriptors() == null) {
            ValueDecoder scalingFactor = smosBufrFile.getValueDecoder(descriptor.getMemberName());
            valueProvider = new BufrCellValueProvider(descriptor.getPolarization(), index, scalingFactor);
        } else {
            valueProvider = new FlagCellValueProvider(descriptor.getPolarization(), index);
        }
        band.setSourceImage(this.createSourceImage(band, valueProvider));
        band.setImageInfo(ProductHelper.createImageInfo(band, descriptor));
    }

    private MultiLevelImage createSourceImage(Band band, CellValueProvider valueProvider) {
        return new DefaultMultiLevelImage(this.createMultiLevelSource(band, valueProvider));
    }

    private MultiLevelSource createMultiLevelSource(Band band, CellValueProvider valueProvider) {
        MultiLevelModel multiLevelModel = SmosDgg.getInstance().getMultiLevelImage().getModel();
        return new LightBufrMultiLevelSource(multiLevelModel, valueProvider, (RasterDataNode)band);
    }

    private class FlagCellValueProvider
    implements CellValueProvider {
        private final int dataindex;
        private final int polarisation;
        private int snapshotId;

        private FlagCellValueProvider(int polarisation, int dataIndex) {
            this.dataindex = dataIndex;
            this.polarisation = polarisation;
            this.snapshotId = -1;
        }

        @Override
        public Area getArea() {
            return SmosLightBufrReader.this.area;
        }

        @Override
        public long getCellIndex(double lon, double lat) {
            return SmosLightBufrReader.this.grid.getCellIndex(lon, lat);
        }

        @Override
        public byte getValue(long cellIndex, byte noDataValue) {
            return (byte)this.getData((int)cellIndex, noDataValue);
        }

        @Override
        public int getValue(long cellIndex, int noDataValue) {
            return this.getData((int)cellIndex, noDataValue);
        }

        @Override
        public short getValue(long cellIndex, short noDataValue) {
            return (short)this.getData((int)cellIndex, noDataValue);
        }

        @Override
        public float getValue(long cellIndex, float noDataValue) {
            throw new IllegalStateException("not implemented");
        }

        private int getData(int cellIndex, int noDataValue) {
            if (this.snapshotId < 0) {
                return this.getBrowseViewData(cellIndex, noDataValue);
            }
            return this.getSnapshotData(cellIndex, noDataValue);
        }

        private int getBrowseViewData(int cellIndex, int noDataValue) {
            List<Observation> cellObservations = SmosLightBufrReader.this.gridPointMap.get(cellIndex);
            if (cellObservations != null) {
                ValueDecoder incidenceAngleValueDecoder = SmosLightBufrReader.this.valueDecoders.incidenceAngleDecoder;
                boolean hasLower = false;
                boolean hasUpper = false;
                int combinedFlags = 0;
                for (Observation observation : cellObservations) {
                    double incidenceAngle;
                    int incidenceAngleInt;
                    if (this.polarisation != 4 && (observation.data[11] & 3) != this.polarisation && (this.polarisation & observation.data[11] & 2) == 0 || !incidenceAngleValueDecoder.isValid(incidenceAngleInt = observation.data[3]) || !((incidenceAngle = incidenceAngleValueDecoder.decode(incidenceAngleInt)) >= 37.5) || !(incidenceAngle <= 52.5)) continue;
                    combinedFlags |= observation.data[this.dataindex];
                    if (!hasLower) {
                        boolean bl = hasLower = incidenceAngle <= 42.5;
                    }
                    if (hasUpper) continue;
                    hasUpper = incidenceAngle > 42.5;
                }
                if (hasLower && hasUpper) {
                    return combinedFlags;
                }
            }
            return noDataValue;
        }

        private int getSnapshotData(int cellIndex, int noDataValue) {
            SnapshotObservation snapshotObservation = SmosLightBufrReader.this.snapshotMap.get(this.snapshotId);
            if (snapshotObservation != null) {
                for (Observation observation : snapshotObservation.observations) {
                    if (observation.cellIndex != cellIndex) continue;
                    return observation.data[this.dataindex];
                }
            }
            return noDataValue;
        }

        @Override
        public int getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public void setSnapshotId(int snapshotId) {
            this.snapshotId = snapshotId;
        }
    }

    private class BufrCellValueProvider
    implements CellValueProvider {
        private final int dataindex;
        private final int polarisation;
        private final ValueDecoder valueDecoder;
        private int snapshotId;

        private BufrCellValueProvider(int polarisation, int dataIndex, ValueDecoder valueDecoder) {
            this.dataindex = dataIndex;
            this.polarisation = polarisation;
            this.valueDecoder = valueDecoder;
            this.snapshotId = -1;
        }

        @Override
        public Area getArea() {
            return SmosLightBufrReader.this.area;
        }

        @Override
        public long getCellIndex(double lon, double lat) {
            return SmosLightBufrReader.this.grid.getCellIndex(lon, lat);
        }

        @Override
        public byte getValue(long cellIndex, byte noDataValue) {
            return (byte)this.getData((int)cellIndex, noDataValue);
        }

        @Override
        public int getValue(long cellIndex, int noDataValue) {
            return this.getData((int)cellIndex, noDataValue);
        }

        @Override
        public short getValue(long cellIndex, short noDataValue) {
            return (short)this.getData((int)cellIndex, noDataValue);
        }

        @Override
        public float getValue(long cellIndex, float noDataValue) {
            throw new IllegalStateException("not implemented");
        }

        private int getData(int cellIndex, int noDataValue) {
            if (this.snapshotId < 0) {
                return this.getBrowseViewData(cellIndex, noDataValue);
            }
            return this.getSnapshotData(cellIndex, noDataValue);
        }

        private int getSnapshotData(int cellIndex, int noDataValue) {
            SnapshotObservation snapshotObservation = SmosLightBufrReader.this.snapshotMap.get(this.snapshotId);
            if (snapshotObservation != null) {
                for (Observation observation : snapshotObservation.observations) {
                    if (observation.cellIndex != cellIndex || (observation.data[11] & this.polarisation) != this.polarisation) continue;
                    return observation.data[this.dataindex];
                }
            }
            return noDataValue;
        }

        private int getBrowseViewData(int cellIndex, int noDataValue) {
            List<Observation> cellObservations = SmosLightBufrReader.this.gridPointMap.get(cellIndex);
            if (cellObservations != null) {
                int count = 0;
                double sx = 0.0;
                double sy = 0.0;
                double sxx = 0.0;
                double sxy = 0.0;
                boolean hasLower = false;
                boolean hasUpper = false;
                ValueDecoder incidenceAngleValueDecoder = SmosLightBufrReader.this.valueDecoders.incidenceAngleDecoder;
                for (Observation observation : cellObservations) {
                    double incidenceAngle;
                    int incidenceAngleInt;
                    int value = observation.data[this.dataindex];
                    if (!this.valueDecoder.isValid(value) || this.polarisation != 4 && (observation.data[11] & 3) != this.polarisation && (this.polarisation & observation.data[11] & 2) == 0 || !incidenceAngleValueDecoder.isValid(incidenceAngleInt = observation.data[3]) || !((incidenceAngle = incidenceAngleValueDecoder.decode(incidenceAngleInt)) >= 37.5) || !(incidenceAngle <= 52.5)) continue;
                    sx += incidenceAngle;
                    sy += (double)value;
                    sxx += incidenceAngle * incidenceAngle;
                    sxy += incidenceAngle * (double)value;
                    ++count;
                    if (!hasLower) {
                        boolean bl = hasLower = incidenceAngle <= 42.5;
                    }
                    if (hasUpper) continue;
                    hasUpper = incidenceAngle > 42.5;
                }
                if (hasLower && hasUpper) {
                    double a = ((double)count * sxy - sx * sy) / ((double)count * sxx - sx * sx);
                    double b = (sy - a * sx) / (double)count;
                    return (int)(a * 42.5 + b);
                }
            }
            return noDataValue;
        }

        @Override
        public int getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public void setSnapshotId(int snapshotId) {
            this.snapshotId = snapshotId;
        }
    }
}

