/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.bufr;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.esa.smos.dataio.smos.CellValueProvider;
import org.esa.smos.dataio.smos.DggUtils;
import org.esa.smos.dataio.smos.GridPointBtDataset;
import org.esa.smos.dataio.smos.PolarisationModel;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.smos.dataio.smos.SmosReader;
import org.esa.smos.dataio.smos.SnapshotInfo;
import org.esa.smos.dataio.smos.bufr.BufrPolarisationModel;
import org.esa.smos.dataio.smos.bufr.BufrSupport;
import org.esa.smos.dataio.smos.bufr.IndexArea;
import org.esa.smos.dataio.smos.bufr.LightBufrMultiLevelSource;
import org.esa.smos.dataio.smos.bufr.SmosBufrFile;
import org.esa.smos.dataio.smos.bufr.SmosBufrReaderPlugIn;
import org.esa.smos.dataio.smos.bufr.ValueAccessor;
import org.esa.smos.dataio.smos.bufr.ValueAccessors;
import org.esa.smos.dataio.smos.bufr.ValueDecoder;
import org.esa.smos.dataio.smos.bufr.ValueDecoders;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dgg.SmosDgg;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Sequence;
import ucar.nc2.Variable;

public class SmosBufrReader
extends SmosReader {
    private final Map<Integer, IndexArea> snapshotMessageIndexMap = new HashMap<Integer, IndexArea>();
    private BufrSupport bufrSupport;
    private ValueDecoders valueDecoders;
    private int firstSnapshotId = -1;
    private SnapshotInfo snapshotInfo = null;

    public SmosBufrReader(SmosBufrReaderPlugIn smosBufrReaderPlugIn) {
        super(smosBufrReaderPlugIn);
    }

    @Override
    public final boolean canSupplyGridPointBtData() {
        return false;
    }

    @Override
    public final boolean canSupplyFullPolData() {
        return true;
    }

    @Override
    public final GridPointBtDataset getBtData(int gridPointIndex) {
        return null;
    }

    @Override
    public final int getGridPointIndex(int gridPointId) {
        return -1;
    }

    @Override
    public int getGridPointId(int levelPixelX, int levelPixelY, int currentLevel) {
        MultiLevelImage levelImage = SmosDgg.getInstance().getMultiLevelImage();
        RenderedImage image = levelImage.getImage(currentLevel);
        Raster data = image.getData(new Rectangle(levelPixelX, levelPixelY, 1, 1));
        return data.getSample(levelPixelX, levelPixelY, 0);
    }

    @Override
    public final String[] getRawDataTableNames() {
        return null;
    }

    @Override
    public final FlagDescriptor[] getBtFlagDescriptors() {
        return null;
    }

    @Override
    public final PolarisationModel getPolarisationModel() {
        return new BufrPolarisationModel();
    }

    @Override
    public final boolean canSupplySnapshotData() {
        return true;
    }

    @Override
    public final boolean hasSnapshotInfo() {
        return true;
    }

    @Override
    public SnapshotInfo getSnapshotInfo() {
        if (this.snapshotInfo == null) {
            this.createSnapshotInfo();
        }
        return this.snapshotInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[][] getSnapshotData(int snapshotIndex) throws IOException {
        SmosBufrReader smosBufrReader = this;
        synchronized (smosBufrReader) {
            StructureDataIterator observationIterator = this.bufrSupport.getStructureIterator(snapshotIndex);
            StructureData snapshotStructure = observationIterator.next();
            if (snapshotStructure == null) {
                return new Object[0][];
            }
            Object[][] snapshotData = new Object[BufrSupport.SNAPSHOT_DATA_NAMES.length][2];
            for (int i = 0; i < BufrSupport.SNAPSHOT_DATA_NAMES.length; ++i) {
                String variableName = BufrSupport.SNAPSHOT_DATA_NAMES[i];
                snapshotData[i][0] = variableName;
                if (variableName.equals("Snapshot_overall_quality")) {
                    Array snapshot_overall_quality = snapshotStructure.getArray("Snapshot_overall_quality");
                    snapshotData[i][1] = snapshot_overall_quality.getByte(0);
                    continue;
                }
                ValueAccessor valueAccessor = ValueAccessors.get(variableName);
                valueAccessor.read(snapshotStructure);
                int rawValue = valueAccessor.getRawValue();
                snapshotData[i][1] = i == 7 ? (Number)this.valueDecoders.tecDecoder.decode(rawValue) : (Number)(i == 9 ? (Number)this.valueDecoders.snapshotAccuracyDecoder.decode(rawValue) : (Number)(i == 10 ? (Number)this.valueDecoders.raPpDecoder.decode(rawValue) : (Number)(i == 11 ? (Number)this.valueDecoders.raCpDecoder.decode(rawValue) : (Number)rawValue)));
            }
            return snapshotData;
        }
    }

    protected Product readProductNodesImpl() throws IOException {
        File inputFile = this.getInputFile();
        this.bufrSupport = new BufrSupport();
        this.bufrSupport.open(inputFile.getPath());
        Product product = ProductHelper.createProduct(inputFile, "SMOS.MIRAS.NRT_BUFR");
        this.bufrSupport.extractMetaData(product);
        this.valueDecoders = this.bufrSupport.extractValueDecoders();
        this.scanFile();
        this.addBands(product);
        return product;
    }

    public void close() throws IOException {
        super.close();
        if (this.bufrSupport != null) {
            this.bufrSupport.close();
            this.bufrSupport = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) {
        SmosBufrReader smosBufrReader = this;
        synchronized (smosBufrReader) {
            MultiLevelImage image = destBand.getSourceImage();
            Raster data = image.getData(new Rectangle(destOffsetX, destOffsetY, destWidth, destHeight));
            data.getDataElements(destOffsetX, destOffsetY, destWidth, destHeight, destBuffer.getElems());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFile() throws IOException {
        SmosBufrReader smosBufrReader = this;
        synchronized (smosBufrReader) {
            int messageCount = this.bufrSupport.getMessageCount();
            for (int i = 0; i < messageCount; ++i) {
                IndexArea current = new IndexArea(i);
                int snapshotId = -1;
                StructureDataIterator observationIterator = this.bufrSupport.getStructureIterator(i);
                boolean firstIteration = true;
                Rectangle2D snapshotArea = null;
                while (observationIterator.hasNext()) {
                    StructureData structureData = observationIterator.next();
                    if (firstIteration) {
                        snapshotId = structureData.getScalarInt("Snapshot_identifier");
                        firstIteration = false;
                        if (this.firstSnapshotId == -1) {
                            this.firstSnapshotId = snapshotId;
                        }
                    }
                    int highAccuracyLon = structureData.getScalarInt("Longitude_high_accuracy");
                    float lon = (float)this.valueDecoders.lonDecoder.decode(highAccuracyLon);
                    int highAccuracyLat = structureData.getScalarInt("Latitude_high_accuracy");
                    float lat = (float)this.valueDecoders.latDecoder.decode(highAccuracyLat);
                    if (snapshotArea == null) {
                        snapshotArea = DggUtils.createGridPointRectangle(lon, lat);
                        continue;
                    }
                    Rectangle2D gridPointRectangle = DggUtils.createGridPointRectangle(lon, lat);
                    snapshotArea.add(gridPointRectangle);
                }
                current.setArea(snapshotArea);
                this.snapshotMessageIndexMap.put(snapshotId, current);
            }
        }
    }

    private void addBands(Product product) {
        SmosBufrFile smosBufrFile = this.bufrSupport.getSmosBufrFile();
        Sequence sequence = smosBufrFile.getObservationStructure();
        Family<BandDescriptor> descriptors = Dddb.getInstance().getBandDescriptors("BUFR");
        for (BandDescriptor descriptor : descriptors.asList()) {
            int dataType;
            Variable variable = sequence.findVariable(descriptor.getMemberName());
            if (variable.getDataType().isEnum()) {
                dataType = 20;
                this.addBand(product, variable, 20, descriptor);
                continue;
            }
            dataType = BufrSupport.getBufrDataType(variable);
            if (dataType == -1) continue;
            this.addBand(product, variable, dataType, descriptor);
        }
    }

    private void addBand(Product product, Variable variable, int dataType, BandDescriptor descriptor) {
        String validPixelExpression;
        Number missingValue;
        double scaleFactor;
        SmosBufrFile smosBufrFile;
        ValueDecoder valueDecoder;
        double offset;
        if (!descriptor.isVisible()) {
            return;
        }
        Band band = product.addBand(descriptor.getBandName(), dataType);
        Attribute units = variable.findAttribute("units");
        if (units != null) {
            band.setUnit(units.getStringValue());
        }
        if ((offset = (valueDecoder = (smosBufrFile = this.bufrSupport.getSmosBufrFile()).getValueDecoder(variable.getShortName())).getOffset()) != 0.0) {
            band.setScalingOffset(offset);
        }
        if ((scaleFactor = valueDecoder.getScaleFactor()) != 1.0) {
            band.setScalingFactor(scaleFactor);
        }
        if ((missingValue = valueDecoder.getMissingValue()) != null) {
            band.setNoDataValue(missingValue.doubleValue());
            band.setNoDataValueUsed(true);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)(validPixelExpression = descriptor.getValidPixelExpression()))) {
            band.setValidPixelExpression(validPixelExpression);
        }
        if (!descriptor.getDescription().isEmpty()) {
            band.setDescription(descriptor.getDescription());
        }
        if (descriptor.getFlagDescriptors() != null) {
            ProductHelper.addFlagsAndMasks(product, band, descriptor.getFlagCodingName(), descriptor.getFlagDescriptors());
        }
        String memberName = descriptor.getMemberName();
        ValueAccessor valueAccessor = ValueAccessors.get(memberName);
        BufrCellValueProvider valueProvider = new BufrCellValueProvider(valueAccessor, this.firstSnapshotId, descriptor.getPolarization());
        band.setSourceImage(this.createSourceImage(band, valueProvider));
        band.setImageInfo(ProductHelper.createImageInfo(band, descriptor));
    }

    private MultiLevelImage createSourceImage(Band band, CellValueProvider valueProvider) {
        return new DefaultMultiLevelImage(this.createMultiLevelSource(band, valueProvider));
    }

    private MultiLevelSource createMultiLevelSource(Band band, CellValueProvider valueProvider) {
        MultiLevelModel multiLevelModel = SmosDgg.getInstance().getMultiLevelImage().getModel();
        return new LightBufrMultiLevelSource(multiLevelModel, valueProvider, (RasterDataNode)band);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSnapshotInfo() {
        try {
            TreeSet<Long> all = new TreeSet<Long>();
            TreeSet<Long> x = new TreeSet<Long>();
            TreeSet<Long> y = new TreeSet<Long>();
            TreeSet<Long> xy = new TreeSet<Long>();
            TreeMap<Long, Integer> snapshotIndexMap = new TreeMap<Long, Integer>();
            TreeMap<Long, Rectangle2D> snapshotAreaMap = new TreeMap<Long, Rectangle2D>();
            PolarisationModel polarisationModel = this.getPolarisationModel();
            SmosBufrReader smosBufrReader = this;
            synchronized (smosBufrReader) {
                int messageCount = this.bufrSupport.getMessageCount();
                for (int i = 0; i < messageCount; ++i) {
                    StructureDataIterator observationIterator = this.bufrSupport.getStructureIterator(i);
                    while (observationIterator.hasNext()) {
                        StructureData snapshotData = observationIterator.next();
                        long longSnapshotId = snapshotData.getScalarInt("Snapshot_identifier");
                        byte snapshotPolarisation = snapshotData.getScalarByte("Polarisation");
                        all.add(longSnapshotId);
                        if (polarisationModel.is_X_Polarised(snapshotPolarisation)) {
                            x.add(longSnapshotId);
                        }
                        if (polarisationModel.is_Y_Polarised(snapshotPolarisation)) {
                            y.add(longSnapshotId);
                        }
                        if (!polarisationModel.is_XY1_Polarised(snapshotPolarisation) && !polarisationModel.is_XY2_Polarised(snapshotPolarisation)) continue;
                        xy.add(longSnapshotId);
                    }
                }
            }
            Set<Integer> snapshotIds = this.snapshotMessageIndexMap.keySet();
            for (int snapShotId : snapshotIds) {
                IndexArea indexArea = this.snapshotMessageIndexMap.get(snapShotId);
                Long longSnapshotId = snapShotId;
                snapshotIndexMap.put(longSnapshotId, indexArea.getMessageIndex());
                snapshotAreaMap.put(longSnapshotId, indexArea.getArea());
            }
            this.snapshotInfo = new SnapshotInfo(snapshotIndexMap, all, x, y, xy, snapshotAreaMap, null);
        }
        catch (IOException e) {
            Logger systemLogger = SystemUtils.LOG;
            systemLogger.warning("Failed to read snpshot data: " + e.getMessage());
            this.snapshotInfo = null;
        }
    }

    private class BufrCellValueProvider
    implements CellValueProvider {
        private final ValueAccessor valueAccessor;
        private final int polarisation;
        private int snapshotId;
        private int snapshotMessageIndex;
        private Area area;
        private HashMap<Integer, Integer> dataMap;
        private boolean dataLoaded;

        private BufrCellValueProvider(ValueAccessor valueAccessor, int firstSnapshotId, int polarisation) {
            this.polarisation = polarisation;
            this.valueAccessor = valueAccessor;
            this.snapshotId = firstSnapshotId;
            this.findSnapshotAreaAndIndex();
        }

        @Override
        public Area getArea() {
            return this.area;
        }

        @Override
        public long getCellIndex(double lon, double lat) {
            int seqnum = SmosDgg.getInstance().getSeqnum(lon, lat);
            return SmosDgg.seqnumToGridPointId((int)seqnum);
        }

        @Override
        public byte getValue(long cellIndex, byte noDataValue) {
            return (byte)this.getData((int)cellIndex, noDataValue);
        }

        @Override
        public int getValue(long cellIndex, int noDataValue) {
            return this.getData((int)cellIndex, noDataValue);
        }

        @Override
        public short getValue(long cellIndex, short noDataValue) {
            return (short)this.getData((int)cellIndex, noDataValue);
        }

        @Override
        public float getValue(long cellIndex, float noDataValue) {
            throw new IllegalStateException("not implemented");
        }

        @Override
        public int getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public void setSnapshotId(int snapshotId) {
            this.snapshotId = snapshotId;
            this.findSnapshotAreaAndIndex();
            this.dataLoaded = false;
        }

        private void findSnapshotAreaAndIndex() {
            IndexArea indexArea = SmosBufrReader.this.snapshotMessageIndexMap.get(this.snapshotId);
            this.area = new Area(indexArea.getArea());
            this.snapshotMessageIndex = indexArea.getMessageIndex();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readSnapshotData() {
            try {
                SmosBufrReader smosBufrReader = SmosBufrReader.this;
                synchronized (smosBufrReader) {
                    this.dataMap = new HashMap();
                    StructureDataIterator observationIterator = SmosBufrReader.this.bufrSupport.getStructureIterator(this.snapshotMessageIndex);
                    while (observationIterator.hasNext()) {
                        StructureData snapshotData = observationIterator.next();
                        byte snapshotPolarisation = snapshotData.getScalarByte("Polarisation");
                        if (this.polarisation != 4 && (snapshotPolarisation & 3) != this.polarisation && (this.polarisation & snapshotPolarisation & 2) == 0) continue;
                        this.valueAccessor.read(snapshotData);
                        this.dataMap.put(this.valueAccessor.getGridPointId(), this.valueAccessor.getRawValue());
                    }
                }
                this.dataLoaded = true;
            }
            catch (IOException e) {
                Logger systemLogger = SystemUtils.LOG;
                systemLogger.warning("Failed to read snpshot data: " + e.getMessage());
            }
        }

        private int getData(int cellIndex, int noDataValue) {
            return this.getSnapshotData(cellIndex, noDataValue);
        }

        private int getSnapshotData(int cellIndex, int noDataValue) {
            Integer rawValue;
            if (!this.dataLoaded) {
                this.readSnapshotData();
            }
            if ((rawValue = this.dataMap.get(cellIndex)) == null) {
                return noDataValue;
            }
            return rawValue;
        }
    }
}

