/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.bufr;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.smos.dataio.smos.bufr.ValueDecoder;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.smos.bufr.SmosBufrIosp;
import ucar.unidata.io.InMemoryRandomAccessFile;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.bzip2.CBZip2InputStream;

public class SmosBufrFile
extends NetcdfFile
implements Closeable {
    public static final String AZIMUTH_ANGLE = "Azimuth_angle";
    public static final String BRIGHTNESS_TEMPERATURE_IMAGINARY_PART = "Brightness_temperature_imaginary_part";
    public static final String BRIGHTNESS_TEMPERATURE_REAL_PART = "Brightness_temperature_real_part";
    public static final String DIRECT_SUN_BRIGHTNESS_TEMPERATURE = "Direct_sun_brightness_temperature";
    public static final String FARADAY_ROTATIONAL_ANGLE = "Faraday_rotational_angle";
    public static final String FOOTPRINT_AXIS_1 = "Footprint_axis_1";
    public static final String FOOTPRINT_AXIS_2 = "Footprint_axis_2";
    public static final String GEOMETRIC_ROTATIONAL_ANGLE = "Geometric_rotational_angle";
    public static final String GRID_POINT_IDENTIFIER = "Grid_point_identifier";
    public static final String INCIDENCE_ANGLE = "Incidence_angle";
    public static final String LATITUDE_HIGH_ACCURACY = "Latitude_high_accuracy";
    public static final String LONGITUDE_HIGH_ACCURACY = "Longitude_high_accuracy";
    public static final String NUMBER_OF_GRID_POINTS = "Number_of_grid_points";
    public static final String PIXEL_RADIOMETRIC_ACCURACY = "Pixel_radiometric_accuracy";
    public static final String POLARISATION = "Polarisation";
    public static final String RADIOMETRIC_ACCURACY_CP = "Radiometric_accuracy_cross_polarisation";
    public static final String RADIOMETRIC_ACCURACY_PP = "Radiometric_accuracy_pure_polarisation";
    public static final String SMOS_INFORMATION_FLAG = "SMOS_information_flag";
    public static final String SNAPSHOT_ACCURACY = "Snapshot_accuracy";
    public static final String SNAPSHOT_OVERALL_QUALITY = "Snapshot_overall_quality";
    public static final String SNAPSHOT_IDENTIFIER = "Snapshot_identifier";
    public static final String TOTAL_ELECTRON_COUNT = "Total_electron_count_per_square_metre";
    public static final String WATER_FRACTION = "Water_fraction";
    private static final String ATTR_NAME_ADD_OFFSET = "add_offset";
    private static final String ATTR_NAME_SCALE_FACTOR = "scale_factor";
    private static final String ATTR_NAME_MISSING_VALUE = "missing_value";
    private final SmosBufrIosp instance;
    private final Map<String, ValueDecoder> valueDecoderMap;

    public static SmosBufrFile open(String location) throws IOException {
        return new SmosBufrFile(new SmosBufrIosp(), location);
    }

    private static RandomAccessFile createRandomAccessFile(String location) throws IOException {
        File file = new File(location);
        String fileName = file.getName().toLowerCase();
        if (fileName.endsWith(".bz2")) {
            InputStream inputStream = SmosBufrFile.createInputStream(file);
            ImageInputStream imageInputStream = SmosBufrFile.createImageInputStream(inputStream);
            long imageInputStreamSize = SmosBufrFile.getLength(imageInputStream);
            return new ImageInputStreamRandomAccessFile(imageInputStream, imageInputStreamSize);
        }
        return new RandomAccessFile(location, "r");
    }

    static ImageInputStream createImageInputStream(InputStream inputStream) throws IOException {
        return new FileCacheImageInputStream(inputStream, null);
    }

    static InputStream createInputStream(File file) throws IOException {
        return new CBZip2InputStream((InputStream)new BufferedInputStream(new FileInputStream(file)), true);
    }

    static long getLength(ImageInputStream imageInputStream) throws IOException {
        int count;
        byte[] b = new byte[16384];
        long length = 0L;
        while ((count = imageInputStream.read(b, 0, b.length)) != -1) {
            length += (long)count;
        }
        return length;
    }

    private SmosBufrFile(SmosBufrIosp iosp, String location) throws IOException {
        super((IOServiceProvider)iosp, location);
        this.instance = iosp;
        RandomAccessFile randomAccessFile = SmosBufrFile.createRandomAccessFile(location);
        this.instance.open(randomAccessFile, this, null);
        this.valueDecoderMap = new HashMap<String, ValueDecoder>();
        this.addValueDecoder(AZIMUTH_ANGLE);
        this.addValueDecoder(BRIGHTNESS_TEMPERATURE_IMAGINARY_PART);
        this.addValueDecoder(BRIGHTNESS_TEMPERATURE_REAL_PART);
        this.addValueDecoder(DIRECT_SUN_BRIGHTNESS_TEMPERATURE);
        this.addValueDecoder(FARADAY_ROTATIONAL_ANGLE);
        this.addValueDecoder(FOOTPRINT_AXIS_1);
        this.addValueDecoder(FOOTPRINT_AXIS_2);
        this.addValueDecoder(GEOMETRIC_ROTATIONAL_ANGLE);
        this.addValueDecoder(GRID_POINT_IDENTIFIER);
        this.addValueDecoder(INCIDENCE_ANGLE);
        this.addValueDecoder(LATITUDE_HIGH_ACCURACY);
        this.addValueDecoder(LONGITUDE_HIGH_ACCURACY);
        this.addValueDecoder(NUMBER_OF_GRID_POINTS);
        this.addValueDecoder(PIXEL_RADIOMETRIC_ACCURACY);
        this.addValueDecoder(POLARISATION);
        this.addValueDecoder(RADIOMETRIC_ACCURACY_CP);
        this.addValueDecoder(RADIOMETRIC_ACCURACY_PP);
        this.addValueDecoder(SMOS_INFORMATION_FLAG);
        this.addValueDecoder(SNAPSHOT_ACCURACY);
        this.addValueDecoder(SNAPSHOT_OVERALL_QUALITY);
        this.addValueDecoder(SNAPSHOT_IDENTIFIER);
        this.addValueDecoder(TOTAL_ELECTRON_COUNT);
        this.addValueDecoder(WATER_FRACTION);
    }

    static double getAttributeValue(Variable variable, String attributeName, double defaultValue) {
        Attribute attribute = variable.findAttribute(attributeName);
        if (attribute == null) {
            return defaultValue;
        }
        return attribute.getNumericValue().doubleValue();
    }

    static Number getAttributeValue(Variable variable, String attributeName) {
        Attribute attribute = variable.findAttribute(attributeName);
        if (attribute == null) {
            return null;
        }
        return attribute.getNumericValue();
    }

    static ValueDecoder createValueDecoder(Variable variable) {
        double scale = SmosBufrFile.getAttributeValue(variable, ATTR_NAME_SCALE_FACTOR, 1.0);
        double offset = SmosBufrFile.getAttributeValue(variable, ATTR_NAME_ADD_OFFSET, 0.0);
        Number missingValue = SmosBufrFile.getAttributeValue(variable, ATTR_NAME_MISSING_VALUE);
        return new ValueDecoder(scale, offset, missingValue);
    }

    ValueDecoder getValueDecoder(String variableName) {
        return this.valueDecoderMap.get(variableName);
    }

    public int getMessageCount() {
        return this.instance.getMessageCount();
    }

    public StructureDataIterator getStructureIterator(int messageIndex) throws IOException {
        return this.instance.getStructureDataIterator(messageIndex);
    }

    public Sequence getObservationStructure() {
        Variable obs = this.findVariable("obs");
        if (obs instanceof Sequence) {
            return (Sequence)obs;
        }
        throw new RuntimeException("BUFR file does not contain an observation sequence.");
    }

    private ValueDecoder createValueDecoder(String variableName) {
        return SmosBufrFile.createValueDecoder(this.getObservationStructure().findVariable(variableName));
    }

    private void addValueDecoder(String variableName) {
        this.valueDecoderMap.put(variableName, this.createValueDecoder(variableName));
    }

    private static final class ImageInputStreamRandomAccessFile
    extends RandomAccessFile {
        private final ImageInputStream imageInputStream;
        private final long length;

        static RandomAccessFile create(ImageInputStream imageInputStream, long length) throws IOException {
            byte[] b = new byte[(int)length];
            imageInputStream.readFully(b);
            return new InMemoryRandomAccessFile("BUFR", b);
        }

        private ImageInputStreamRandomAccessFile(ImageInputStream imageInputStream, long length) {
            super(8192);
            this.imageInputStream = imageInputStream;
            this.length = length;
        }

        public void setBufferSize(int bufferSize) {
        }

        public String getLocation() {
            return "ImageInputStream";
        }

        public long length() throws IOException {
            return this.length;
        }

        protected int read_(long pos, byte[] b, int offset, int len) throws IOException {
            this.imageInputStream.seek(pos);
            return this.imageInputStream.read(b, offset, len);
        }

        public long readToByteChannel(WritableByteChannel dest, long offset, long nbytes) throws IOException {
            int n = (int)nbytes;
            byte[] buffer = new byte[n];
            int done = this.read_(offset, buffer, 0, n);
            dest.write(ByteBuffer.wrap(buffer));
            return done;
        }

        public void close() throws IOException {
            this.imageInputStream.close();
        }
    }
}

