/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos.bufr;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.esa.smos.dataio.smos.bufr.SmosBufrFile;
import org.esa.smos.dataio.smos.bufr.ValueDecoder;
import org.esa.smos.dataio.smos.bufr.ValueDecoders;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.MetadataUtils;
import ucar.ma2.DataType;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Sequence;
import ucar.nc2.Variable;

class BufrSupport {
    static final int BT_REAL_INDEX = 0;
    static final int BT_IMAG_INDEX = 1;
    static final int RADIOMETRIC_ACCURACY_INDEX = 2;
    static final int INCIDENCE_ANGLE_INDEX = 3;
    static final int AZIMUTH_ANGLE_INDEX = 4;
    static final int FARADAY_ANGLE_INDEX = 5;
    static final int GEOMETRIC_ANGLE_INDEX = 6;
    static final int FOOTPRINT_AXIS_1_INDEX = 7;
    static final int FOOTPRINT_AXIS_2_INDEX = 8;
    static final int WATER_FRACTION_INDEX = 9;
    static final int INFORMATION_FLAG_INDEX = 10;
    static final int POLARISATION_INDEX = 11;
    static final int TEC_INDEX = 7;
    static final int ACCURACY_INDEX = 9;
    static final int RA_PP_INDEX = 10;
    static final int RA_CP_INDEX = 11;
    private static final HashMap<String, Integer> datasetNameIndexMap;
    static final String[] RAW_DATA_NAMES;
    static final String[] SNAPSHOT_DATA_NAMES;
    private SmosBufrFile smosBufrFile;

    BufrSupport() {
    }

    void open(String location) throws IOException {
        this.smosBufrFile = SmosBufrFile.open(location);
    }

    void close() throws IOException {
        if (this.smosBufrFile != null) {
            this.smosBufrFile.close();
            this.smosBufrFile = null;
        }
    }

    SmosBufrFile getSmosBufrFile() {
        return this.smosBufrFile;
    }

    int getMessageCount() {
        return this.smosBufrFile.getMessageCount();
    }

    StructureDataIterator getStructureIterator(int index) throws IOException {
        return this.smosBufrFile.getStructureIterator(index);
    }

    void extractMetaData(Product product) {
        List globalAttributes = this.smosBufrFile.getGlobalAttributes();
        MetadataElement metadataRoot = product.getMetadataRoot();
        metadataRoot.addElement(MetadataUtils.readAttributeList((Iterable)globalAttributes, (String)"Global_Attributes"));
        Sequence sequence = this.smosBufrFile.getObservationStructure();
        List variables = sequence.getVariables();
        metadataRoot.addElement(MetadataUtils.readVariableDescriptions((List)variables, (String)"Variable_Attributes", (int)100));
    }

    ValueDecoders extractValueDecoders() {
        ValueDecoders valueDecoders = new ValueDecoders();
        valueDecoders.lonDecoder = this.smosBufrFile.getValueDecoder("Longitude_high_accuracy");
        valueDecoders.latDecoder = this.smosBufrFile.getValueDecoder("Latitude_high_accuracy");
        valueDecoders.incidenceAngleDecoder = this.smosBufrFile.getValueDecoder("Incidence_angle");
        valueDecoders.tecDecoder = this.smosBufrFile.getValueDecoder("Total_electron_count_per_square_metre");
        valueDecoders.snapshotAccuracyDecoder = this.smosBufrFile.getValueDecoder("Snapshot_accuracy");
        valueDecoders.raPpDecoder = this.smosBufrFile.getValueDecoder("Radiometric_accuracy_pure_polarisation");
        valueDecoders.raCpDecoder = this.smosBufrFile.getValueDecoder("Radiometric_accuracy_cross_polarisation");
        valueDecoders.dataDecoders = new ValueDecoder[RAW_DATA_NAMES.length];
        for (int i = 0; i < RAW_DATA_NAMES.length; ++i) {
            ValueDecoder factor;
            valueDecoders.dataDecoders[i] = factor = this.smosBufrFile.getValueDecoder(RAW_DATA_NAMES[i]);
        }
        return valueDecoders;
    }

    int getNumDatasets() {
        return datasetNameIndexMap.size();
    }

    static HashMap<String, Integer> getDatasetNameIndexMap() {
        return datasetNameIndexMap;
    }

    static boolean isIntegerBandIndex(int index) {
        return index == 10 || index == 11;
    }

    static int getBufrDataType(Variable variable) {
        boolean unsignedDataType = false;
        Attribute _unsignedAttrbute = variable.findAttribute("_Unsigned");
        if (_unsignedAttrbute != null) {
            unsignedDataType = Boolean.parseBoolean(_unsignedAttrbute.getStringValue());
        }
        return DataTypeUtils.getRasterDataType((DataType)variable.getDataType(), (boolean)unsignedDataType);
    }

    static {
        RAW_DATA_NAMES = new String[]{"Brightness_temperature_real_part", "Brightness_temperature_imaginary_part", "Pixel_radiometric_accuracy", "Incidence_angle", "Azimuth_angle", "Faraday_rotational_angle", "Geometric_rotational_angle", "Footprint_axis_1", "Footprint_axis_2", "Water_fraction", "SMOS_information_flag", "Polarisation"};
        SNAPSHOT_DATA_NAMES = new String[]{"Number_of_grid_points", "Year", "Month", "Day", "Hour", "Minute", "Second", "Total_electron_count_per_square_metre", "Direct_sun_brightness_temperature", "Snapshot_accuracy", "Radiometric_accuracy_pure_polarisation", "Radiometric_accuracy_cross_polarisation", "Snapshot_overall_quality"};
        datasetNameIndexMap = new HashMap();
        datasetNameIndexMap.put(RAW_DATA_NAMES[0], 0);
        datasetNameIndexMap.put(RAW_DATA_NAMES[1], 1);
        datasetNameIndexMap.put(RAW_DATA_NAMES[2], 2);
        datasetNameIndexMap.put(RAW_DATA_NAMES[3], 3);
        datasetNameIndexMap.put(RAW_DATA_NAMES[4], 4);
        datasetNameIndexMap.put(RAW_DATA_NAMES[5], 5);
        datasetNameIndexMap.put(RAW_DATA_NAMES[6], 6);
        datasetNameIndexMap.put(RAW_DATA_NAMES[7], 7);
        datasetNameIndexMap.put(RAW_DATA_NAMES[8], 8);
        datasetNameIndexMap.put(RAW_DATA_NAMES[9], 9);
        datasetNameIndexMap.put(RAW_DATA_NAMES[10], 10);
        datasetNameIndexMap.put(RAW_DATA_NAMES[11], 11);
    }
}

