/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceData;
import java.awt.Dimension;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import org.esa.smos.DateTimeUtils;
import org.esa.smos.EEFilePair;
import org.esa.smos.dataio.smos.ExplorerFile;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.io.FileUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

class VTecFile
extends ExplorerFile {
    private static final String TAG_IONEX_DESCRIPTOR = "IONEX_Descriptor";
    private static final String TAG_LATITUDE_VECTOR = "Latitude_Vector";
    private static final String TAG_LATITUDE_VECTOR_1ST = "Latitude_Vector_1st";
    private static final String TAG_LATITUDE_VECTOR_2ND = "Latitude_Vector_2nd";
    private static final String TAG_LATITUDE_VECTOR_INCREMENT = "Latitude_Vector_Increment";
    private static final String TAG_LONGITUDE_VECTOR = "Longitude_Vector";
    private static final String TAG_LONGITUDE_VECTOR_1ST = "Longitude_Vector_1st";
    private static final String TAG_LONGITUDE_VECTOR_2ND = "Longitude_Vector_2nd";
    private static final String TAG_LONGITUDE_VECTOR_INCREMENT = "Longitude_Vector_Increment";
    private static final String TAG_SCALING_FACTOR_EXPONENT = "Scale_Factor";
    private static final String DAYS_NAME = "Days";
    private static final String EPOCH_CURRENT_MAP_NAME = "Epoch_Current_Map";
    private static final String MAP_NUMBER_NAME = "Map_Number";
    private static final String MICROSECONDS_NAME = "Microseconds";
    private static final String SECONDS_NAME = "Seconds";
    private static final String VTEC_INFO_NAME = "VTEC_Info";
    private static final String VTEC_RECORD_NAME = "VTEC_Record";
    private static final String VTEC_DATA_NAME = "VTEC_Data";
    private static final String VTEC_VALUE_NAME = "VTEC_value";
    private final SequenceData mapData;
    private final double lat1;
    private final double lat2;
    private final double latDelta;
    private final double lon1;
    private final double lon2;
    private final double lonDelta;
    private double scalingFactor;
    private final int rowCount;
    private final int colCount;

    VTecFile(EEFilePair eeFilePair, DataContext dataContext) throws IOException {
        super(eeFilePair, dataContext);
        Document document = this.getDocument();
        Namespace namespace = document.getRootElement().getNamespace();
        Element ionexDescriptor = this.getElement(document.getRootElement(), TAG_IONEX_DESCRIPTOR);
        Element latitudeVector = this.getElement(ionexDescriptor, TAG_LATITUDE_VECTOR);
        this.lat1 = Double.valueOf(latitudeVector.getChildText(TAG_LATITUDE_VECTOR_1ST, namespace));
        this.lat2 = Double.valueOf(latitudeVector.getChildText(TAG_LATITUDE_VECTOR_2ND, namespace));
        this.latDelta = Double.valueOf(latitudeVector.getChildText(TAG_LATITUDE_VECTOR_INCREMENT, namespace));
        Element longitudeVector = this.getElement(ionexDescriptor, TAG_LONGITUDE_VECTOR);
        this.lon1 = Double.valueOf(longitudeVector.getChildText(TAG_LONGITUDE_VECTOR_1ST, namespace));
        this.lon2 = Double.valueOf(longitudeVector.getChildText(TAG_LONGITUDE_VECTOR_2ND, namespace));
        this.lonDelta = Double.valueOf(longitudeVector.getChildText(TAG_LONGITUDE_VECTOR_INCREMENT, namespace));
        int scalingFactorExponent = Integer.valueOf(ionexDescriptor.getChildText(TAG_SCALING_FACTOR_EXPONENT, namespace));
        this.scalingFactor = Math.pow(10.0, scalingFactorExponent);
        this.mapData = this.getDataBlock().getSequence(VTEC_INFO_NAME);
        if (this.mapData == null) {
            throw new IllegalStateException(MessageFormat.format("SMOS File ''{0}'': Missing VTEC info.", eeFilePair.getDblFile().getPath()));
        }
        this.rowCount = (int)(Math.round((this.lat2 - this.lat1) / this.latDelta) + 1L);
        this.colCount = (int)(Math.round((this.lon2 - this.lon1) / this.lonDelta) + 1L);
    }

    @Override
    public final Area getArea() {
        return new Area(new Rectangle2D.Double(this.lon1, this.lat2, this.lon2 - this.lon1, this.lat1 - this.lat2));
    }

    @Override
    public Product createProduct() throws IOException {
        String productName = FileUtils.getFilenameWithoutExtension((File)this.getDataFile());
        String productType = this.getProductType();
        Dimension dimension = ProductHelper.getSceneRasterDimension();
        Product product = new Product(productName, productType, dimension.width, dimension.height);
        product.setFileLocation(this.getDataFile());
        product.setPreferredTileSize(512, 504);
        ProductHelper.addMetadata(product.getMetadataRoot(), this);
        product.setSceneGeoCoding(ProductHelper.createGeoCoding(dimension));
        for (int i = 0; i < this.mapData.getElementCount(); ++i) {
            CompoundData mapCompoundData = this.mapData.getCompound(i);
            SequenceData mapSequenceData = mapCompoundData.getSequence(VTEC_RECORD_NAME);
            float[] tiePoints = new float[this.rowCount * this.colCount];
            for (int j = 0; j < mapSequenceData.getElementCount(); ++j) {
                CompoundData compoundData = mapSequenceData.getCompound(j);
                SequenceData sequenceData = compoundData.getSequence(VTEC_DATA_NAME);
                for (int k = 0; k < sequenceData.getElementCount(); ++k) {
                    tiePoints[j * this.colCount + k] = sequenceData.getCompound(k).getShort(VTEC_VALUE_NAME);
                }
            }
            String name = this.getName(mapCompoundData);
            String description = this.getDescription(mapCompoundData);
            this.addTiePointGrid(product, name, description, tiePoints);
        }
        return product;
    }

    private void addTiePointGrid(Product product, String name, String description, float[] tiePoints) {
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        double maxLat = 90.0;
        double maxLon = 180.0;
        double latRange = 180.0;
        double lonRange = 360.0;
        double scaleX = (double)w / 360.0;
        double scaleY = (double)h / 180.0;
        double samplingX = Math.abs(this.lonDelta * scaleX);
        double samplingY = Math.abs(this.latDelta * scaleY);
        double offsetX = (180.0 + this.lon1) * scaleX;
        double offsetY = (90.0 - this.lat1) * scaleY;
        TiePointGrid tiePointGrid = new TiePointGrid(name, this.colCount, this.rowCount, offsetX, offsetY, samplingX, samplingY, tiePoints);
        tiePointGrid.setScalingFactor(this.scalingFactor);
        tiePointGrid.setDescription(description);
        tiePointGrid.setUnit("TECU");
        product.addTiePointGrid(tiePointGrid);
    }

    private String getDescription(CompoundData mapCompoundData) throws IOException {
        CompoundData epoch = mapCompoundData.getCompound(EPOCH_CURRENT_MAP_NAME);
        int days = epoch.getInt(DAYS_NAME);
        int seconds = epoch.getInt(SECONDS_NAME);
        int microseconds = epoch.getInt(MICROSECONDS_NAME);
        Date cfiDate = DateTimeUtils.cfiDateToUtc((int)days, (long)seconds, (long)microseconds);
        String dateTime = ProductData.UTC.createDateFormat().format(cfiDate);
        return "Vertical total electron content (TECU) for epoch " + dateTime;
    }

    private String getName(CompoundData mapCompoundData) throws IOException {
        StringBuilder nameBuilder = new StringBuilder(this.getDataFormat().getName().substring(16, 22));
        int mapNumber = mapCompoundData.getInt(MAP_NUMBER_NAME);
        nameBuilder.append("_").append(mapNumber);
        return nameBuilder.toString();
    }
}

