/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;

public class SnapshotInfo {
    private final Map<Long, Integer> snapshotIndexMap;
    private final List<Long> snapshotIds;
    private final List<Long> snapshotIdsX;
    private final List<Long> snapshotIdsY;
    private final List<Long> snapshotIdsXY;
    private final Map<Long, Area> snapshotAreaMap;
    private final List<FlagDescriptor> rfiFlagDescriptors;

    public SnapshotInfo(Map<Long, Integer> snapshotIndexMap, Collection<Long> snapshotIds, Collection<Long> snapshotIdsX, Collection<Long> snapshotIdsY, Collection<Long> snapshotIdsXY, Map<Long, Rectangle2D> snapshotAreaMap, List<FlagDescriptor> rfiFlagDescriptors) {
        this.snapshotIndexMap = Collections.unmodifiableMap(snapshotIndexMap);
        this.snapshotIds = Collections.unmodifiableList(new ArrayList<Long>(snapshotIds));
        this.snapshotIdsX = Collections.unmodifiableList(new ArrayList<Long>(snapshotIdsX));
        this.snapshotIdsY = Collections.unmodifiableList(new ArrayList<Long>(snapshotIdsY));
        this.snapshotIdsXY = Collections.unmodifiableList(new ArrayList<Long>(snapshotIdsXY));
        HashMap<Long, Area> map = new HashMap<Long, Area>();
        for (Map.Entry<Long, Rectangle2D> entry : snapshotAreaMap.entrySet()) {
            map.put(entry.getKey(), new Area(entry.getValue()));
        }
        this.snapshotAreaMap = Collections.unmodifiableMap(map);
        this.rfiFlagDescriptors = rfiFlagDescriptors;
    }

    public boolean containsData() {
        return !this.snapshotIds.isEmpty();
    }

    public int getSnapshotIndex(long snapshotId) {
        if (!this.snapshotIndexMap.containsKey(snapshotId)) {
            return -1;
        }
        return this.snapshotIndexMap.get(snapshotId);
    }

    public List<Long> getSnapshotIds() {
        return this.snapshotIds;
    }

    public List<Long> getSnapshotIdsX() {
        return this.snapshotIdsX;
    }

    public List<Long> getSnapshotIdsY() {
        return this.snapshotIdsY;
    }

    public List<Long> getSnapshotIdsXY() {
        return this.snapshotIdsXY;
    }

    public Area getArea(long snapshotId) {
        return this.snapshotAreaMap.get(snapshotId);
    }

    public List<FlagDescriptor> getRfiFlagDescriptors() {
        return this.rfiFlagDescriptors;
    }
}

