/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.esa.smos.SmosUtils;
import org.esa.smos.dataio.smos.SmosProductReader;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;

public class SmosProductReaderPlugIn
implements ProductReaderPlugIn {
    private static final String[] EXTENSIONS = new String[]{".HDR", ".DBL", ".zip", ".ZIP"};
    private static final String[] FORMAT_NAMES = new String[]{"SMOS-EEF"};
    private static final String DESCRIPTION = "SMOS Data Products";

    public SmosProductReader createReaderInstance() {
        return new SmosProductReader(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecodeQualification getDecodeQualification(Object input) {
        File file = input instanceof File ? (File)input : new File(input.toString());
        String fileName = file.getName();
        if (fileName.endsWith(".DBL") || fileName.endsWith(".HDR")) {
            File hdrFile = FileUtils.exchangeExtension((File)file, (String)".HDR");
            File dblFile = FileUtils.exchangeExtension((File)file, (String)".DBL");
            if (hdrFile.exists() && dblFile.exists()) {
                try {
                    if (Dddb.getInstance().getDataFormat(hdrFile) != null) {
                        return DecodeQualification.INTENDED;
                    }
                }
                catch (Exception exception) {}
            }
        } else if (SmosUtils.isCompressedFile((File)file)) {
            if (SmosUtils.isL1cType((String)fileName) || SmosUtils.isL2Type((String)fileName) || SmosUtils.isAuxECMWFType((String)fileName)) {
                return DecodeQualification.INTENDED;
            }
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                String name1 = entries.nextElement().getName();
                String name2 = entries.nextElement().getName();
                if (name1.endsWith("/") && entries.hasMoreElements()) {
                    name1 = entries.nextElement().getName();
                }
                if (!entries.hasMoreElements() && (name1.endsWith(".HDR") && name2.endsWith(".DBL") || name1.endsWith(".DBL") && name2.endsWith(".HDR"))) {
                    DecodeQualification decodeQualification = DecodeQualification.SUITABLE;
                    return decodeQualification;
                }
            }
            catch (IOException | NoSuchElementException exception) {
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return new Class[]{File.class, String.class};
    }

    public String[] getDefaultFileExtensions() {
        return EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

