/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.util.NumberUtils;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.VirtualDir;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.esa.smos.DateTimeUtils;
import org.esa.smos.EEFilePair;
import org.esa.smos.SmosUtils;
import org.esa.smos.dataio.smos.AuxiliaryFile;
import org.esa.smos.dataio.smos.ExplorerFilenameFilter;
import org.esa.smos.dataio.smos.GlobalSmosFile;
import org.esa.smos.dataio.smos.GridPointBtDataset;
import org.esa.smos.dataio.smos.L1cBrowseSmosFile;
import org.esa.smos.dataio.smos.L1cPolarisationModel;
import org.esa.smos.dataio.smos.L1cScienceSmosFile;
import org.esa.smos.dataio.smos.L1cSmosFile;
import org.esa.smos.dataio.smos.PolarisationModel;
import org.esa.smos.dataio.smos.ProductFile;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.smos.dataio.smos.SmUserSmosFile;
import org.esa.smos.dataio.smos.SmosFile;
import org.esa.smos.dataio.smos.SmosReader;
import org.esa.smos.dataio.smos.SnapshotInfo;
import org.esa.smos.dataio.smos.VTecFile;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.dffg.DffgLaiFile;
import org.esa.smos.dataio.smos.dffg.DffgSnoFile;
import org.esa.smos.dgg.SmosDgg;
import org.esa.smos.lsmask.SmosLsMask;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;

public class SmosProductReader
extends SmosReader {
    private static final String LSMASK_SCHEMA_NAME = "DBL_SM_XXXX_AUX_LSMASK_0200";
    private ProductFile productFile;
    private VirtualDir virtualDir;

    SmosProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    public static ProductFile createProductFile(File file) throws IOException {
        ProductFile productFile;
        File[] files;
        if (file.isDirectory() && (files = file.listFiles(new ExplorerFilenameFilter())) != null && files.length == 2) {
            file = files[0];
        }
        if ((productFile = SmosProductReader.createProductFileImplementation(file)) == null) {
            throw new IOException(MessageFormat.format("File ''{0}'': unknown/unsupported SMOS data format.", file));
        }
        return productFile;
    }

    private static ProductFile createProductFile(VirtualDir virtualDir) throws IOException {
        Object listPath = "";
        String[] list = virtualDir.list((String)listPath);
        if (list.length == 1) {
            listPath = list[0] + "/";
        }
        list = virtualDir.list((String)listPath);
        String fileName = null;
        for (String listEntry : list) {
            if (!listEntry.contains(".hdr") && !listEntry.contains(".HDR")) continue;
            fileName = listEntry;
            break;
        }
        if (fileName == null) {
            return null;
        }
        File hdrFile = virtualDir.getFile((String)listPath + fileName);
        File dblFile = FileUtils.exchangeExtension((File)hdrFile, (String)".DBL");
        dblFile = virtualDir.getFile((String)listPath + dblFile.getName());
        return SmosProductReader.createProductFileImplementation(dblFile);
    }

    private static ProductFile createProductFileImplementation(File file) throws IOException {
        File hdrFile = FileUtils.exchangeExtension((File)file, (String)".HDR");
        File dblFile = FileUtils.exchangeExtension((File)file, (String)".DBL");
        DataFormat format = Dddb.getInstance().getDataFormat(hdrFile);
        if (format == null) {
            return null;
        }
        EEFilePair eeFilePair = new EEFilePair(hdrFile, dblFile);
        String formatName = format.getName();
        DataContext context = format.createContext(dblFile, "r");
        if (SmosUtils.isBrowseFormat((String)formatName)) {
            return new L1cBrowseSmosFile(eeFilePair, context);
        }
        if (SmosUtils.isDualPolScienceFormat((String)formatName) || SmosUtils.isFullPolScienceFormat((String)formatName)) {
            return new L1cScienceSmosFile(eeFilePair, context);
        }
        if (SmosUtils.isSmUserFormat((String)formatName)) {
            return new SmUserSmosFile(eeFilePair, context);
        }
        if (SmosUtils.isOsUserFormat((String)formatName) || SmosUtils.isOsAnalysisFormat((String)formatName) || SmosUtils.isSmAnalysisFormat((String)formatName) || SmosUtils.isAuxECMWFType((String)formatName)) {
            return new SmosFile(eeFilePair, context);
        }
        if (SmosUtils.isDffLaiFormat((String)formatName)) {
            return new DffgLaiFile(eeFilePair, context);
        }
        if (SmosUtils.isDffSnoFormat((String)formatName)) {
            return new DffgSnoFile(eeFilePair, context);
        }
        if (SmosUtils.isVTecFormat((String)formatName)) {
            return new VTecFile(eeFilePair, context);
        }
        if (SmosUtils.isLsMaskFormat((String)formatName)) {
            return new GlobalSmosFile(eeFilePair, context);
        }
        if (SmosUtils.isDggFloFormat((String)formatName) || SmosUtils.isDggRfiFormat((String)formatName) || SmosUtils.isDggRouFormat((String)formatName) || SmosUtils.isDggTfoFormat((String)formatName) || SmosUtils.isDggTlvFormat((String)formatName)) {
            return new AuxiliaryFile(eeFilePair, context);
        }
        return null;
    }

    public ProductFile getProductFile() {
        return this.productFile;
    }

    @Override
    public GridPointBtDataset getBtData(int gridPointIndex) throws IOException {
        if (this.productFile instanceof L1cSmosFile) {
            return this.readBtData(gridPointIndex);
        }
        return null;
    }

    @Override
    public boolean canSupplyGridPointBtData() {
        return this.productFile instanceof L1cSmosFile;
    }

    @Override
    public boolean canSupplyFullPolData() {
        return SmosUtils.isFullPolScienceFormat((String)this.productFile.getDataFile().getName());
    }

    @Override
    public int getGridPointIndex(int gridPointId) {
        if (this.productFile instanceof L1cSmosFile) {
            return ((L1cSmosFile)this.productFile).getGridPointIndex(gridPointId);
        }
        return -1;
    }

    @Override
    public int getGridPointId(int levelPixelX, int levelPixelY, int currentLevel) {
        MultiLevelImage levelImage = SmosDgg.getInstance().getMultiLevelImage();
        RenderedImage image = levelImage.getImage(currentLevel);
        Raster data = image.getData(new Rectangle(levelPixelX, levelPixelY, 1, 1));
        return data.getSample(levelPixelX, levelPixelY, 0);
    }

    private GridPointBtDataset readBtData(int gridPointIndex) throws IOException {
        Integer bt_value_imag;
        Integer bt_value_real;
        Integer pixel_radiometric_accuracy;
        Integer incidence_angle;
        BandDescriptor descriptor;
        L1cSmosFile smosFile = (L1cSmosFile)this.productFile;
        SequenceData btDataList = smosFile.getBtDataList(gridPointIndex);
        CompoundType type = (CompoundType)btDataList.getType().getElementType();
        int memberCount = type.getMemberCount();
        int btDataListCount = btDataList.getElementCount();
        Class[] columnClasses = new Class[memberCount];
        BandDescriptor[] descriptors = new BandDescriptor[memberCount];
        Dddb dddb = Dddb.getInstance();
        String formatName = smosFile.getDataFormat().getName();
        for (int j = 0; j < memberCount; ++j) {
            String memberName = type.getMemberName(j);
            BandDescriptor descriptor2 = dddb.findBandDescriptorForMember(formatName, memberName);
            columnClasses[j] = descriptor2 == null || descriptor2.getScalingFactor() == 1.0 && descriptor2.getScalingOffset() == 0.0 ? NumberUtils.getNumericMemberType((CompoundType)type, (int)j) : Double.class;
            descriptors[j] = descriptor2;
        }
        Number[][] tableData = new Number[btDataListCount][memberCount];
        for (int i = 0; i < btDataListCount; ++i) {
            CompoundData btData = btDataList.getCompound(i);
            for (int j = 0; j < memberCount; ++j) {
                Number member = NumberUtils.getNumericMember((CompoundData)btData, (int)j);
                descriptor = descriptors[j];
                tableData[i][j] = descriptor == null || descriptor.getScalingFactor() == 1.0 && descriptor.getScalingOffset() == 0.0 ? (Number)member : (Number)(member.doubleValue() * descriptor.getScalingFactor() + descriptor.getScalingOffset());
            }
        }
        HashMap<String, Integer> memberNamesMap = this.getRawDataMemberNamesMap(smosFile);
        GridPointBtDataset btDataset = new GridPointBtDataset(memberNamesMap, columnClasses, tableData);
        for (int i = 0; i < memberCount; ++i) {
            String memberName = type.getMemberName(i);
            descriptor = dddb.findBandDescriptorForMember(formatName, memberName);
            if (!StringUtils.isNotNullAndNotEmpty((String)descriptor.getFlagCodingName())) continue;
            btDataset.setFlagBandIndex(i);
            btDataset.setPolarisationFlagBandIndex(i);
            break;
        }
        if ((incidence_angle = memberNamesMap.get("Incidence_Angle")) != null) {
            btDataset.setIncidenceAngleBandIndex(incidence_angle);
        }
        if ((pixel_radiometric_accuracy = memberNamesMap.get("Pixel_Radiometric_Accuracy")) != null) {
            btDataset.setRadiometricAccuracyBandIndex(pixel_radiometric_accuracy);
        }
        if ((bt_value_real = memberNamesMap.get("BT_Value_Real")) != null) {
            btDataset.setBTValueRealBandIndex(bt_value_real);
        }
        if ((bt_value_imag = memberNamesMap.get("BT_Value_Imag")) != null) {
            btDataset.setBTValueImaginaryBandIndex(bt_value_imag);
        }
        return btDataset;
    }

    @Override
    public String[] getRawDataTableNames() {
        if (this.productFile instanceof L1cSmosFile) {
            L1cSmosFile smosFile = (L1cSmosFile)this.productFile;
            CompoundType btDataType = smosFile.getBtDataType();
            CompoundMember[] members = btDataType.getMembers();
            String[] names = new String[members.length];
            for (int i = 0; i < names.length; ++i) {
                CompoundMember member = members[i];
                names[i] = member.getName();
            }
            return names;
        }
        return new String[0];
    }

    @Override
    public FlagDescriptor[] getBtFlagDescriptors() {
        if (this.productFile instanceof L1cSmosFile) {
            L1cSmosFile smosFile = (L1cSmosFile)this.productFile;
            String dataFormatName = smosFile.getDataFormat().getName();
            Family<BandDescriptor> bandDescriptors = Dddb.getInstance().getBandDescriptors(dataFormatName);
            List<BandDescriptor> bandDescriptorsList = bandDescriptors.asList();
            for (BandDescriptor descriptor : bandDescriptorsList) {
                Family<FlagDescriptor> flagDescriptors = descriptor.getFlagDescriptors();
                if (flagDescriptors == null) continue;
                List<FlagDescriptor> flagDescriptorList = descriptor.getFlagDescriptors().asList();
                return flagDescriptorList.toArray(new FlagDescriptor[0]);
            }
        }
        return new FlagDescriptor[0];
    }

    @Override
    public PolarisationModel getPolarisationModel() {
        return new L1cPolarisationModel();
    }

    @Override
    public boolean canSupplySnapshotData() {
        return this.productFile instanceof L1cScienceSmosFile;
    }

    @Override
    public boolean hasSnapshotInfo() {
        if (this.productFile instanceof L1cScienceSmosFile) {
            return ((L1cScienceSmosFile)this.productFile).hasSnapshotInfo();
        }
        return false;
    }

    @Override
    public SnapshotInfo getSnapshotInfo() {
        if (this.productFile instanceof L1cScienceSmosFile) {
            return ((L1cScienceSmosFile)this.productFile).getSnapshotInfo();
        }
        return null;
    }

    @Override
    public Object[][] getSnapshotData(int snapshotIndex) throws IOException {
        if (this.productFile instanceof L1cScienceSmosFile) {
            CompoundData data = ((L1cScienceSmosFile)this.productFile).getSnapshotData(snapshotIndex);
            CompoundType compoundType = data.getType();
            int memberCount = data.getMemberCount();
            ArrayList<Object[]> list = new ArrayList<Object[]>(memberCount);
            for (int i = 0; i < memberCount; ++i) {
                String memberName = compoundType.getMemberName(i);
                Object[] entry = new Object[2];
                entry[0] = memberName;
                Type memberType = compoundType.getMemberType(i);
                if ("Flags".equals(memberName)) {
                    Number flagValue;
                    SnapshotInfo snapshotInfo = this.getSnapshotInfo();
                    List<FlagDescriptor> rfiFlagDescriptors = snapshotInfo.getRfiFlagDescriptors();
                    try {
                        flagValue = NumberUtils.getNumericMember((CompoundData)data, (int)i);
                    }
                    catch (IOException e) {
                        entry[1] = "Failed reading data";
                        list.add(entry);
                        continue;
                    }
                    if (rfiFlagDescriptors == null) {
                        entry[1] = flagValue;
                        list.add(entry);
                        continue;
                    }
                    for (FlagDescriptor descriptor : rfiFlagDescriptors) {
                        int flag;
                        Object[] flagEntry = new Object[2];
                        String flagName = memberName + "." + descriptor.getFlagName();
                        flagEntry[0] = flagName;
                        int mask = descriptor.getMask();
                        flagEntry[1] = (mask & (flag = flagValue.intValue())) == mask;
                        list.add(flagEntry);
                    }
                    continue;
                }
                if (memberType.isSimpleType()) {
                    try {
                        entry[1] = NumberUtils.getNumericMember((CompoundData)data, (int)i);
                    }
                    catch (IOException e) {
                        entry[1] = "Failed reading data";
                    }
                    list.add(entry);
                    continue;
                }
                if (memberType.isSequenceType()) {
                    SequenceData sequenceData = data.getSequence(i);
                    int numSequenceElems = sequenceData.getElementCount();
                    for (int n = 0; n < numSequenceElems; ++n) {
                        Object[] sequenceEntry = new Object[]{entry[0] + "_" + n, Float.valueOf(sequenceData.getFloat(n))};
                        list.add(sequenceEntry);
                    }
                    continue;
                }
                if (!"Snapshot_Time".equals(memberName)) continue;
                try {
                    Date date = DateTimeUtils.cfiDateToUtc((CompoundData)data);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz", Locale.ENGLISH);
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    entry[1] = dateFormat.format(date);
                }
                catch (IOException e) {
                    entry[1] = "Failed reading data";
                }
                list.add(entry);
            }
            return (Object[][])list.toArray((T[])new Object[2][list.size()]);
        }
        return new Object[0][];
    }

    private HashMap<String, Integer> getRawDataMemberNamesMap(L1cSmosFile smosFile) {
        CompoundType btDataType = smosFile.getBtDataType();
        CompoundMember[] members = btDataType.getMembers();
        HashMap<String, Integer> memberNamesMap = new HashMap<String, Integer>();
        for (int i = 0; i < members.length; ++i) {
            CompoundMember member = members[i];
            memberNamesMap.put(member.getName(), i);
        }
        return memberNamesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Product readProductNodesImpl() throws IOException {
        SmosProductReader smosProductReader = this;
        synchronized (smosProductReader) {
            File inputFile = this.getInputFile();
            String inputFileName = inputFile.getName();
            this.productFile = SmosUtils.isDblFileName((String)inputFileName) ? SmosProductReader.createProductFile(inputFile) : SmosProductReader.createProductFile(this.getInputVirtualDir());
            if (this.productFile == null) {
                throw new IOException(MessageFormat.format("File ''{0}'': unknown/unsupported SMOS data format.", inputFile));
            }
            Product product = this.productFile.createProduct();
            if (this.virtualDir != null && this.virtualDir.isCompressed()) {
                String path = this.virtualDir.getBasePath();
                product.setFileLocation(new File(path));
            } else {
                product.setFileLocation(this.productFile.getDataFile());
            }
            if (this.productFile instanceof SmosFile) {
                this.addLandSeaMask(product);
            }
            return product;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band targetBand, int targetOffsetX, int targetOffsetY, int targetWidth, int targetHeight, ProductData targetBuffer, ProgressMonitor pm) {
        SmosProductReader smosProductReader = this;
        synchronized (smosProductReader) {
            MultiLevelImage image = targetBand.getSourceImage();
            Raster data = image.getData(new Rectangle(targetOffsetX, targetOffsetY, targetWidth, targetHeight));
            data.getDataElements(targetOffsetX, targetOffsetY, targetWidth, targetHeight, targetBuffer.getElems());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        SmosProductReader smosProductReader = this;
        synchronized (smosProductReader) {
            this.productFile.close();
            if (this.virtualDir != null) {
                this.virtualDir.close();
            }
            super.close();
        }
    }

    private VirtualDir getInputVirtualDir() {
        File inputFile = this.getInputFile();
        if (!SmosUtils.isCompressedFile((File)inputFile)) {
            inputFile = inputFile.getParentFile();
        }
        this.virtualDir = VirtualDir.create((File)inputFile);
        if (this.virtualDir == null) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal input: {0}", inputFile));
        }
        return this.virtualDir;
    }

    private void addLandSeaMask(Product product) {
        BandDescriptor descriptor = Dddb.getInstance().getBandDescriptors(LSMASK_SCHEMA_NAME).getMember("Land_Sea_Mask");
        Band band = product.addBand(descriptor.getBandName(), 20);
        band.setScalingOffset(descriptor.getScalingOffset());
        band.setScalingFactor(descriptor.getScalingFactor());
        if (descriptor.hasFillValue()) {
            band.setNoDataValueUsed(true);
            band.setNoDataValue(descriptor.getFillValue());
        }
        if (!descriptor.getValidPixelExpression().isEmpty()) {
            band.setValidPixelExpression(descriptor.getValidPixelExpression());
        }
        if (!descriptor.getUnit().isEmpty()) {
            band.setUnit(descriptor.getUnit());
        }
        if (!descriptor.getDescription().isEmpty()) {
            band.setDescription(descriptor.getDescription());
        }
        if (descriptor.getFlagDescriptors() != null) {
            ProductHelper.addFlagsAndMasks(product, band, descriptor.getFlagCodingName(), descriptor.getFlagDescriptors());
        }
        band.setSourceImage(SmosLsMask.getInstance().getMultiLevelImage());
        band.setImageInfo(ProductHelper.createImageInfo(band, descriptor));
    }
}

