/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.jai.NoDataRaster;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.UnpackedImageData;
import org.esa.smos.dataio.smos.provider.ValueProvider;
import org.esa.smos.dgg.SmosDgg;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.SingleBandedOpImage;

class SmosOpImage
extends SingleBandedOpImage {
    private final ValueProvider valueProvider;
    private final MultiLevelModel model;
    private final double noDataValue;
    private volatile Area area;
    private volatile NoDataRaster noDataRaster;

    SmosOpImage(ValueProvider valueProvider, RasterDataNode rasterDataNode, MultiLevelModel model, ResolutionLevel level) {
        super(ImageManager.getDataBufferType((int)rasterDataNode.getDataType()), rasterDataNode.getRasterWidth(), rasterDataNode.getRasterHeight(), rasterDataNode.getProduct().getPreferredTileSize(), null, level);
        this.valueProvider = valueProvider;
        this.model = model;
        this.noDataValue = rasterDataNode.getNoDataValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Area getArea() {
        if (this.area == null) {
            SmosOpImage smosOpImage = this;
            synchronized (smosOpImage) {
                if (this.area == null) {
                    Area modelArea = this.valueProvider.getArea();
                    this.area = modelArea.createTransformedArea(this.model.getModelToImageTransform(this.getLevel()));
                }
            }
        }
        return this.area;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster computeTile(int tileX, int tileY) {
        if (this.getArea().intersects(this.getTileRect(tileX, tileY))) {
            return super.computeTile(tileX, tileY);
        }
        if (this.noDataRaster == null) {
            SmosOpImage smosOpImage = this;
            synchronized (smosOpImage) {
                if (this.noDataRaster == null) {
                    this.noDataRaster = this.createNoDataRaster(this.noDataValue);
                }
            }
        }
        return this.noDataRaster.createTranslatedChild(this.tileXToX(tileX), this.tileYToY(tileY));
    }

    protected final void computeRect(PlanarImage[] planarImages, WritableRaster targetRaster, Rectangle rectangle) {
        RenderedImage seqnumImage = SmosDgg.getInstance().getMultiLevelImage().getImage(this.getLevel());
        Raster seqnumRaster = seqnumImage.getData(rectangle);
        ColorModel cm = this.getColorModel();
        PixelAccessor seqnumAccessor = new PixelAccessor(seqnumRaster.getSampleModel(), cm);
        PixelAccessor targetAccessor = new PixelAccessor(targetRaster.getSampleModel(), null);
        UnpackedImageData seqnumData = seqnumAccessor.getPixels(seqnumRaster, rectangle, seqnumRaster.getSampleModel().getTransferType(), false);
        UnpackedImageData targetData = targetAccessor.getPixels((Raster)targetRaster, rectangle, targetRaster.getSampleModel().getTransferType(), true);
        PixelCounter pixelCounter = new PixelCounter(rectangle, this.getArea());
        switch (targetData.type) {
            case 0: {
                this.byteLoop(seqnumData, targetData, pixelCounter, (byte)this.noDataValue);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(seqnumData, targetData, pixelCounter, (short)this.noDataValue);
                break;
            }
            case 3: {
                this.intLoop(seqnumData, targetData, pixelCounter, (int)this.noDataValue);
                break;
            }
            case 4: {
                this.floatLoop(seqnumData, targetData, pixelCounter, (float)this.noDataValue);
                break;
            }
        }
        targetAccessor.setPixels(targetData);
    }

    private void byteLoop(UnpackedImageData seqnumData, UnpackedImageData targetData, PixelCounter pixelCounter, byte noDataValue) {
        int w = targetData.rect.width;
        int h = targetData.rect.height;
        int seqnumPixelStride = seqnumData.pixelStride;
        int seqnumLineStride = seqnumData.lineStride;
        int[] seqnumDataArray = seqnumData.getIntData(0);
        int targetPixelStride = targetData.pixelStride;
        int targetLineStride = targetData.lineStride;
        byte[] targetDataArray = targetData.getByteData(0);
        int[] seqnumCache = new int[w];
        byte[] valueCache = new byte[w];
        int seqnumLineOffset = seqnumData.getOffset(0);
        int targetLineOffset = targetData.getOffset(0);
        for (int y = 0; y < h; ++y) {
            int seqnumPixelOffset = seqnumLineOffset;
            int targetPixelOffset = targetLineOffset;
            pixelCounter.countPixels(targetData.rect.y + y);
            if (pixelCounter.leading > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.leading, noDataValue);
                targetPixelOffset += pixelCounter.leading * targetPixelStride;
                seqnumPixelOffset += pixelCounter.leading * seqnumPixelStride;
            }
            if (pixelCounter.valid > 0) {
                for (int x = pixelCounter.leading; x < pixelCounter.leading + pixelCounter.valid; ++x) {
                    int seqnum = seqnumDataArray[seqnumPixelOffset];
                    byte value = x > 0 && seqnumCache[x - 1] == seqnum ? valueCache[x - 1] : (y > 0 && seqnumCache[x] == seqnum ? valueCache[x] : (x + 1 < w && y > 0 && seqnumCache[x + 1] == seqnum ? valueCache[x + 1] : this.valueProvider.getValue(seqnum, noDataValue)));
                    seqnumCache[x] = seqnum;
                    valueCache[x] = value;
                    targetDataArray[targetPixelOffset] = value;
                    seqnumPixelOffset += seqnumPixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
            if (pixelCounter.trailing > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.trailing, noDataValue);
            }
            seqnumLineOffset += seqnumLineStride;
            targetLineOffset += targetLineStride;
        }
    }

    private void shortLoop(UnpackedImageData seqnumData, UnpackedImageData targetData, PixelCounter pixelCounter, short noDataValue) {
        int w = targetData.rect.width;
        int h = targetData.rect.height;
        int seqnumPixelStride = seqnumData.pixelStride;
        int seqnumLineStride = seqnumData.lineStride;
        int[] seqnumDataArray = seqnumData.getIntData(0);
        int targetPixelStride = targetData.pixelStride;
        int targetLineStride = targetData.lineStride;
        short[] targetDataArray = targetData.getShortData(0);
        int[] seqnumCache = new int[w];
        short[] valueCache = new short[w];
        int seqnumLineOffset = seqnumData.getOffset(0);
        int targetLineOffset = targetData.getOffset(0);
        for (int y = 0; y < h; ++y) {
            int seqnumPixelOffset = seqnumLineOffset;
            int targetPixelOffset = targetLineOffset;
            pixelCounter.countPixels(targetData.rect.y + y);
            if (pixelCounter.leading > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.leading, noDataValue);
                targetPixelOffset += pixelCounter.leading * targetPixelStride;
                seqnumPixelOffset += pixelCounter.leading * seqnumPixelStride;
            }
            if (pixelCounter.valid > 0) {
                for (int x = pixelCounter.leading; x < pixelCounter.leading + pixelCounter.valid; ++x) {
                    int seqnum = seqnumDataArray[seqnumPixelOffset];
                    short value = x > 0 && seqnumCache[x - 1] == seqnum ? valueCache[x - 1] : (y > 0 && seqnumCache[x] == seqnum ? valueCache[x] : (x + 1 < w && y > 0 && seqnumCache[x + 1] == seqnum ? valueCache[x + 1] : this.valueProvider.getValue(seqnum, noDataValue)));
                    seqnumCache[x] = seqnum;
                    valueCache[x] = value;
                    targetDataArray[targetPixelOffset] = value;
                    seqnumPixelOffset += seqnumPixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
            if (pixelCounter.trailing > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.trailing, noDataValue);
            }
            seqnumLineOffset += seqnumLineStride;
            targetLineOffset += targetLineStride;
        }
    }

    private void intLoop(UnpackedImageData seqnumData, UnpackedImageData targetData, PixelCounter pixelCounter, int noDataValue) {
        int w = targetData.rect.width;
        int h = targetData.rect.height;
        int seqnumPixelStride = seqnumData.pixelStride;
        int seqnumLineStride = seqnumData.lineStride;
        int[] seqnumDataArray = seqnumData.getIntData(0);
        int targetPixelStride = targetData.pixelStride;
        int targetLineStride = targetData.lineStride;
        int[] targetDataArray = targetData.getIntData(0);
        int[] seqnumCache = new int[w];
        int[] valueCache = new int[w];
        int seqnumLineOffset = seqnumData.getOffset(0);
        int targetLineOffset = targetData.getOffset(0);
        for (int y = 0; y < h; ++y) {
            int seqnumPixelOffset = seqnumLineOffset;
            int targetPixelOffset = targetLineOffset;
            pixelCounter.countPixels(targetData.rect.y + y);
            if (pixelCounter.leading > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.leading, noDataValue);
                targetPixelOffset += pixelCounter.leading * targetPixelStride;
                seqnumPixelOffset += pixelCounter.leading * seqnumPixelStride;
            }
            if (pixelCounter.valid > 0) {
                for (int x = pixelCounter.leading; x < pixelCounter.leading + pixelCounter.valid; ++x) {
                    int seqnum = seqnumDataArray[seqnumPixelOffset];
                    int value = x > 0 && seqnumCache[x - 1] == seqnum ? valueCache[x - 1] : (y > 0 && seqnumCache[x] == seqnum ? valueCache[x] : (x + 1 < w && y > 0 && seqnumCache[x + 1] == seqnum ? valueCache[x + 1] : this.valueProvider.getValue(seqnum, noDataValue)));
                    seqnumCache[x] = seqnum;
                    valueCache[x] = value;
                    targetDataArray[targetPixelOffset] = value;
                    seqnumPixelOffset += seqnumPixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
            if (pixelCounter.trailing > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.trailing, noDataValue);
            }
            seqnumLineOffset += seqnumLineStride;
            targetLineOffset += targetLineStride;
        }
    }

    private void floatLoop(UnpackedImageData seqnumData, UnpackedImageData targetData, PixelCounter pixelCounter, float noDataValue) {
        int w = targetData.rect.width;
        int h = targetData.rect.height;
        int seqnumPixelStride = seqnumData.pixelStride;
        int seqnumLineStride = seqnumData.lineStride;
        int[] seqnumDataArray = seqnumData.getIntData(0);
        int targetPixelStride = targetData.pixelStride;
        int targetLineStride = targetData.lineStride;
        float[] targetDataArray = targetData.getFloatData(0);
        int[] seqnumCache = new int[w];
        float[] valueCache = new float[w];
        int seqnumLineOffset = seqnumData.getOffset(0);
        int targetLineOffset = targetData.getOffset(0);
        for (int y = 0; y < h; ++y) {
            int seqnumPixelOffset = seqnumLineOffset;
            int targetPixelOffset = targetLineOffset;
            pixelCounter.countPixels(targetData.rect.y + y);
            if (pixelCounter.leading > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.leading, noDataValue);
                targetPixelOffset += pixelCounter.leading * targetPixelStride;
                seqnumPixelOffset += pixelCounter.leading * seqnumPixelStride;
            }
            if (pixelCounter.valid > 0) {
                for (int x = pixelCounter.leading; x < pixelCounter.leading + pixelCounter.valid; ++x) {
                    int seqnum = seqnumDataArray[seqnumPixelOffset];
                    float value = x > 0 && seqnumCache[x - 1] == seqnum ? valueCache[x - 1] : (y > 0 && seqnumCache[x] == seqnum ? valueCache[x] : (x + 1 < w && y > 0 && seqnumCache[x + 1] == seqnum ? valueCache[x + 1] : this.valueProvider.getValue(seqnum, noDataValue)));
                    seqnumCache[x] = seqnum;
                    valueCache[x] = value;
                    targetDataArray[targetPixelOffset] = value;
                    seqnumPixelOffset += seqnumPixelStride;
                    targetPixelOffset += targetPixelStride;
                }
            }
            if (pixelCounter.trailing > 0) {
                Arrays.fill(targetDataArray, targetPixelOffset, targetPixelOffset + pixelCounter.trailing, noDataValue);
            }
            seqnumLineOffset += seqnumLineStride;
            targetLineOffset += targetLineStride;
        }
    }

    private static class PixelCounter {
        private final Rectangle effectiveBounds;
        private final Rectangle targetRectangle;
        private int leading;
        private int valid;
        private int trailing;

        PixelCounter(Rectangle targetRectangle, Area envelope) {
            Area effectiveEnvelope = new Area(targetRectangle);
            effectiveEnvelope.intersect(envelope);
            this.effectiveBounds = effectiveEnvelope.getBounds();
            this.targetRectangle = targetRectangle;
        }

        void countPixels(int y) {
            if (y < this.effectiveBounds.y || y > this.effectiveBounds.y + this.effectiveBounds.height) {
                this.leading = this.targetRectangle.width;
                this.valid = 0;
                this.trailing = 0;
            } else {
                this.leading = this.effectiveBounds.x - this.targetRectangle.x;
                this.valid = this.effectiveBounds.width;
                this.trailing = this.targetRectangle.width - this.leading - this.valid;
            }
        }
    }
}

