/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import org.esa.smos.dataio.smos.SmosOpImage;
import org.esa.smos.dataio.smos.provider.ValueProvider;
import org.esa.smos.dgg.SmosDgg;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ResolutionLevel;

public class SmosMultiLevelSource
extends AbstractMultiLevelSource {
    private final RasterDataNode rasterDataNode;
    private final ValueProvider valueProvider;

    public SmosMultiLevelSource(RasterDataNode rasterDataNode, ValueProvider valueProvider) {
        super(SmosDgg.getInstance().getMultiLevelImage().getModel());
        this.valueProvider = valueProvider;
        this.rasterDataNode = rasterDataNode;
    }

    public ValueProvider getValueProvider() {
        return this.valueProvider;
    }

    public Shape getImageShape(int level) {
        return this.valueProvider.getArea().createTransformedArea(this.getModel().getModelToImageTransform(level));
    }

    protected RenderedImage createImage(int level) {
        return new SmosOpImage(this.valueProvider, this.rasterDataNode, this.getModel(), ResolutionLevel.create((MultiLevelModel)this.getModel(), (int)level));
    }
}

