/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.binio.DataContext;
import java.io.IOException;
import org.esa.smos.EEFilePair;
import org.esa.smos.dataio.smos.SmosFile;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.util.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

class SmUserSmosFile
extends SmosFile {
    private final double chi2Scale;

    SmUserSmosFile(EEFilePair eeFilePair, DataContext dataContext) throws IOException {
        super(eeFilePair, dataContext);
        Document document = this.getDocument();
        Namespace namespace = document.getRootElement().getNamespace();
        Element specificProductHeader = this.getElement(document.getRootElement(), "Specific_Product_Header");
        String chi_2_scale = specificProductHeader.getChildText("Chi_2_Scale", namespace);
        this.chi2Scale = StringUtils.isNotNullAndNotEmpty((String)chi_2_scale) ? Double.valueOf(chi_2_scale) : 1.0;
    }

    @Override
    protected void setScaling(Band band, BandDescriptor descriptor) {
        String memberName = descriptor.getMemberName();
        if ("Chi_2".equals(memberName)) {
            band.setScalingFactor(descriptor.getScalingFactor() * this.chi2Scale);
        } else {
            super.setScaling(band, descriptor);
        }
    }
}

