/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Random;
import org.esa.smos.dataio.smos.ExplorerFile;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dgg.SmosDgg;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.io.FileUtils;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class ProductHelper {
    private ProductHelper() {
    }

    public static ImageInfo createImageInfo(Band band, BandDescriptor descriptor) {
        if (descriptor.getBandName().equalsIgnoreCase("Soil_Moisture")) {
            return ProductHelper.createSoilMoistureImageInfo();
        }
        if (descriptor.getBandName().contains("Tau_Nad_")) {
            return ProductHelper.createTauNadImageInfo();
        }
        Color[] colors = descriptor.isCyclic() ? new Color[]{new Color(85, 0, 136), new Color(0, 0, 255), new Color(0, 255, 255), new Color(0, 255, 0), new Color(255, 255, 0), new Color(255, 140, 0), new Color(255, 0, 0), new Color(255, 140, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(0, 0, 255), new Color(85, 0, 136)} : new Color[]{new Color(0, 0, 0), new Color(85, 0, 136), new Color(0, 0, 255), new Color(0, 255, 255), new Color(0, 255, 0), new Color(255, 255, 0), new Color(255, 140, 0), new Color(255, 0, 0)};
        double min = descriptor.hasTypicalMin() ? descriptor.getTypicalMin() : band.getStx().getMinimum();
        double max = descriptor.hasTypicalMax() ? descriptor.getTypicalMax() : band.getStx().getMaximum();
        ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            double sample = min + (max - min) * (double)i / (double)(colors.length - 1);
            points[i] = new ColorPaletteDef.Point(sample, colors[i]);
        }
        return new ImageInfo(new ColorPaletteDef(points));
    }

    private static ImageInfo createSoilMoistureImageInfo() {
        ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[]{new ColorPaletteDef.Point(0.0, new Color(255, 136, 0)), new ColorPaletteDef.Point(0.05, new Color(237, 190, 0)), new ColorPaletteDef.Point(0.1, new Color(225, 221, 0)), new ColorPaletteDef.Point(0.2, new Color(106, 193, 0)), new ColorPaletteDef.Point(1.0, new Color(0, 0, 153))};
        return new ImageInfo(new ColorPaletteDef(points));
    }

    private static ImageInfo createTauNadImageInfo() {
        ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[]{new ColorPaletteDef.Point(0.0, new Color(213, 255, 135)), new ColorPaletteDef.Point(0.15, new Color(135, 181, 0)), new ColorPaletteDef.Point(1.2, new Color(0, 45, 0))};
        return new ImageInfo(new ColorPaletteDef(points));
    }

    public static GeoCoding createGeoCoding(Dimension dimension) {
        AffineTransform transform = SmosDgg.getInstance().getImageToMapTransform();
        try {
            return new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, new Rectangle(dimension), transform);
        }
        catch (FactoryException | TransformException e) {
            throw new IllegalArgumentException("dimension");
        }
    }

    public static Dimension getSceneRasterDimension() {
        MultiLevelImage dggMultiLevelImage = SmosDgg.getInstance().getMultiLevelImage();
        int w = dggMultiLevelImage.getWidth();
        int h = dggMultiLevelImage.getHeight();
        return new Dimension(w, h);
    }

    public static Product createProduct(File inputFile, String productType) {
        String productName = FileUtils.getFilenameWithoutExtension((File)inputFile);
        Dimension dimension = ProductHelper.getSceneRasterDimension();
        Product product = new Product(productName, productType, dimension.width, dimension.height);
        product.setFileLocation(inputFile);
        product.setPreferredTileSize(512, 512);
        product.setSceneGeoCoding(ProductHelper.createGeoCoding(dimension));
        return product;
    }

    public static int getDataType(Type memberType) {
        if (memberType.equals(SimpleType.BYTE)) {
            return 10;
        }
        if (memberType.equals(SimpleType.UBYTE)) {
            return 20;
        }
        if (memberType.equals(SimpleType.SHORT)) {
            return 11;
        }
        if (memberType.equals(SimpleType.USHORT)) {
            return 21;
        }
        if (memberType.equals(SimpleType.INT)) {
            return 12;
        }
        if (memberType.equals(SimpleType.UINT)) {
            return 22;
        }
        if (memberType.equals(SimpleType.FLOAT)) {
            return 30;
        }
        if (memberType.equals(SimpleType.DOUBLE)) {
            return 31;
        }
        if (memberType.equals(SimpleType.ULONG)) {
            return 22;
        }
        throw new IllegalArgumentException("Illegal member type:" + memberType.getName());
    }

    public static void addMetadata(MetadataElement metadataElement, ExplorerFile explorerFile) throws IOException {
        Document document;
        try {
            document = new SAXBuilder().build(explorerFile.getHeaderFile());
        }
        catch (JDOMException e) {
            throw new IOException(MessageFormat.format("File ''{0}'': Invalid document", explorerFile.getHeaderFile().getPath()), e);
        }
        Namespace namespace = document.getRootElement().getNamespace();
        if (namespace == null) {
            throw new IOException(MessageFormat.format("File ''{0}'': Missing namespace", explorerFile.getHeaderFile().getPath()));
        }
        ProductHelper.addMetadata(metadataElement, document.getRootElement(), namespace);
    }

    static void addMetadata(MetadataElement metadataElement, Element xmlElement, Namespace namespace) {
        for (Object o : xmlElement.getChildren()) {
            Element xmlChild = (Element)o;
            if (xmlChild.getChildren(null, namespace).size() == 0) {
                String s = xmlChild.getTextNormalize();
                if (s == null || s.isEmpty()) continue;
                metadataElement.addAttribute(new MetadataAttribute(xmlChild.getName(), ProductData.createInstance((String)s), true));
                continue;
            }
            MetadataElement metadataChild = new MetadataElement(xmlChild.getName());
            metadataElement.addElement(metadataChild);
            ProductHelper.addMetadata(metadataChild, xmlChild, namespace);
        }
    }

    public static void addFlagsAndMasks(Product product, Band band, String flagCodingName, Family<FlagDescriptor> flagDescriptors) {
        FlagCoding flagCoding = (FlagCoding)product.getFlagCodingGroup().get(flagCodingName);
        if (flagCoding == null) {
            flagCoding = new FlagCoding(flagCodingName);
            for (FlagDescriptor flagDescriptor : flagDescriptors.asList()) {
                flagCoding.addFlag(flagDescriptor.getFlagName(), flagDescriptor.getMask(), flagDescriptor.getDescription());
            }
            product.getFlagCodingGroup().add((ProductNode)flagCoding);
        }
        band.setSampleCoding((SampleCoding)flagCoding);
        Random random = new Random(5489L);
        for (FlagDescriptor flagDescriptor : flagDescriptors.asList()) {
            String maskName = band.getName() + "_" + flagDescriptor.getFlagName();
            if (product.getMaskGroup().contains(maskName)) continue;
            Color color = flagDescriptor.getColor();
            if (color == null) {
                color = new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255));
            }
            String expression = band.getName() + "." + flagDescriptor.getFlagName();
            Mask mask = Mask.BandMathsType.create((String)maskName, (String)flagDescriptor.getDescription(), (int)product.getSceneRasterWidth(), (int)product.getSceneRasterHeight(), (String)expression, (Color)color, (double)0.5);
            product.getMaskGroup().add((ProductNode)mask);
        }
    }

    public static void addVirtualBand(Product product, BandDescriptor descriptor, String bandExpression) {
        VirtualBand virtualBand = new VirtualBand(descriptor.getBandName(), 30, product.getSceneRasterWidth(), product.getSceneRasterHeight(), bandExpression);
        String validPixelExpression = ProductHelper.createValidPixelExpression(product, bandExpression);
        virtualBand.setValidPixelExpression(validPixelExpression);
        virtualBand.setImageInfo(ProductHelper.createImageInfo((Band)virtualBand, descriptor));
        virtualBand.setDescription(descriptor.getDescription());
        virtualBand.setUnit(descriptor.getUnit());
        virtualBand.setGeophysicalNoDataValue(descriptor.getFillValue());
        virtualBand.setNoDataValueUsed(descriptor.hasFillValue());
        product.addBand((Band)virtualBand);
    }

    static String createValidPixelExpression(Product product, String expression) {
        try {
            return BandArithmetic.getValidMaskExpression((String)expression, (Product[])new Product[]{product}, (int)0, null);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

