/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.dataio.smos;

import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.Type;
import java.io.IOException;
import java.text.MessageFormat;
import org.esa.smos.EEFilePair;
import org.esa.smos.dataio.smos.SmosFile;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.snap.core.datamodel.Band;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class L1cSmosFile
extends SmosFile {
    private final int btDataListIndex;
    private final CompoundType btDataType;
    private final double radiometricAccuracyScale;
    private final double pixelFootprintScale;

    protected L1cSmosFile(EEFilePair eeFilePair, DataContext dataContext) throws IOException {
        super(eeFilePair, dataContext);
        Document document = this.getDocument();
        Namespace namespace = document.getRootElement().getNamespace();
        Element specificProductHeader = this.getElement(document.getRootElement(), "Specific_Product_Header");
        this.radiometricAccuracyScale = Double.valueOf(specificProductHeader.getChildText("Radiometric_Accuracy_Scale", namespace));
        this.pixelFootprintScale = Double.valueOf(specificProductHeader.getChildText("Pixel_Footprint_Scale", namespace));
        this.btDataListIndex = this.getGridPointType().getMemberIndex("BT_Data");
        if (this.btDataListIndex == -1) {
            throw new IOException("Grid point type does not include BT data list.");
        }
        Type memberType = this.getGridPointType().getMemberType(this.btDataListIndex);
        if (!memberType.isSequenceType()) {
            throw new IOException(MessageFormat.format("Data type ''{0}'' is not of appropriate type", memberType.getName()));
        }
        Type elementType = ((SequenceType)memberType).getElementType();
        if (!elementType.isCompoundType()) {
            throw new IOException(MessageFormat.format("Data type ''{0}'' is not a compound type", elementType.getName()));
        }
        this.btDataType = (CompoundType)elementType;
    }

    @Override
    protected void setScaling(Band band, BandDescriptor descriptor) {
        String memberName = descriptor.getMemberName();
        if (memberName.startsWith("Footprint_Axis")) {
            band.setScalingFactor(descriptor.getScalingFactor() * this.pixelFootprintScale);
        } else if (memberName.startsWith("Pixel_Radiometric_Accuracy")) {
            band.setScalingFactor(descriptor.getScalingFactor() * this.radiometricAccuracyScale);
        } else if (memberName.startsWith("Radiometric_Accuracy_of_Pixel")) {
            band.setScalingFactor(descriptor.getScalingFactor() * this.radiometricAccuracyScale);
        } else {
            super.setScaling(band, descriptor);
        }
    }

    public final CompoundType getBtDataType() {
        return this.btDataType;
    }

    public final SequenceData getBtDataList(int gridPointIndex) throws IOException {
        return this.getGridPointData(gridPointIndex).getSequence(this.btDataListIndex);
    }
}

